/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import meowing.zen.Zen;
import meowing.zen.events.Event;
import meowing.zen.events.EventBus;
import meowing.zen.events.InternalEvent;
import meowing.zen.utils.DataUtils;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;

@Zen.Module
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lmeowing/zen/api/NEUApi;", "", "<init>", "()V", "client", "Lorg/apache/http/impl/client/CloseableHttpClient;", "NeuZipUrl", "", "isDownloading", "Ljava/util/concurrent/atomic/AtomicBoolean;", "NeuItemData", "Lmeowing/zen/utils/DataUtils;", "Lcom/google/gson/JsonObject;", "getNeuItemData", "()Lmeowing/zen/utils/DataUtils;", "setNeuItemData", "(Lmeowing/zen/utils/DataUtils;)V", "NeuMobData", "getNeuMobData", "setNeuMobData", "NeuConstantData", "getNeuConstantData", "setNeuConstantData", "etagData", "getEtagData", "downloadAndProcessRepo", "", "force", "", "zen"})
@SourceDebugExtension(value={"SMAP\nNEUApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NEUApi.kt\nmeowing/zen/api/NEUApi\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class NEUApi {
    @NotNull
    public static final NEUApi INSTANCE = new NEUApi();
    @NotNull
    private static CloseableHttpClient client;
    @NotNull
    private static final String NeuZipUrl = "https://github.com/NotEnoughUpdates/NotEnoughUpdates-Repo/archive/master.zip";
    @NotNull
    private static final AtomicBoolean isDownloading;
    @NotNull
    private static DataUtils<JsonObject> NeuItemData;
    @NotNull
    private static DataUtils<JsonObject> NeuMobData;
    @NotNull
    private static DataUtils<JsonObject> NeuConstantData;
    @NotNull
    private static final DataUtils<JsonObject> etagData;

    private NEUApi() {
    }

    @NotNull
    public final DataUtils<JsonObject> getNeuItemData() {
        return NeuItemData;
    }

    public final void setNeuItemData(@NotNull DataUtils<JsonObject> dataUtils) {
        Intrinsics.checkNotNullParameter(dataUtils, "<set-?>");
        NeuItemData = dataUtils;
    }

    @NotNull
    public final DataUtils<JsonObject> getNeuMobData() {
        return NeuMobData;
    }

    public final void setNeuMobData(@NotNull DataUtils<JsonObject> dataUtils) {
        Intrinsics.checkNotNullParameter(dataUtils, "<set-?>");
        NeuMobData = dataUtils;
    }

    @NotNull
    public final DataUtils<JsonObject> getNeuConstantData() {
        return NeuConstantData;
    }

    public final void setNeuConstantData(@NotNull DataUtils<JsonObject> dataUtils) {
        Intrinsics.checkNotNullParameter(dataUtils, "<set-?>");
        NeuConstantData = dataUtils;
    }

    @NotNull
    public final DataUtils<JsonObject> getEtagData() {
        return etagData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void downloadAndProcessRepo(boolean force) {
        block29: {
            if (!isDownloading.compareAndSet(false, true)) {
                return;
            }
            try {
                boolean matchesLastETag;
                HttpHead httpHead;
                Object object = etagData.getData().get("tag");
                if (object == null || (object = object.getAsString()) == null) {
                    object = "";
                }
                Object eTagString = object;
                HttpHead $this$downloadAndProcessRepo_u24lambda_u240 = httpHead = new HttpHead(NeuZipUrl);
                boolean bl = false;
                if (((CharSequence)eTagString).length() > 0) {
                    $this$downloadAndProcessRepo_u24lambda_u240.setHeader("If-None-Match", (String)eTagString);
                }
                HttpHead request = httpHead;
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                boolean bl2 = matchesLastETag = response.getStatusLine().getStatusCode() == 304;
                if (!matchesLastETag || force) {
                    InputStream inputStream;
                    CloseableHttpResponse closeableHttpResponse;
                    CloseableHttpResponse closeableHttpResponse2;
                    CloseableHttpResponse it = closeableHttpResponse2 = client.execute((HttpUriRequest)new HttpGet(NeuZipUrl));
                    boolean bl3 = false;
                    Object object2 = closeableHttpResponse = it.getStatusLine().getStatusCode() == 200 ? closeableHttpResponse2 : null;
                    if (closeableHttpResponse == null || (closeableHttpResponse2 = closeableHttpResponse.getEntity()) == null || (inputStream = closeableHttpResponse2.getContent()) == null) break block29;
                    Closeable closeable = inputStream;
                    Throwable throwable = null;
                    try {
                        InputStream zipStream = (InputStream)closeable;
                        boolean bl4 = false;
                        Closeable closeable2 = new ZipInputStream(zipStream);
                        Throwable throwable2 = null;
                        try {
                            String[] stringArray;
                            ZipInputStream zip2 = (ZipInputStream)closeable2;
                            boolean bl5 = false;
                            ZipEntry entry = zip2.getNextEntry();
                            JsonObject NeuItems = new JsonObject();
                            JsonObject NeuMobs = new JsonObject();
                            JsonObject NeuConstants = new JsonObject();
                            while (entry != null) {
                                String string = entry.getName();
                                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                                if (StringsKt.endsWith$default(string, ".json", false, 2, null)) {
                                    InputStream inputStream2 = zip2;
                                    stringArray = Charsets.UTF_8;
                                    Reader reader = new InputStreamReader(inputStream2, (Charset)stringArray);
                                    int n = 8192;
                                    String jsonContent = TextStreamsKt.readText(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n));
                                    String string2 = entry.getName();
                                    Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                                    stringArray = new String[]{"/"};
                                    String name = StringsKt.removeSuffix((String)CollectionsKt.last(StringsKt.split$default((CharSequence)string2, stringArray, false, 0, 6, null)), (CharSequence)".json");
                                    try {
                                        JsonObject value = new JsonParser().parse(jsonContent).getAsJsonObject();
                                        String string3 = entry.getName();
                                        Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                                        if (StringsKt.contains$default((CharSequence)string3, "/items/", false, 2, null)) {
                                            NeuItems.add(name, (JsonElement)value);
                                        } else {
                                            String string4 = entry.getName();
                                            Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
                                            if (StringsKt.contains$default((CharSequence)string4, "/mobs/", false, 2, null)) {
                                                NeuMobs.add(name, (JsonElement)value);
                                            } else {
                                                String string5 = entry.getName();
                                                Intrinsics.checkNotNullExpressionValue(string5, "getName(...)");
                                                if (StringsKt.contains$default((CharSequence)string5, "/constants/", false, 2, null)) {
                                                    NeuConstants.add(name, (JsonElement)value);
                                                }
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        Zen.LOGGER.error("Failed to parse JSON from entry " + entry.getName() + ", skipping...");
                                    }
                                }
                                entry = zip2.getNextEntry();
                            }
                            NeuItemData.setData(NeuItems);
                            NeuMobData.setData(NeuMobs);
                            NeuConstantData.setData(NeuConstants);
                            zip2.closeEntry();
                            Zen.LOGGER.info("NEU API data downloaded and processed successfully.");
                            Header header = response.getFirstHeader("ETag");
                            String newETag = header != null ? header.getValue() : null;
                            String[] $this$downloadAndProcessRepo_u24lambda_u244_u24lambda_u243_u24lambda_u242 = stringArray = new JsonObject();
                            boolean bl6 = false;
                            String string = newETag;
                            if (string == null) {
                                string = "";
                            }
                            $this$downloadAndProcessRepo_u24lambda_u244_u24lambda_u243_u24lambda_u242.addProperty("tag", string);
                            String[] newEtagJson = stringArray;
                            etagData.setData((JsonObject)newEtagJson);
                            Zen.LOGGER.info("Saved NEU API Data to file and updated ETag.");
                            NeuItemData.save();
                            NeuMobData.save();
                            NeuConstantData.save();
                            etagData.save();
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally(closeable2, throwable2);
                        }
                        Unit unit = Unit.INSTANCE;
                        break block29;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                }
                Zen.LOGGER.info("ETag matches. No need to download. Loading from file...");
                if (NeuItemData.getData().entrySet().isEmpty() || NeuMobData.getData().entrySet().isEmpty() || NeuConstantData.getData().entrySet().isEmpty()) {
                    Zen.LOGGER.warn("Failed to load NEU API data from file. Redownloading...");
                    isDownloading.set(false);
                    this.downloadAndProcessRepo(true);
                    return;
                }
            }
            finally {
                isDownloading.set(false);
                EventBus.INSTANCE.post((Event)new InternalEvent.NeuAPI.Load());
            }
        }
    }

    public static /* synthetic */ void downloadAndProcessRepo$default(NEUApi nEUApi, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        nEUApi.downloadAndProcessRepo(bl);
    }

    static {
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        Intrinsics.checkNotNullExpressionValue(closeableHttpClient, "createDefault(...)");
        client = closeableHttpClient;
        isDownloading = new AtomicBoolean(false);
        NeuItemData = new DataUtils<JsonObject>("NeuItems", new JsonObject());
        NeuMobData = new DataUtils<JsonObject>("NeuMobs", new JsonObject());
        NeuConstantData = new DataUtils<JsonObject>("NeuConstants", new JsonObject());
        etagData = new DataUtils<JsonObject>("NEUAPI-ETAG", new JsonObject());
    }
}

