/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import meowing.zen.Zen;
import meowing.zen.events.CancellableEvent;
import meowing.zen.events.ChatEvent;
import meowing.zen.events.Event;
import meowing.zen.events.EventBus;
import meowing.zen.events.GuiEvent;
import meowing.zen.events.PartyChangeType;
import meowing.zen.events.PartyEvent;
import meowing.zen.utils.ChatUtils;
import meowing.zen.utils.ItemUtils;
import meowing.zen.utils.LoopUtils;
import meowing.zen.utils.StringUtils;
import meowing.zen.utils.Utils;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Zen.Module
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0011H\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lmeowing/zen/api/PartyTracker;", "", "<init>", "()V", "destructionRegex", "Lkotlin/text/Regex;", "partyTransferRegex", "partyJoinRegex", "partyRemoveRegex", "joinPartyRegex", "partyListRegex", "partyDisconnectRegex", "partyDetailsRegex", "partyFinderJoinRegex", "partyFinderErrorRegex", "classLoreRegex", "hadProblemJoiningParty", "", "partyMembers", "", "", "Lmeowing/zen/api/PartyTracker$PartyMember;", "playerInParty", "hidePartyList", "addSelfToParty", "", "selfLeader", "handlePartyMessage", "clean", "PartyMember", "zen"})
@SourceDebugExtension(value={"SMAP\nPartyTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartyTracker.kt\nmeowing/zen/api/PartyTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 ItemUtils.kt\nmeowing/zen/utils/ItemUtils\n+ 6 Utils.kt\nmeowing/zen/utils/Utils\n+ 7 EventBus.kt\nmeowing/zen/events/EventBus\n+ 8 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n*L\n1#1,203:1\n1863#2,2:204\n1863#2:207\n1864#2:215\n1863#2,2:216\n1755#2,3:230\n1#3:206\n1#3:220\n1#3:228\n1#3:238\n1#3:247\n381#4,7:208\n25#5,2:218\n27#5:221\n25#5,2:226\n27#5:229\n41#6,4:222\n206#7:233\n194#7,2:234\n196#7,3:239\n206#7:242\n194#7,2:243\n196#7,3:248\n72#8,2:236\n72#8,2:245\n*S KotlinDebug\n*F\n+ 1 PartyTracker.kt\nmeowing/zen/api/PartyTracker\n*L\n131#1:204,2\n161#1:207\n161#1:215\n172#1:216,2\n68#1:230,3\n76#1:220\n68#1:228\n42#1:238\n60#1:247\n162#1:208,7\n76#1:218,2\n76#1:221\n68#1:226,2\n68#1:229\n62#1:222,4\n42#1:233\n42#1:234,2\n42#1:239,3\n60#1:242\n60#1:243,2\n60#1:248,3\n42#1:236,2\n60#1:245,2\n*E\n"})
public final class PartyTracker {
    @NotNull
    public static final PartyTracker INSTANCE;
    @NotNull
    private static final Regex destructionRegex;
    @NotNull
    private static final Regex partyTransferRegex;
    @NotNull
    private static final Regex partyJoinRegex;
    @NotNull
    private static final Regex partyRemoveRegex;
    @NotNull
    private static final Regex joinPartyRegex;
    @NotNull
    private static final Regex partyListRegex;
    @NotNull
    private static final Regex partyDisconnectRegex;
    @NotNull
    private static final Regex partyDetailsRegex;
    @NotNull
    private static final Regex partyFinderJoinRegex;
    @NotNull
    private static final Regex partyFinderErrorRegex;
    @NotNull
    private static final Regex classLoreRegex;
    private static boolean hadProblemJoiningParty;
    @NotNull
    private static final Map<String, PartyMember> partyMembers;
    private static boolean playerInParty;
    private static boolean hidePartyList;

    private PartyTracker() {
    }

    private final void addSelfToParty(boolean selfLeader) {
        playerInParty = true;
        Object object = Zen.Companion.getMc().field_71439_g;
        if (object == null || (object = object.func_70005_c_()) == null) {
            return;
        }
        Object playerName = object;
        if (!partyMembers.containsKey(playerName)) {
            partyMembers.put((String)playerName, new PartyMember((String)playerName, selfLeader, false, null, null, 28, null));
        }
    }

    private final void handlePartyMessage(String clean) {
        Object playerName;
        CharSequence charSequence = clean;
        if (partyJoinRegex.matches(charSequence)) {
            Object object = Regex.find$default(partyJoinRegex, clean, 0, 2, null);
            if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
                return;
            }
            playerName = object;
            partyMembers.put((String)playerName, new PartyMember((String)playerName, false, false, null, null, 30, null));
            this.addSelfToParty(true);
            ChatUtils.INSTANCE.command("/p list");
            hidePartyList = true;
            EventBus.INSTANCE.post((Event)new PartyEvent.Changed(PartyChangeType.MEMBER_JOINED, (String)playerName, MapsKt.toMap(partyMembers)));
        } else {
            playerName = clean;
            if (partyRemoveRegex.matches((CharSequence)playerName)) {
                Object object = Regex.find$default(partyRemoveRegex, clean, 0, 2, null);
                if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
                    return;
                }
                playerName = object;
                partyMembers.remove(playerName);
                playerInParty = true;
                EventBus.INSTANCE.post((Event)new PartyEvent.Changed(PartyChangeType.MEMBER_LEFT, (String)playerName, MapsKt.toMap(partyMembers)));
            } else if (Intrinsics.areEqual(clean, "You have been kicked from the party")) {
                partyMembers.clear();
                playerInParty = false;
                EventBus.INSTANCE.post((Event)new PartyEvent.Changed(PartyChangeType.PLAYER_LEFT, null, MapsKt.toMap(partyMembers)));
            } else {
                Object match;
                playerName = clean;
                if (partyTransferRegex.matches((CharSequence)playerName)) {
                    MatchResult matchResult = Regex.find$default(partyTransferRegex, clean, 0, 2, null);
                    if (matchResult == null) {
                        return;
                    }
                    match = matchResult;
                    Iterable $this$forEach$iv = partyMembers.values();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PartyMember it = (PartyMember)element$iv;
                        boolean bl = false;
                        it.setLeader(false);
                    }
                    Object object = RegexExtensionsJDK8Kt.get(match.getGroups(), "newLeader");
                    if (object == null || (object = ((MatchGroup)object).getValue()) == null) {
                        return;
                    }
                    Object newLeader = object;
                    MatchGroup matchGroup = RegexExtensionsJDK8Kt.get(match.getGroups(), "leavingPlayer");
                    String oldLeader = matchGroup != null ? matchGroup.getValue() : null;
                    PartyMember partyMember = partyMembers.get(newLeader);
                    if (partyMember != null) {
                        partyMember.setLeader(true);
                    }
                    String string = oldLeader;
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        partyMembers.remove(it);
                    }
                    playerInParty = true;
                    EventBus.INSTANCE.post((Event)new PartyEvent.Changed(PartyChangeType.LEADER_CHANGED, (String)newLeader, MapsKt.toMap(partyMembers)));
                } else {
                    match = clean;
                    if (destructionRegex.matches((CharSequence)match)) {
                        partyMembers.clear();
                        playerInParty = false;
                        EventBus.INSTANCE.post((Event)new PartyEvent.Changed(PartyChangeType.DISBANDED, null, MapsKt.toMap(partyMembers)));
                    } else {
                        Object leaderName;
                        match = clean;
                        if (joinPartyRegex.matches((CharSequence)match)) {
                            partyMembers.clear();
                            Object object = Regex.find$default(joinPartyRegex, clean, 0, 2, null);
                            if (object == null || (object = object.getGroups()) == null || (object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)object, "partyLeader")) == null || (object = ((MatchGroup)object).getValue()) == null) {
                                return;
                            }
                            leaderName = object;
                            partyMembers.put((String)leaderName, new PartyMember((String)leaderName, true, false, null, null, 28, null));
                            this.addSelfToParty(false);
                            EventBus.INSTANCE.post((Event)new PartyEvent.Changed(PartyChangeType.PLAYER_JOINED, (String)leaderName, MapsKt.toMap(partyMembers)));
                        } else {
                            Object playerNames;
                            leaderName = clean;
                            if (partyDetailsRegex.matches((CharSequence)leaderName)) {
                                String[] newLeader = (String[])clean;
                                Regex oldLeader = partyListRegex;
                                String string = "";
                                CharSequence charSequence2 = ((Object)StringsKt.trim((CharSequence)oldLeader.replace((CharSequence)newLeader, string))).toString();
                                newLeader = new String[]{" "};
                                playerNames = StringsKt.split$default(charSequence2, newLeader, false, 0, 6, null);
                                boolean isLeaderLine = StringsKt.startsWith$default(clean, "Party Leader:", false, 2, null);
                                Iterable $this$forEach$iv = (Iterable)playerNames;
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    PartyMember partyMember;
                                    String name = (String)element$iv;
                                    boolean bl = false;
                                    Map<String, PartyMember> $this$getOrPut$iv = partyMembers;
                                    boolean $i$f$getOrPut = false;
                                    PartyMember value$iv = $this$getOrPut$iv.get(name);
                                    if (value$iv == null) {
                                        boolean bl2 = false;
                                        PartyMember answer$iv = new PartyMember(name, false, false, null, null, 30, null);
                                        $this$getOrPut$iv.put(name, answer$iv);
                                        partyMember = answer$iv;
                                    } else {
                                        partyMember = value$iv;
                                    }
                                    PartyMember member = partyMember;
                                    member.setLeader(isLeaderLine);
                                }
                                playerInParty = true;
                                EventBus.INSTANCE.post((Event)new PartyEvent.Changed(PartyChangeType.LIST, null, MapsKt.toMap(partyMembers), 2, null));
                            } else {
                                playerNames = clean;
                                if (partyDisconnectRegex.matches((CharSequence)playerNames)) {
                                    Object object = Regex.find$default(partyDisconnectRegex, clean, 0, 2, null);
                                    if (object == null || (object = object.getGroups()) == null || (object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)object, "partyLeader")) == null || (object = ((MatchGroup)object).getValue()) == null) {
                                        return;
                                    }
                                    leaderName = object;
                                    Iterable $this$forEach$iv = partyMembers.values();
                                    boolean $i$f$forEach = false;
                                    for (Object element$iv : $this$forEach$iv) {
                                        PartyMember it = (PartyMember)element$iv;
                                        boolean bl = false;
                                        it.setLeader(false);
                                    }
                                    PartyMember partyMember = partyMembers.get(leaderName);
                                    if (partyMember != null) {
                                        PartyMember member = partyMember;
                                        boolean bl = false;
                                        member.setOnline(false);
                                        member.setLeader(true);
                                    }
                                } else {
                                    leaderName = clean;
                                    if (partyFinderJoinRegex.matches((CharSequence)leaderName)) {
                                        PartyMember partyMember;
                                        MatchResult matchResult = Regex.find$default(partyFinderJoinRegex, clean, 0, 2, null);
                                        if (matchResult == null) {
                                            return;
                                        }
                                        match = matchResult;
                                        Object object = RegexExtensionsJDK8Kt.get(match.getGroups(), "playerName");
                                        if (object == null || (object = ((MatchGroup)object).getValue()) == null) {
                                            return;
                                        }
                                        Object playerName2 = object;
                                        Object object2 = RegexExtensionsJDK8Kt.get(match.getGroups(), "classType");
                                        if (object2 == null || (object2 = ((MatchGroup)object2).getValue()) == null) {
                                            return;
                                        }
                                        Object className = object2;
                                        Object object3 = RegexExtensionsJDK8Kt.get(match.getGroups(), "classLvl");
                                        if (object3 == null || (object3 = ((MatchGroup)object3).getValue()) == null) {
                                            return;
                                        }
                                        Object classLvl = object3;
                                        Map<String, PartyMember> map2 = partyMembers;
                                        PartyMember $this$handlePartyMessage_u24lambda_u2413 = partyMember = new PartyMember((String)playerName2, false, false, null, null, 30, null);
                                        boolean bl = false;
                                        $this$handlePartyMessage_u24lambda_u2413.setClassName((String)className);
                                        $this$handlePartyMessage_u24lambda_u2413.setClassLvl((String)classLvl);
                                        map2.put((String)playerName2, partyMember);
                                        this.addSelfToParty(false);
                                        ChatUtils.INSTANCE.command("/p list");
                                        hidePartyList = true;
                                        EntityPlayerSP entityPlayerSP = Zen.Companion.getMc().field_71439_g;
                                        if (Intrinsics.areEqual(playerName2, entityPlayerSP != null ? entityPlayerSP.func_70005_c_() : null)) {
                                            PartyMember partyMember2 = partyMembers.get(playerName2);
                                            if (partyMember2 != null) {
                                                partyMember2.setLeader(false);
                                            }
                                        }
                                        EventBus.INSTANCE.post((Event)new PartyEvent.Changed(PartyChangeType.PARTY_FINDER, (String)playerName2, MapsKt.toMap(partyMembers)));
                                    } else {
                                        charSequence = clean;
                                        if (partyFinderErrorRegex.matches(charSequence)) {
                                            hadProblemJoiningParty = true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static final Unit _init_$lambda$0(ChatEvent.Receive event) {
        Intrinsics.checkNotNullParameter(event, "event");
        String string = event.getEvent().message.func_150260_c();
        Intrinsics.checkNotNullExpressionValue(string, "getUnformattedText(...)");
        String clean = StringUtils.INSTANCE.removeFormatting(string);
        CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)clean)).toString();
        if (partyDetailsRegex.matches(charSequence) && hidePartyList) {
            event.cancel();
            INSTANCE.handlePartyMessage(clean);
            return Unit.INSTANCE;
        }
        if (Intrinsics.areEqual(clean, "-----------------------------------------------------") && hidePartyList) {
            hidePartyList = false;
            return Unit.INSTANCE;
        }
        INSTANCE.handlePartyMessage(clean);
        return Unit.INSTANCE;
    }

    private static final boolean lambda$6$lambda$5$lambda$2(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        EntityPlayerSP entityPlayerSP = Zen.Companion.getMc().field_71439_g;
        return !Intrinsics.areEqual(it.getKey(), entityPlayerSP != null ? entityPlayerSP.func_70005_c_() : null);
    }

    private static final boolean lambda$6$lambda$5$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void lambda$6$lambda$5(ItemStack $stack, String $stackName) {
        List list;
        List list2;
        Object it$iv;
        Intrinsics.checkNotNullParameter($stackName, "$stackName");
        if (hadProblemJoiningParty) {
            return;
        }
        partyMembers.entrySet().removeIf(arg_0 -> PartyTracker.lambda$6$lambda$5$lambda$3(PartyTracker::lambda$6$lambda$5$lambda$2, arg_0));
        INSTANCE.addSelfToParty(false);
        ItemUtils itemUtils = ItemUtils.INSTANCE;
        ItemStack $this$lore$iv = $stack;
        boolean $i$f$getLore = false;
        ItemStack itemStack = $this$lore$iv;
        if (itemStack != null && (itemStack = itemStack.func_77978_p()) != null && (itemStack = itemStack.func_74775_l("display")) != null && (itemStack = itemStack.func_150295_c("Lore", 8)) != null) {
            it$iv = itemStack;
            boolean bl = false;
            int n = it$iv.func_74745_c();
            ArrayList<String> arrayList = new ArrayList<String>(n);
            int n2 = 0;
            while (n2 < n) {
                void i$iv;
                int n3;
                int n4 = n3 = n2++;
                ArrayList<String> arrayList2 = arrayList;
                boolean bl2 = false;
                arrayList2.add(it$iv.func_150307_f((int)i$iv));
            }
            list2 = arrayList;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        List stackLore = list;
        for (String line : stackLore) {
            PartyMember partyMember;
            MatchGroupCollection groups2;
            Object object;
            String clean = ((Object)StringsKt.trim((CharSequence)StringUtils.INSTANCE.removeFormatting(line))).toString();
            it$iv = clean;
            if (!classLoreRegex.matches((CharSequence)it$iv) || StringUtils.INSTANCE.getRegexGroups(clean, classLoreRegex) == null || (object = groups2.get(1)) == null || (object = ((MatchGroup)object).getValue()) == null) continue;
            Object playerName = object;
            Object object2 = groups2.get(2);
            if (object2 == null || (object2 = ((MatchGroup)object2).getValue()) == null) continue;
            Object className = object2;
            Object object3 = groups2.get(3);
            if (object3 == null || (object3 = ((MatchGroup)object3).getValue()) == null) continue;
            Object classLvl = object3;
            Map<String, PartyMember> map2 = partyMembers;
            PartyMember $this$lambda_u246_u24lambda_u245_u24lambda_u244 = partyMember = new PartyMember((String)playerName, false, false, null, null, 30, null);
            boolean bl = false;
            $this$lambda_u246_u24lambda_u245_u24lambda_u244.setClassName((String)className);
            $this$lambda_u246_u24lambda_u245_u24lambda_u244.setClassLvl((String)classLvl);
            map2.put((String)playerName, partyMember);
        }
        String[] stringArray = new String[]{"'"};
        String leaderName = (String)StringsKt.split$default((CharSequence)StringUtils.INSTANCE.removeFormatting($stackName), stringArray, false, 0, 6, null).get(0);
        PartyMember partyMember = partyMembers.get(leaderName);
        if (partyMember != null) {
            partyMember.setLeader(true);
        }
        playerInParty = true;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$6(GuiEvent.Slot.Click event) {
        boolean bl;
        ItemStack stack;
        Object stackName;
        block14: {
            List list;
            List list2;
            String string;
            Intrinsics.checkNotNullParameter(event, "event");
            GuiContainer guiContainer = event.getGui();
            GuiChest guiChest = guiContainer instanceof GuiChest ? (GuiChest)guiContainer : null;
            if (guiChest == null) {
                return Unit.INSTANCE;
            }
            GuiChest gui = guiChest;
            Utils utils = Utils.INSTANCE;
            GuiContainer $this$chestName$iv = (GuiContainer)gui;
            boolean $i$f$getChestName22 = false;
            if (!($this$chestName$iv.field_147002_h instanceof ContainerChest)) {
                string = "";
            } else {
                Container container = $this$chestName$iv.field_147002_h;
                Intrinsics.checkNotNull(container, "null cannot be cast to non-null type net.minecraft.inventory.ContainerChest");
                ContainerChest chest$iv = (ContainerChest)container;
                IInventory inv$iv = chest$iv.func_85151_d();
                String string2 = inv$iv.func_145748_c_().func_150260_c();
                Intrinsics.checkNotNullExpressionValue(string2, "getUnformattedText(...)");
                string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            }
            if (!StringsKt.startsWith$default(string, "Party Finder", false, 2, null)) {
                return Unit.INSTANCE;
            }
            Object object = event.getSlot();
            if (object == null || (object = object.func_75211_c()) == null || (object = object.func_82833_r()) == null || (object = StringUtils.INSTANCE.removeFormatting((String)object)) == null) {
                return Unit.INSTANCE;
            }
            stackName = object;
            if (!StringsKt.endsWith$default((String)stackName, "'s Party", false, 2, null)) {
                return Unit.INSTANCE;
            }
            stack = event.getSlot().func_75211_c();
            ItemUtils $i$f$getChestName22 = ItemUtils.INSTANCE;
            ItemStack $this$lore$iv = stack;
            boolean $i$f$getLore = false;
            ItemStack itemStack = $this$lore$iv;
            if (itemStack != null && (itemStack = itemStack.func_77978_p()) != null && (itemStack = itemStack.func_74775_l("display")) != null && (itemStack = itemStack.func_150295_c("Lore", 8)) != null) {
                ItemStack it$iv = itemStack;
                boolean bl2 = false;
                int n = it$iv.func_74745_c();
                ArrayList<String> arrayList = new ArrayList<String>(n);
                int n2 = 0;
                while (n2 < n) {
                    void i$iv;
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<String> arrayList2 = arrayList;
                    boolean bl3 = false;
                    arrayList2.add(it$iv.func_150307_f((int)i$iv));
                }
                list2 = arrayList;
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl4 = false;
                    if (!StringsKt.startsWith$default(StringUtils.INSTANCE.removeFormatting(it), "Requires", false, 2, null)) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
        }
        if (bl) {
            return Unit.INSTANCE;
        }
        hadProblemJoiningParty = false;
        LoopUtils.INSTANCE.setTimeout(1000L, () -> PartyTracker.lambda$6$lambda$5(stack, (String)stackName));
        return Unit.INSTANCE;
    }

    static {
        int priority$iv$iv;
        boolean bl;
        Set default$iv$iv$iv;
        boolean bl2;
        EventBus this_$iv$iv;
        EventBus this_$iv;
        INSTANCE = new PartyTracker();
        destructionRegex = new Regex("^The party was disbanded because all invites expired and the party was empty\\.|[^ ]+ has disbanded the party!|You (?:left|have left|have been kicked from|were kicked from) the party\\.|You (?:are not in a party right now|are not in a party|are not currently in a party\\.)");
        partyTransferRegex = new Regex("^The party was transferred to (?:\\[[^]]+]\\s*)?(?<newLeader>[^ ]+)(?: because (?<leavingPlayer>[^ ]+) left| by .*)?");
        partyJoinRegex = new Regex("^(?:\\[[^]]+]\\s*)?([^ ]+) joined the party\\.");
        partyRemoveRegex = new Regex("^(?:\\[[^]]+]\\s*)?([^ ]+) has (?:left|been removed from) the party\\.");
        joinPartyRegex = new Regex("^You have joined (?:\\[[^]]+]\\s*)?(?<partyLeader>[^ ]+)'s? party!");
        partyListRegex = new Regex("(Party (?:Leader|Members|Moderators):|\\[[^]]+]\\s*| \u25cf)");
        partyDisconnectRegex = new Regex("^(?:The party leader, )?(?:\\[[^]]+] )?(?<partyLeader>.*?) has disconnected");
        partyDetailsRegex = new Regex("^Party (?:Leader|Moderators|Members): .*");
        partyFinderJoinRegex = new Regex("^Party Finder > (?<playerName>\\S+) joined the dungeon group! \\((?<classType>.*) Level (?<classLvl>\\d+)\\)");
        partyFinderErrorRegex = new Regex("^Party Finder > (?:This group has been de-listed|You are already in a party!)|^You have just sent a join request recently!");
        classLoreRegex = new Regex("^(\\w+):\\s(\\w+)\\s\\((\\d+)\\)$");
        partyMembers = new LinkedHashMap();
        EventBus eventBus = EventBus.INSTANCE;
        Function1<CancellableEvent, Unit> callback$iv = PartyTracker::_init_$lambda$0;
        boolean $i$f$register = false;
        void var3_3 = this_$iv;
        boolean bl3 = false;
        boolean add$iv$iv = true;
        boolean $i$f$register2 = false;
        Class eventClass$iv$iv = ChatEvent.Receive.class;
        ConcurrentMap $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object == null) {
                object = default$iv$iv$iv;
            }
        }
        Set handlers$iv$iv = (Set)object;
        EventBus.PrioritizedCallback<ChatEvent.Receive> prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback<ChatEvent.Receive>(priority$iv$iv, callback$iv);
        handlers$iv$iv.add(prioritizedCallback$iv$iv);
        Intrinsics.checkNotNull(handlers$iv$iv);
        EventBus.EventCall cfr_ignored_0 = new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv);
        this_$iv = EventBus.INSTANCE;
        callback$iv = PartyTracker::_init_$lambda$6;
        $i$f$register = false;
        this_$iv$iv = this_$iv;
        priority$iv$iv = 0;
        add$iv$iv = true;
        $i$f$register2 = false;
        eventClass$iv$iv = GuiEvent.Slot.Click.class;
        $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object2 == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object2 = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object2 == null) {
                object2 = default$iv$iv$iv;
            }
        }
        handlers$iv$iv = (Set)object2;
        prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback<ChatEvent.Receive>(priority$iv$iv, callback$iv);
        handlers$iv$iv.add(prioritizedCallback$iv$iv);
        Intrinsics.checkNotNull(handlers$iv$iv);
        EventBus.EventCall cfr_ignored_1 = new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u0015\u00a8\u0006#"}, d2={"Lmeowing/zen/api/PartyTracker$PartyMember;", "", "name", "", "leader", "", "online", "className", "classLvl", "<init>", "(Ljava/lang/String;ZZLjava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getLeader", "()Z", "setLeader", "(Z)V", "getOnline", "setOnline", "getClassName", "setClassName", "(Ljava/lang/String;)V", "getClassLvl", "setClassLvl", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "zen"})
    public static final class PartyMember {
        @NotNull
        private final String name;
        private boolean leader;
        private boolean online;
        @NotNull
        private String className;
        @NotNull
        private String classLvl;

        public PartyMember(@NotNull String name, boolean leader, boolean online, @NotNull String className, @NotNull String classLvl) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(className, "className");
            Intrinsics.checkNotNullParameter(classLvl, "classLvl");
            this.name = name;
            this.leader = leader;
            this.online = online;
            this.className = className;
            this.classLvl = classLvl;
        }

        public /* synthetic */ PartyMember(String string, boolean bl, boolean bl2, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = true;
            }
            if ((n & 8) != 0) {
                string2 = "";
            }
            if ((n & 0x10) != 0) {
                string3 = "";
            }
            this(string, bl, bl2, string2, string3);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final boolean getLeader() {
            return this.leader;
        }

        public final void setLeader(boolean bl) {
            this.leader = bl;
        }

        public final boolean getOnline() {
            return this.online;
        }

        public final void setOnline(boolean bl) {
            this.online = bl;
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        public final void setClassName(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.className = string;
        }

        @NotNull
        public final String getClassLvl() {
            return this.classLvl;
        }

        public final void setClassLvl(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.classLvl = string;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final boolean component2() {
            return this.leader;
        }

        public final boolean component3() {
            return this.online;
        }

        @NotNull
        public final String component4() {
            return this.className;
        }

        @NotNull
        public final String component5() {
            return this.classLvl;
        }

        @NotNull
        public final PartyMember copy(@NotNull String name, boolean leader, boolean online, @NotNull String className, @NotNull String classLvl) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(className, "className");
            Intrinsics.checkNotNullParameter(classLvl, "classLvl");
            return new PartyMember(name, leader, online, className, classLvl);
        }

        public static /* synthetic */ PartyMember copy$default(PartyMember partyMember, String string, boolean bl, boolean bl2, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = partyMember.name;
            }
            if ((n & 2) != 0) {
                bl = partyMember.leader;
            }
            if ((n & 4) != 0) {
                bl2 = partyMember.online;
            }
            if ((n & 8) != 0) {
                string2 = partyMember.className;
            }
            if ((n & 0x10) != 0) {
                string3 = partyMember.classLvl;
            }
            return partyMember.copy(string, bl, bl2, string2, string3);
        }

        @NotNull
        public String toString() {
            return "PartyMember(name=" + this.name + ", leader=" + this.leader + ", online=" + this.online + ", className=" + this.className + ", classLvl=" + this.classLvl + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Boolean.hashCode(this.leader);
            result = result * 31 + Boolean.hashCode(this.online);
            result = result * 31 + this.className.hashCode();
            result = result * 31 + this.classLvl.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PartyMember)) {
                return false;
            }
            PartyMember partyMember = (PartyMember)other;
            if (!Intrinsics.areEqual(this.name, partyMember.name)) {
                return false;
            }
            if (this.leader != partyMember.leader) {
                return false;
            }
            if (this.online != partyMember.online) {
                return false;
            }
            if (!Intrinsics.areEqual(this.className, partyMember.className)) {
                return false;
            }
            return Intrinsics.areEqual(this.classLvl, partyMember.classLvl);
        }
    }
}

