/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.api;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import meowing.zen.Zen;
import meowing.zen.events.Event;
import meowing.zen.events.EventBus;
import meowing.zen.events.GameEvent;
import meowing.zen.events.TickEvent;
import meowing.zen.events.WorldEvent;
import org.jetbrains.annotations.NotNull;

@Zen.Module
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b/\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020=2\u0006\u0010L\u001a\u00020MH\u0002J\b\u0010N\u001a\u00020JH\u0002J\b\u0010O\u001a\u00020JH\u0002J\u0010\u0010P\u001a\u00020J2\u0006\u0010Q\u001a\u00020RH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0018\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0011R\u001a\u0010\u001b\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u000f\"\u0004\b\u001d\u0010\u0011R\u001a\u0010\u001e\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000f\"\u0004\b \u0010\u0011R\u001a\u0010!\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u000f\"\u0004\b#\u0010\u0011R\u001a\u0010$\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u000f\"\u0004\b&\u0010\u0011R\u001a\u0010'\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u000f\"\u0004\b)\u0010\u0011R\u001a\u0010*\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u000f\"\u0004\b,\u0010\u0011R\u001a\u0010-\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u000f\"\u0004\b/\u0010\u0011R\u001a\u00100\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u000f\"\u0004\b2\u0010\u0011R\u001a\u00103\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u000f\"\u0004\b5\u0010\u0011R\u001a\u00106\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u000f\"\u0004\b8\u0010\u0011R\u001a\u00109\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u000f\"\u0004\b;\u0010\u0011R\u001a\u0010<\u001a\u00020=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u001a\u0010B\u001a\u00020=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010?\"\u0004\bD\u0010AR\u000e\u0010E\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lmeowing/zen/api/PlayerStats;", "", "<init>", "()V", "HEALTH_REGEX", "Lkotlin/text/Regex;", "MANA_REGEX", "OVERFLOW_REGEX", "DEFENSE_REGEX", "RIFT_REGEX", "DRILL_FUEL_REGEX", "DUNGEON_SECRETS_REGEX", "health", "", "getHealth", "()I", "setHealth", "(I)V", "maxHealth", "getMaxHealth", "setMaxHealth", "absorption", "getAbsorption", "setAbsorption", "mana", "getMana", "setMana", "maxMana", "getMaxMana", "setMaxMana", "overflowMana", "getOverflowMana", "setOverflowMana", "defense", "getDefense", "setDefense", "effectiveHealth", "getEffectiveHealth", "setEffectiveHealth", "maxEffectiveHealth", "getMaxEffectiveHealth", "setMaxEffectiveHealth", "maxRiftTime", "getMaxRiftTime", "setMaxRiftTime", "riftTimeSeconds", "getRiftTimeSeconds", "setRiftTimeSeconds", "drillFuel", "getDrillFuel", "setDrillFuel", "maxDrillFuel", "getMaxDrillFuel", "setMaxDrillFuel", "currentRoomSecrets", "getCurrentRoomSecrets", "setCurrentRoomSecrets", "currentRoomMaxSecrets", "getCurrentRoomMaxSecrets", "setCurrentRoomMaxSecrets", "displayedHealth", "", "getDisplayedHealth", "()F", "setDisplayedHealth", "(F)V", "displayedMana", "getDisplayedMana", "setDisplayedMana", "lastHealth", "lastMana", "healthRegenRate", "manaRegenRate", "resetInterpolation", "", "value", "isHealth", "", "updateRegenRates", "applyInterpolation", "extractPlayerStats", "actionBar", "", "zen"})
@SourceDebugExtension(value={"SMAP\nPlayerStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerStats.kt\nmeowing/zen/api/PlayerStats\n+ 2 EventBus.kt\nmeowing/zen/events/EventBus\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n206#2:164\n194#2,2:165\n196#2,3:170\n206#2:173\n194#2,2:174\n196#2,3:179\n206#2:182\n194#2,2:183\n196#2,3:188\n72#3,2:167\n72#3,2:176\n72#3,2:185\n1#4:169\n1#4:178\n1#4:187\n*S KotlinDebug\n*F\n+ 1 PlayerStats.kt\nmeowing/zen/api/PlayerStats\n*L\n46#1:164\n46#1:165,2\n46#1:170,3\n69#1:173\n69#1:174,2\n69#1:179,3\n82#1:182\n82#1:183,2\n82#1:188,3\n46#1:167,2\n69#1:176,2\n82#1:185,2\n46#1:169\n69#1:178\n82#1:187\n*E\n"})
public final class PlayerStats {
    @NotNull
    public static final PlayerStats INSTANCE;
    @NotNull
    private static final Regex HEALTH_REGEX;
    @NotNull
    private static final Regex MANA_REGEX;
    @NotNull
    private static final Regex OVERFLOW_REGEX;
    @NotNull
    private static final Regex DEFENSE_REGEX;
    @NotNull
    private static final Regex RIFT_REGEX;
    @NotNull
    private static final Regex DRILL_FUEL_REGEX;
    @NotNull
    private static final Regex DUNGEON_SECRETS_REGEX;
    private static int health;
    private static int maxHealth;
    private static int absorption;
    private static int mana;
    private static int maxMana;
    private static int overflowMana;
    private static int defense;
    private static int effectiveHealth;
    private static int maxEffectiveHealth;
    private static int maxRiftTime;
    private static int riftTimeSeconds;
    private static int drillFuel;
    private static int maxDrillFuel;
    private static int currentRoomSecrets;
    private static int currentRoomMaxSecrets;
    private static float displayedHealth;
    private static float displayedMana;
    private static float lastHealth;
    private static float lastMana;
    private static float healthRegenRate;
    private static float manaRegenRate;

    private PlayerStats() {
    }

    public final int getHealth() {
        return health;
    }

    public final void setHealth(int n) {
        health = n;
    }

    public final int getMaxHealth() {
        return maxHealth;
    }

    public final void setMaxHealth(int n) {
        maxHealth = n;
    }

    public final int getAbsorption() {
        return absorption;
    }

    public final void setAbsorption(int n) {
        absorption = n;
    }

    public final int getMana() {
        return mana;
    }

    public final void setMana(int n) {
        mana = n;
    }

    public final int getMaxMana() {
        return maxMana;
    }

    public final void setMaxMana(int n) {
        maxMana = n;
    }

    public final int getOverflowMana() {
        return overflowMana;
    }

    public final void setOverflowMana(int n) {
        overflowMana = n;
    }

    public final int getDefense() {
        return defense;
    }

    public final void setDefense(int n) {
        defense = n;
    }

    public final int getEffectiveHealth() {
        return effectiveHealth;
    }

    public final void setEffectiveHealth(int n) {
        effectiveHealth = n;
    }

    public final int getMaxEffectiveHealth() {
        return maxEffectiveHealth;
    }

    public final void setMaxEffectiveHealth(int n) {
        maxEffectiveHealth = n;
    }

    public final int getMaxRiftTime() {
        return maxRiftTime;
    }

    public final void setMaxRiftTime(int n) {
        maxRiftTime = n;
    }

    public final int getRiftTimeSeconds() {
        return riftTimeSeconds;
    }

    public final void setRiftTimeSeconds(int n) {
        riftTimeSeconds = n;
    }

    public final int getDrillFuel() {
        return drillFuel;
    }

    public final void setDrillFuel(int n) {
        drillFuel = n;
    }

    public final int getMaxDrillFuel() {
        return maxDrillFuel;
    }

    public final void setMaxDrillFuel(int n) {
        maxDrillFuel = n;
    }

    public final int getCurrentRoomSecrets() {
        return currentRoomSecrets;
    }

    public final void setCurrentRoomSecrets(int n) {
        currentRoomSecrets = n;
    }

    public final int getCurrentRoomMaxSecrets() {
        return currentRoomMaxSecrets;
    }

    public final void setCurrentRoomMaxSecrets(int n) {
        currentRoomMaxSecrets = n;
    }

    public final float getDisplayedHealth() {
        return displayedHealth;
    }

    public final void setDisplayedHealth(float f) {
        displayedHealth = f;
    }

    public final float getDisplayedMana() {
        return displayedMana;
    }

    public final void setDisplayedMana(float f) {
        displayedMana = f;
    }

    private final void resetInterpolation(float value, boolean isHealth) {
        if (isHealth) {
            displayedHealth = value;
            lastHealth = value;
        } else {
            displayedMana = value;
            lastMana = value;
        }
    }

    private final void updateRegenRates() {
        float f;
        float f2;
        float currentHealth = health;
        float currentMana = mana;
        if (currentHealth < lastHealth) {
            displayedHealth = currentHealth;
            f2 = 0.0f;
        } else {
            f2 = currentHealth > lastHealth ? currentHealth - lastHealth : healthRegenRate;
        }
        healthRegenRate = f2;
        if (currentMana < lastMana) {
            displayedMana = currentMana;
            f = 0.0f;
        } else {
            f = currentMana > lastMana ? currentMana - lastMana : manaRegenRate;
        }
        manaRegenRate = f;
        lastHealth = currentHealth;
        lastMana = currentMana;
    }

    private final void applyInterpolation() {
        displayedHealth = RangesKt.coerceAtMost(displayedHealth + healthRegenRate / 20.0f, (float)maxHealth);
        displayedMana = RangesKt.coerceAtMost(displayedMana + manaRegenRate / 20.0f, (float)maxMana);
    }

    private final void extractPlayerStats(String actionBar) {
        block7: {
            MatchResult match;
            String cleanBar = StringsKt.replace$default(StringsKt.replace$default(actionBar, ",", "", false, 4, null), "k", "000", false, 4, null);
            MatchResult matchResult = Regex.find$default(HEALTH_REGEX, cleanBar, 0, 2, null);
            if (matchResult != null) {
                match = matchResult;
                boolean bl = false;
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get(match.getGroups(), "currentHealth");
                Intrinsics.checkNotNull(matchGroup);
                health = Integer.parseInt(matchGroup.getValue());
                MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get(match.getGroups(), "maxHealth");
                Intrinsics.checkNotNull(matchGroup2);
                maxHealth = Integer.parseInt(matchGroup2.getValue());
                effectiveHealth = health * (1 + defense / 100);
                maxEffectiveHealth = maxHealth * (1 + defense / 100);
                absorption = Math.max(health - maxHealth, 0);
            }
            MatchResult matchResult2 = Regex.find$default(MANA_REGEX, cleanBar, 0, 2, null);
            if (matchResult2 != null) {
                match = matchResult2;
                boolean bl = false;
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get(match.getGroups(), "currentMana");
                Intrinsics.checkNotNull(matchGroup);
                mana = Integer.parseInt(matchGroup.getValue());
                MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get(match.getGroups(), "maxMana");
                Intrinsics.checkNotNull(matchGroup3);
                maxMana = Integer.parseInt(matchGroup3.getValue());
            }
            MatchResult matchResult3 = Regex.find$default(OVERFLOW_REGEX, cleanBar, 0, 2, null);
            if (matchResult3 != null) {
                match = matchResult3;
                boolean bl = false;
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get(match.getGroups(), "overflowMana");
                Intrinsics.checkNotNull(matchGroup);
                overflowMana = Integer.parseInt(matchGroup.getValue());
            }
            MatchResult matchResult4 = Regex.find$default(DEFENSE_REGEX, cleanBar, 0, 2, null);
            if (matchResult4 != null) {
                match = matchResult4;
                boolean bl = false;
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get(match.getGroups(), "defense");
                Intrinsics.checkNotNull(matchGroup);
                defense = Integer.parseInt(matchGroup.getValue());
            }
            MatchResult matchResult5 = Regex.find$default(DRILL_FUEL_REGEX, cleanBar, 0, 2, null);
            if (matchResult5 != null) {
                match = matchResult5;
                boolean bl = false;
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get(match.getGroups(), "currentFuel");
                Intrinsics.checkNotNull(matchGroup);
                drillFuel = Integer.parseInt(matchGroup.getValue());
                MatchGroup matchGroup4 = RegexExtensionsJDK8Kt.get(match.getGroups(), "maxFuel");
                Intrinsics.checkNotNull(matchGroup4);
                maxDrillFuel = Integer.parseInt(matchGroup4.getValue());
            }
            MatchResult matchResult6 = Regex.find$default(DUNGEON_SECRETS_REGEX, cleanBar, 0, 2, null);
            if (matchResult6 != null) {
                match = matchResult6;
                boolean bl = false;
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get(match.getGroups(), "secrets");
                Intrinsics.checkNotNull(matchGroup);
                currentRoomSecrets = Integer.parseInt(matchGroup.getValue());
                MatchGroup matchGroup5 = RegexExtensionsJDK8Kt.get(match.getGroups(), "maxSecrets");
                Intrinsics.checkNotNull(matchGroup5);
                currentRoomMaxSecrets = Integer.parseInt(matchGroup5.getValue());
            }
            MatchResult matchResult7 = Regex.find$default(RIFT_REGEX, cleanBar, 0, 2, null);
            if (matchResult7 == null) break block7;
            match = matchResult7;
            boolean bl = false;
            Object object = RegexExtensionsJDK8Kt.get(match.getGroups(), "minutes");
            int minutes = object != null && (object = ((MatchGroup)object).getValue()) != null ? Integer.parseInt((String)object) : 0;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get(match.getGroups(), "seconds");
            Intrinsics.checkNotNull(matchGroup);
            int seconds = Integer.parseInt(matchGroup.getValue());
            riftTimeSeconds = minutes * 60 + seconds;
            if (riftTimeSeconds > maxRiftTime) {
                maxRiftTime = riftTimeSeconds;
            }
        }
    }

    private static final Unit _init_$lambda$0(WorldEvent.Change it) {
        Intrinsics.checkNotNullParameter(it, "it");
        maxRiftTime = 0;
        currentRoomSecrets = -1;
        currentRoomMaxSecrets = 0;
        health = 0;
        maxHealth = 0;
        absorption = 0;
        mana = 0;
        maxMana = 0;
        overflowMana = 0;
        defense = 0;
        effectiveHealth = 0;
        maxEffectiveHealth = 0;
        maxRiftTime = 0;
        riftTimeSeconds = 0;
        drillFuel = 0;
        maxDrillFuel = 0;
        currentRoomSecrets = 0;
        currentRoomMaxSecrets = 0;
        displayedHealth = 0.0f;
        displayedMana = 0.0f;
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(TickEvent.Client it) {
        block7: {
            block6: {
                block5: {
                    block4: {
                        Intrinsics.checkNotNullParameter(it, "it");
                        if (health >= maxHealth) break block4;
                        if (!(Math.abs(displayedHealth - (float)health) > 50.0f)) break block5;
                    }
                    INSTANCE.resetInterpolation(health, true);
                }
                if (mana >= maxMana) break block6;
                if (!(Math.abs(displayedMana - (float)mana) > 50.0f)) break block7;
            }
            INSTANCE.resetInterpolation(mana, false);
        }
        INSTANCE.updateRegenRates();
        INSTANCE.applyInterpolation();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(GameEvent.ActionBar event) {
        Intrinsics.checkNotNullParameter(event, "event");
        String string = event.getEvent().message.func_150254_d();
        Intrinsics.checkNotNullExpressionValue(string, "getFormattedText(...)");
        INSTANCE.extractPlayerStats(string);
        return Unit.INSTANCE;
    }

    static {
        int priority$iv$iv;
        boolean bl;
        Set default$iv$iv$iv;
        boolean bl2;
        EventBus this_$iv$iv;
        EventBus this_$iv;
        INSTANCE = new PlayerStats();
        HEALTH_REGEX = new Regex("(\u00a7.)(?<currentHealth>[\\d,]+)/(?<maxHealth>[\\d,]+)\u2764");
        MANA_REGEX = new Regex("\u00a7b(?<currentMana>[\\d,]+)/(?<maxMana>[\\d,]+)\u270e( Mana)?");
        OVERFLOW_REGEX = new Regex("\u00a73(?<overflowMana>[\\d,]+)\u02ac");
        DEFENSE_REGEX = new Regex("\u00a7a(?<defense>[\\d,]+)\u00a7a\u2748 Defense");
        RIFT_REGEX = new Regex("(\u00a77|\u00a7a)(?:(?<minutes>\\d+)m\\s*)?(?<seconds>\\d+)s\u0444 Left");
        DRILL_FUEL_REGEX = new Regex("\u00a72(?<currentFuel>[\\d,]+)/(?<maxFuel>[\\d,k]+) Drill Fuel");
        DUNGEON_SECRETS_REGEX = new Regex("\u00a77(?<secrets>[\\d,]+)/(?<maxSecrets>[\\d,]+) Secrets");
        EventBus eventBus = EventBus.INSTANCE;
        Function1<Event, Unit> callback$iv = PlayerStats::_init_$lambda$0;
        boolean $i$f$register = false;
        void var3_3 = this_$iv;
        boolean bl3 = false;
        boolean add$iv$iv = true;
        boolean $i$f$register2 = false;
        Class eventClass$iv$iv = WorldEvent.Change.class;
        ConcurrentMap $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object == null) {
                object = default$iv$iv$iv;
            }
        }
        Set handlers$iv$iv = (Set)object;
        EventBus.PrioritizedCallback<WorldEvent.Change> prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback<WorldEvent.Change>(priority$iv$iv, callback$iv);
        handlers$iv$iv.add(prioritizedCallback$iv$iv);
        Intrinsics.checkNotNull(handlers$iv$iv);
        EventBus.EventCall cfr_ignored_0 = new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv);
        this_$iv = EventBus.INSTANCE;
        callback$iv = PlayerStats::_init_$lambda$1;
        $i$f$register = false;
        this_$iv$iv = this_$iv;
        priority$iv$iv = 0;
        add$iv$iv = true;
        $i$f$register2 = false;
        eventClass$iv$iv = TickEvent.Client.class;
        $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object2 == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object2 = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object2 == null) {
                object2 = default$iv$iv$iv;
            }
        }
        handlers$iv$iv = (Set)object2;
        prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback<WorldEvent.Change>(priority$iv$iv, callback$iv);
        handlers$iv$iv.add(prioritizedCallback$iv$iv);
        Intrinsics.checkNotNull(handlers$iv$iv);
        EventBus.EventCall cfr_ignored_1 = new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv);
        this_$iv = EventBus.INSTANCE;
        callback$iv = PlayerStats::_init_$lambda$2;
        $i$f$register = false;
        this_$iv$iv = this_$iv;
        priority$iv$iv = 0;
        add$iv$iv = true;
        $i$f$register2 = false;
        eventClass$iv$iv = GameEvent.ActionBar.class;
        $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        $i$f$getOrPut = false;
        Object object3 = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object3 == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object3 = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object3 == null) {
                object3 = default$iv$iv$iv;
            }
        }
        handlers$iv$iv = (Set)object3;
        prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback<WorldEvent.Change>(priority$iv$iv, callback$iv);
        handlers$iv$iv.add(prioritizedCallback$iv$iv);
        Intrinsics.checkNotNull(handlers$iv$iv);
        EventBus.EventCall cfr_ignored_2 = new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv);
    }
}

