/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import meowing.zen.Zen;
import meowing.zen.events.CancellableEvent;
import meowing.zen.events.ChatEvent;
import meowing.zen.events.EventBus;
import meowing.zen.events.GuiEvent;
import meowing.zen.utils.DataUtils;
import meowing.zen.utils.StringUtils;
import meowing.zen.utils.TickUtils;
import meowing.zen.utils.Utils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Zen.Module
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001!B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0002J*\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u0018\u001a\u00020\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0006\u0010 \u001a\u00020\u001dR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lmeowing/zen/api/TradeAPI;", "", "<init>", "()V", "save", "Lmeowing/zen/utils/DataUtils;", "Lmeowing/zen/api/TradeAPI$TradeLogs;", "inTradeMenu", "", "lastTradeMenu", "Lnet/minecraft/inventory/Container;", "tradingWith", "", "tradingWithSub", "yourSlots", "", "", "theirSlots", "interpretLastTradeMenu", "", "processSlots", "Lkotlin/Pair;", "Lcom/google/gson/JsonArray;", "", "menu", "slots", "parseCoins", "name", "createItemJson", "Lcom/google/gson/JsonObject;", "stack", "Lnet/minecraft/item/ItemStack;", "getTradeHistory", "TradeLogs", "zen"})
@SourceDebugExtension(value={"SMAP\nTradeAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TradeAPI.kt\nmeowing/zen/api/TradeAPI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Utils.kt\nmeowing/zen/utils/Utils\n+ 5 EventBus.kt\nmeowing/zen/events/EventBus\n+ 6 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n*L\n1#1,123:1\n1863#2,2:124\n1#3:126\n1#3:136\n1#3:145\n41#4,4:127\n206#5:131\n194#5,2:132\n196#5,3:137\n206#5:140\n194#5,2:141\n196#5,3:146\n72#6,2:134\n72#6,2:143\n*S KotlinDebug\n*F\n+ 1 TradeAPI.kt\nmeowing/zen/api/TradeAPI\n*L\n91#1:124,2\n43#1:136\n50#1:145\n58#1:127,4\n43#1:131\n43#1:132,2\n43#1:137,3\n50#1:140\n50#1:141,2\n50#1:146,3\n43#1:134,2\n50#1:143,2\n*E\n"})
public final class TradeAPI {
    @NotNull
    public static final TradeAPI INSTANCE;
    @NotNull
    private static final DataUtils<TradeLogs> save;
    private static boolean inTradeMenu;
    @Nullable
    private static Container lastTradeMenu;
    @NotNull
    private static String tradingWith;
    @NotNull
    private static String tradingWithSub;
    @NotNull
    private static final List<Integer> yourSlots;
    @NotNull
    private static final List<Integer> theirSlots;

    private TradeAPI() {
    }

    private final void interpretLastTradeMenu() {
        Container container = lastTradeMenu;
        if (container == null) {
            return;
        }
        Container menu = container;
        JsonObject trade = new JsonObject();
        Pair<JsonArray, Long> pair = this.processSlots(menu, yourSlots);
        JsonArray yourItems = pair.component1();
        long yourCoins = ((Number)pair.component2()).longValue();
        trade.add("yourItems", (JsonElement)yourItems);
        trade.addProperty("yourCoins", (Number)yourCoins);
        Pair<JsonArray, Long> pair2 = this.processSlots(menu, theirSlots);
        JsonArray theirItems = pair2.component1();
        long theirCoins = ((Number)pair2.component2()).longValue();
        trade.add("theirItems", (JsonElement)theirItems);
        trade.addProperty("theirCoins", (Number)theirCoins);
        trade.addProperty("timestamp", (Number)System.currentTimeMillis());
        trade.addProperty("username", tradingWith);
        String date = StringUtils.INSTANCE.getFormattedDate();
        save.updateAndSave(arg_0 -> TradeAPI.interpretLastTradeMenu$lambda$5(date, trade, arg_0));
        tradingWith = "";
    }

    private final Pair<JsonArray, Long> processSlots(Container menu, List<Integer> slots) {
        JsonArray items = new JsonArray();
        long coins = 0L;
        Iterable $this$forEach$iv = slots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack stack;
            int slot = ((Number)element$iv).intValue();
            boolean bl = false;
            if (menu.func_75139_a(slot).func_75211_c() == null) continue;
            boolean bl2 = false;
            String string = stack.func_82833_r();
            Intrinsics.checkNotNullExpressionValue(string, "getDisplayName(...)");
            if (StringsKt.endsWith$default(Utils.INSTANCE.removeFormatting(string), "coins", false, 2, null)) {
                String string2 = stack.func_82833_r();
                Intrinsics.checkNotNullExpressionValue(string2, "getDisplayName(...)");
                coins += INSTANCE.parseCoins(Utils.INSTANCE.removeFormatting(string2));
                continue;
            }
            items.add((JsonElement)INSTANCE.createItemJson(stack));
        }
        return TuplesKt.to(items, coins);
    }

    private final long parseCoins(String name) {
        return (long)(StringsKt.endsWith(name, "k coins", true) ? Double.parseDouble(StringsKt.dropLast(name, 7)) * (double)1000 : (StringsKt.endsWith(name, "M coins", true) ? Double.parseDouble(StringsKt.dropLast(name, 7)) * (double)1000000 : (StringsKt.endsWith(name, "B coins", true) ? Double.parseDouble(StringsKt.dropLast(name, 7)) * (double)1000000000 : Double.parseDouble(StringsKt.replace$default(name, " coins", "", false, 4, null)))));
    }

    private final JsonObject createItemJson(ItemStack stack) {
        JsonObject jsonObject;
        JsonObject $this$createItemJson_u24lambda_u248 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$createItemJson_u24lambda_u248.addProperty("count", (Number)stack.field_77994_a);
        $this$createItemJson_u24lambda_u248.addProperty("damage", (Number)stack.func_77952_i());
        $this$createItemJson_u24lambda_u248.addProperty("nbt", stack.func_77978_p().toString());
        $this$createItemJson_u24lambda_u248.addProperty("id", stack.func_77973_b().getRegistryName());
        return jsonObject;
    }

    @NotNull
    public final JsonObject getTradeHistory() {
        return save.invoke().getTradeHistory();
    }

    private static final Unit _init_$lambda$2() {
        block5: {
            Object v3;
            block4: {
                if (Zen.Companion.getMc().field_71441_e == null) {
                    return Unit.INSTANCE;
                }
                if (Zen.Companion.getMc().field_71462_r == null) {
                    inTradeMenu = false;
                }
                if (!(((CharSequence)tradingWithSub).length() > 0)) break block5;
                WorldClient worldClient = Zen.Companion.getMc().field_71441_e;
                Intrinsics.checkNotNull(worldClient);
                List list = worldClient.field_73010_i;
                Intrinsics.checkNotNullExpressionValue(list, "playerEntities");
                Iterable iterable = list;
                for (Object t : iterable) {
                    EntityPlayer it = (EntityPlayer)t;
                    boolean bl = false;
                    String string = it.func_70005_c_();
                    Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                    if (!StringsKt.contains$default((CharSequence)string, tradingWithSub, false, 2, null)) continue;
                    v3 = t;
                    break block4;
                }
                v3 = null;
            }
            EntityPlayer entityPlayer = v3;
            if (entityPlayer != null) {
                EntityPlayer it = entityPlayer;
                boolean bl = false;
                tradingWith = it.func_70005_c_();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(ChatEvent.Receive event) {
        Intrinsics.checkNotNullParameter(event, "event");
        String string = event.getEvent().message.func_150260_c();
        Intrinsics.checkNotNullExpressionValue(string, "getUnformattedText(...)");
        if (StringsKt.startsWith$default(Utils.INSTANCE.removeFormatting(string), "Trade completed with", false, 2, null)) {
            INSTANCE.interpretLastTradeMenu();
            inTradeMenu = false;
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(GuiEvent.Slot.RenderPost event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getSlot().field_75222_d == 0) {
            String string;
            inTradeMenu = false;
            Container container = event.getGui().field_147002_h;
            if (container == null || (container = container.func_75139_a(4)) == null) {
                return Unit.INSTANCE;
            }
            Container tradeSlot = container;
            Object object = tradeSlot.func_75211_c();
            if (!Intrinsics.areEqual(object != null && (object = object.func_82833_r()) != null ? Utils.INSTANCE.removeFormatting((String)object) : null, "\u21e6 Your stuff")) {
                return Unit.INSTANCE;
            }
            inTradeMenu = true;
            lastTradeMenu = event.getGui().field_147002_h;
            String[] stringArray = Utils.INSTANCE;
            GuiContainer $this$chestName$iv = event.getGui();
            boolean $i$f$getChestName = false;
            if (!($this$chestName$iv.field_147002_h instanceof ContainerChest)) {
                string = "";
            } else {
                Container container2 = $this$chestName$iv.field_147002_h;
                Intrinsics.checkNotNull(container2, "null cannot be cast to non-null type net.minecraft.inventory.ContainerChest");
                ContainerChest chest$iv = (ContainerChest)container2;
                IInventory inv$iv = chest$iv.func_85151_d();
                String string2 = inv$iv.func_145748_c_().func_150260_c();
                Intrinsics.checkNotNullExpressionValue(string2, "getUnformattedText(...)");
                string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            }
            stringArray = new String[]{"You"};
            tradingWithSub = ((Object)StringsKt.trim((CharSequence)((String)StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null).get(1)))).toString();
        }
        return Unit.INSTANCE;
    }

    private static final Unit interpretLastTradeMenu$lambda$5(String $date, JsonObject $trade, TradeLogs $this$updateAndSave) {
        Intrinsics.checkNotNullParameter($date, "$date");
        Intrinsics.checkNotNullParameter($trade, "$trade");
        Intrinsics.checkNotNullParameter($this$updateAndSave, "$this$updateAndSave");
        if (!$this$updateAndSave.getTradeHistory().has($date)) {
            $this$updateAndSave.getTradeHistory().add($date, (JsonElement)new JsonArray());
        }
        $this$updateAndSave.getTradeHistory().get($date).getAsJsonArray().add((JsonElement)$trade);
        return Unit.INSTANCE;
    }

    static {
        int priority$iv$iv;
        boolean bl;
        Set default$iv$iv$iv;
        boolean bl2;
        EventBus this_$iv$iv;
        EventBus this_$iv;
        INSTANCE = new TradeAPI();
        save = new DataUtils<TradeLogs>("TradeAPI", new TradeLogs(null, 1, null));
        tradingWith = "";
        tradingWithSub = "";
        Object object = new Integer[]{0, 1, 2, 3, 9, 10, 11, 12, 18, 19, 20, 21, 27, 28, 29, 30};
        yourSlots = CollectionsKt.listOf(object);
        object = new Integer[]{5, 6, 7, 8, 14, 15, 16, 17, 23, 24, 25, 26, 32, 33, 34, 35};
        theirSlots = CollectionsKt.listOf(object);
        TickUtils.INSTANCE.loop(20L, TradeAPI::_init_$lambda$2);
        object = EventBus.INSTANCE;
        Function1<CancellableEvent, Unit> callback$iv = TradeAPI::_init_$lambda$3;
        boolean $i$f$register = false;
        void var3_3 = this_$iv;
        boolean bl3 = false;
        boolean add$iv$iv = true;
        boolean $i$f$register2 = false;
        Class eventClass$iv$iv = ChatEvent.Receive.class;
        ConcurrentMap $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        boolean $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object2 == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object2 = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object2 == null) {
                object2 = default$iv$iv$iv;
            }
        }
        Set handlers$iv$iv = (Set)object2;
        EventBus.PrioritizedCallback<ChatEvent.Receive> prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback<ChatEvent.Receive>(priority$iv$iv, callback$iv);
        handlers$iv$iv.add(prioritizedCallback$iv$iv);
        Intrinsics.checkNotNull(handlers$iv$iv);
        EventBus.EventCall cfr_ignored_0 = new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv);
        this_$iv = EventBus.INSTANCE;
        callback$iv = TradeAPI::_init_$lambda$4;
        $i$f$register = false;
        this_$iv$iv = this_$iv;
        priority$iv$iv = 0;
        add$iv$iv = true;
        $i$f$register2 = false;
        eventClass$iv$iv = GuiEvent.Slot.RenderPost.class;
        $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        $i$f$getOrPut = false;
        Object object3 = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object3 == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object3 = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object3 == null) {
                object3 = default$iv$iv$iv;
            }
        }
        handlers$iv$iv = (Set)object3;
        prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback<ChatEvent.Receive>(priority$iv$iv, callback$iv);
        handlers$iv$iv.add(prioritizedCallback$iv$iv);
        Intrinsics.checkNotNull(handlers$iv$iv);
        EventBus.EventCall cfr_ignored_1 = new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lmeowing/zen/api/TradeAPI$TradeLogs;", "", "tradeHistory", "Lcom/google/gson/JsonObject;", "<init>", "(Lcom/google/gson/JsonObject;)V", "getTradeHistory", "()Lcom/google/gson/JsonObject;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "zen"})
    public static final class TradeLogs {
        @NotNull
        private final JsonObject tradeHistory;

        public TradeLogs(@NotNull JsonObject tradeHistory) {
            Intrinsics.checkNotNullParameter(tradeHistory, "tradeHistory");
            this.tradeHistory = tradeHistory;
        }

        public /* synthetic */ TradeLogs(JsonObject jsonObject, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                jsonObject = new JsonObject();
            }
            this(jsonObject);
        }

        @NotNull
        public final JsonObject getTradeHistory() {
            return this.tradeHistory;
        }

        @NotNull
        public final JsonObject component1() {
            return this.tradeHistory;
        }

        @NotNull
        public final TradeLogs copy(@NotNull JsonObject tradeHistory) {
            Intrinsics.checkNotNullParameter(tradeHistory, "tradeHistory");
            return new TradeLogs(tradeHistory);
        }

        public static /* synthetic */ TradeLogs copy$default(TradeLogs tradeLogs, JsonObject jsonObject, int n, Object object) {
            if ((n & 1) != 0) {
                jsonObject = tradeLogs.tradeHistory;
            }
            return tradeLogs.copy(jsonObject);
        }

        @NotNull
        public String toString() {
            return "TradeLogs(tradeHistory=" + this.tradeHistory + ')';
        }

        public int hashCode() {
            return this.tradeHistory.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TradeLogs)) {
                return false;
            }
            TradeLogs tradeLogs = (TradeLogs)other;
            return Intrinsics.areEqual(this.tradeHistory, tradeLogs.tradeHistory);
        }

        public TradeLogs() {
            this(null, 1, null);
        }
    }
}

