/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.deps.gg.essential.elementa.constraints.animation;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import meowing.zen.deps.gg.essential.elementa.ElementaVersion;
import meowing.zen.deps.gg.essential.elementa.UIComponent;
import meowing.zen.deps.gg.essential.elementa.components.Window;
import meowing.zen.deps.gg.essential.elementa.constraints.SuperConstraint;
import meowing.zen.deps.gg.essential.elementa.constraints.animation.AnimationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001a\u001a\u00020\u001bH\u0017J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\nJ\u0006\u0010\u001f\u001a\u00020\u001bJ\u0006\u0010 \u001a\u00020\u001bJ\u0006\u0010!\u001a\u00020\u001bJ\u0015\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b%R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0010\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010\u0082\u0001\u0007&'()*+,\u00a8\u0006-"}, d2={"Lmeowing/zen/deps/gg/essential/elementa/constraints/animation/AnimationComponent;", "T", "Lmeowing/zen/deps/gg/essential/elementa/constraints/SuperConstraint;", "strategy", "Lmeowing/zen/deps/gg/essential/elementa/constraints/animation/AnimationStrategy;", "totalFrames", "", "delayFrames", "(Lgg/essential/elementa/constraints/animation/AnimationStrategy;II)V", "animationPaused", "", "getAnimationPaused", "()Z", "setAnimationPaused", "(Z)V", "getDelayFrames", "()I", "elapsedFrames", "getElapsedFrames", "setElapsedFrames", "(I)V", "lastUpdateTime", "", "getStrategy", "()Lgg/essential/elementa/constraints/animation/AnimationStrategy;", "getTotalFrames", "animationFrame", "", "getPercentComplete", "", "isComplete", "pause", "resume", "stop", "update", "component", "Lmeowing/zen/deps/gg/essential/elementa/UIComponent;", "update$Elementa", "Lmeowing/zen/deps/gg/essential/elementa/constraints/animation/ColorAnimationComponent;", "Lmeowing/zen/deps/gg/essential/elementa/constraints/animation/FieldAnimationComponent;", "Lmeowing/zen/deps/gg/essential/elementa/constraints/animation/HeightAnimationComponent;", "Lmeowing/zen/deps/gg/essential/elementa/constraints/animation/RadiusAnimationComponent;", "Lmeowing/zen/deps/gg/essential/elementa/constraints/animation/WidthAnimationComponent;", "Lmeowing/zen/deps/gg/essential/elementa/constraints/animation/XAnimationComponent;", "Lmeowing/zen/deps/gg/essential/elementa/constraints/animation/YAnimationComponent;", "Elementa"})
public abstract class AnimationComponent<T>
implements SuperConstraint<T> {
    @NotNull
    private final AnimationStrategy strategy;
    private final int totalFrames;
    private final int delayFrames;
    private int elapsedFrames;
    private boolean animationPaused;
    private long lastUpdateTime;

    private AnimationComponent(AnimationStrategy strategy, int totalFrames, int delayFrames) {
        this.strategy = strategy;
        this.totalFrames = totalFrames;
        this.delayFrames = delayFrames;
        this.lastUpdateTime = -1L;
    }

    @NotNull
    public final AnimationStrategy getStrategy() {
        return this.strategy;
    }

    public final int getTotalFrames() {
        return this.totalFrames;
    }

    public final int getDelayFrames() {
        return this.delayFrames;
    }

    public final int getElapsedFrames() {
        return this.elapsedFrames;
    }

    public final void setElapsedFrames(int n) {
        this.elapsedFrames = n;
    }

    public final boolean getAnimationPaused() {
        return this.animationPaused;
    }

    public final void setAnimationPaused(boolean bl) {
        this.animationPaused = bl;
    }

    public final void update$Elementa(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter(component2, "component");
        Window window = Window.Companion.ofOrNull(component2);
        if (window == null) {
            return;
        }
        Window window2 = window;
        if (window2.getVersion$Elementa().compareTo((Enum)ElementaVersion.Companion.getV8$Elementa()) < 0) {
            return;
        }
        long now = window2.getAnimationTimeMs();
        if (this.lastUpdateTime == -1L) {
            this.lastUpdateTime = now;
        }
        int dtMs = (int)(now - this.lastUpdateTime);
        this.lastUpdateTime = now;
        if (!this.animationPaused) {
            this.elapsedFrames = RangesKt.coerceAtMost(this.elapsedFrames + dtMs, this.totalFrames + this.delayFrames);
        }
    }

    @Override
    @Deprecated(message="See [ElementaVersion.V8].")
    public void animationFrame() {
        SuperConstraint.super.animationFrame();
        if (this.isComplete() || this.animationPaused) {
            return;
        }
        int n = this.elapsedFrames;
        this.elapsedFrames = n + 1;
    }

    public final void stop() {
        this.elapsedFrames = this.totalFrames + this.delayFrames;
    }

    public final void pause() {
        this.animationPaused = true;
    }

    public final void resume() {
        this.animationPaused = false;
    }

    public final boolean isComplete() {
        return this.elapsedFrames - this.delayFrames >= this.totalFrames;
    }

    public final float getPercentComplete() {
        return this.strategy.getValue((float)Math.max(this.elapsedFrames - this.delayFrames, 0) / (float)this.totalFrames);
    }

    public /* synthetic */ AnimationComponent(AnimationStrategy strategy, int totalFrames, int delayFrames, DefaultConstructorMarker $constructor_marker) {
        this(strategy, totalFrames, delayFrames);
    }
}

