/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.deps.gg.essential.elementa.impl.commonmark.internal;

import meowing.zen.deps.gg.essential.elementa.impl.commonmark.node.Block;
import meowing.zen.deps.gg.essential.elementa.impl.commonmark.node.ThematicBreak;
import meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.block.AbstractBlockParser;
import meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.block.AbstractBlockParserFactory;
import meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.block.BlockContinue;
import meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.block.BlockStart;
import meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.block.MatchedBlockParser;
import meowing.zen.deps.gg.essential.elementa.impl.commonmark.parser.block.ParserState;

public class ThematicBreakParser
extends AbstractBlockParser {
    private final ThematicBreak block = new ThematicBreak();

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        return BlockContinue.none();
    }

    private static boolean isThematicBreak(CharSequence line, int index) {
        int dashes = 0;
        int underscores = 0;
        int asterisks = 0;
        int length = line.length();
        block6: for (int i2 = index; i2 < length; ++i2) {
            switch (line.charAt(i2)) {
                case '-': {
                    ++dashes;
                    continue block6;
                }
                case '_': {
                    ++underscores;
                    continue block6;
                }
                case '*': {
                    ++asterisks;
                    continue block6;
                }
                case '\t': 
                case ' ': {
                    continue block6;
                }
                default: {
                    return false;
                }
            }
        }
        return dashes >= 3 && underscores == 0 && asterisks == 0 || underscores >= 3 && dashes == 0 && asterisks == 0 || asterisks >= 3 && dashes == 0 && underscores == 0;
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            if (state.getIndent() >= 4) {
                return BlockStart.none();
            }
            int nextNonSpace = state.getNextNonSpaceIndex();
            CharSequence line = state.getLine().getContent();
            if (ThematicBreakParser.isThematicBreak(line, nextNonSpace)) {
                return BlockStart.of(new ThematicBreakParser()).atIndex(line.length());
            }
            return BlockStart.none();
        }
    }
}

