/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.deps.gg.essential.elementa.impl.commonmark.renderer.html;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import meowing.zen.deps.gg.essential.elementa.impl.commonmark.renderer.html.UrlSanitizer;

public class DefaultUrlSanitizer
implements UrlSanitizer {
    private Set<String> protocols;

    public DefaultUrlSanitizer() {
        this(Arrays.asList("http", "https", "mailto"));
    }

    public DefaultUrlSanitizer(Collection<String> protocols) {
        this.protocols = new HashSet<String>(protocols);
    }

    @Override
    public String sanitizeLinkUrl(String url) {
        url = this.stripHtmlSpaces(url);
        int n = url.length();
        block4: for (int i2 = 0; i2 < n; ++i2) {
            switch (url.charAt(i2)) {
                case '#': 
                case '/': 
                case '?': {
                    break block4;
                }
                case ':': {
                    String protocol = url.substring(0, i2).toLowerCase();
                    if (this.protocols.contains(protocol)) break block4;
                    return "";
                }
                default: {
                    continue block4;
                }
            }
        }
        return url;
    }

    @Override
    public String sanitizeImageUrl(String url) {
        return this.sanitizeLinkUrl(url);
    }

    private String stripHtmlSpaces(String s) {
        int n;
        int i2 = 0;
        for (n = s.length(); n > i2 && this.isHtmlSpace(s.charAt(n - 1)); --n) {
        }
        while (i2 < n && this.isHtmlSpace(s.charAt(i2))) {
            ++i2;
        }
        if (i2 == 0 && n == s.length()) {
            return s;
        }
        return s.substring(i2, n);
    }

    private boolean isHtmlSpace(int ch) {
        switch (ch) {
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }
}

