/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.deps.gg.essential.elementa.impl.commonmark.renderer.text;

import java.io.IOException;

public class TextContentWriter {
    private final Appendable buffer;
    private char lastChar;

    public TextContentWriter(Appendable out) {
        this.buffer = out;
    }

    public void whitespace() {
        if (this.lastChar != '\u0000' && this.lastChar != ' ') {
            this.append(' ');
        }
    }

    public void colon() {
        if (this.lastChar != '\u0000' && this.lastChar != ':') {
            this.append(':');
        }
    }

    public void line() {
        if (this.lastChar != '\u0000' && this.lastChar != '\n') {
            this.append('\n');
        }
    }

    public void writeStripped(String s) {
        this.append(s.replaceAll("[\\r\\n\\s]+", " "));
    }

    public void write(String s) {
        this.append(s);
    }

    public void write(char c) {
        this.append(c);
    }

    private void append(String s) {
        try {
            this.buffer.append(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int length = s.length();
        if (length != 0) {
            this.lastChar = s.charAt(length - 1);
        }
    }

    private void append(char c) {
        try {
            this.buffer.append(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.lastChar = c;
    }
}

