/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.deps.gg.essential.elementa.impl.dom4j.datatype;

import com.sun.msv.datatype.xsd.XSDatatype;
import java.util.HashMap;
import java.util.Map;
import meowing.zen.deps.gg.essential.elementa.impl.dom4j.DocumentFactory;
import meowing.zen.deps.gg.essential.elementa.impl.dom4j.Element;
import meowing.zen.deps.gg.essential.elementa.impl.dom4j.QName;
import meowing.zen.deps.gg.essential.elementa.impl.dom4j.datatype.DatatypeElementFactory;

class NamedTypeResolver {
    protected Map<QName, DocumentFactory> complexTypeMap = new HashMap<QName, DocumentFactory>();
    protected Map<QName, XSDatatype> simpleTypeMap = new HashMap<QName, XSDatatype>();
    protected Map<Element, QName> typedElementMap = new HashMap<Element, QName>();
    protected Map<Element, DocumentFactory> elementFactoryMap = new HashMap<Element, DocumentFactory>();
    protected DocumentFactory documentFactory;

    NamedTypeResolver(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    void registerComplexType(QName type2, DocumentFactory factory) {
        this.complexTypeMap.put(type2, factory);
    }

    void registerSimpleType(QName type2, XSDatatype datatype) {
        this.simpleTypeMap.put(type2, datatype);
    }

    void registerTypedElement(Element element, QName type2, DocumentFactory parentFactory) {
        this.typedElementMap.put(element, type2);
        this.elementFactoryMap.put(element, parentFactory);
    }

    void resolveElementTypes() {
        for (Element element : this.typedElementMap.keySet()) {
            QName elementQName = this.getQNameOfSchemaElement(element);
            QName type2 = this.typedElementMap.get(element);
            if (this.complexTypeMap.containsKey(type2)) {
                DocumentFactory factory = this.complexTypeMap.get(type2);
                elementQName.setDocumentFactory(factory);
                continue;
            }
            if (!this.simpleTypeMap.containsKey(type2)) continue;
            XSDatatype datatype = this.simpleTypeMap.get(type2);
            DocumentFactory factory = this.elementFactoryMap.get(element);
            if (!(factory instanceof DatatypeElementFactory)) continue;
            ((DatatypeElementFactory)factory).setChildElementXSDatatype(elementQName, datatype);
        }
    }

    void resolveNamedTypes() {
        this.resolveElementTypes();
    }

    private QName getQNameOfSchemaElement(Element element) {
        String name = element.attributeValue("name");
        return this.getQName(name);
    }

    private QName getQName(String name) {
        return this.documentFactory.createQName(name);
    }
}

