/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.deps.gg.essential.elementa.impl.dom4j.rule;

import java.util.List;
import meowing.zen.deps.gg.essential.elementa.impl.dom4j.Document;
import meowing.zen.deps.gg.essential.elementa.impl.dom4j.Element;
import meowing.zen.deps.gg.essential.elementa.impl.dom4j.Node;
import meowing.zen.deps.gg.essential.elementa.impl.dom4j.XPath;
import meowing.zen.deps.gg.essential.elementa.impl.dom4j.rule.Action;
import meowing.zen.deps.gg.essential.elementa.impl.dom4j.rule.Mode;
import meowing.zen.deps.gg.essential.elementa.impl.dom4j.rule.Rule;
import meowing.zen.deps.gg.essential.elementa.impl.dom4j.rule.RuleManager;

public class Stylesheet {
    private RuleManager ruleManager = new RuleManager();
    private String modeName;

    public void addRule(Rule rule) {
        this.ruleManager.addRule(rule);
    }

    public void removeRule(Rule rule) {
        this.ruleManager.removeRule(rule);
    }

    public void run(List<Node> list) throws Exception {
        this.run(list, this.modeName);
    }

    public void run(List<Node> list, String mode) throws Exception {
        for (Node node2 : list) {
            this.run(node2, mode);
        }
    }

    public void run(Node node2) throws Exception {
        this.run(node2, this.modeName);
    }

    public void run(Node node2, String mode) throws Exception {
        Mode mod = this.ruleManager.getMode(mode);
        mod.fireRule(node2);
    }

    public void applyTemplates(Object input, XPath xpath) throws Exception {
        this.applyTemplates(input, xpath, this.modeName);
    }

    public void applyTemplates(Object input, XPath xpath, String mode) throws Exception {
        Mode mod = this.ruleManager.getMode(mode);
        List<Node> list = xpath.selectNodes(input);
        for (Node current : list) {
            mod.fireRule(current);
        }
    }

    public void applyTemplates(Node node2) throws Exception {
        this.applyTemplates(node2, this.modeName);
    }

    public void applyTemplates(Element element) throws Exception {
        this.applyTemplates(element, this.modeName);
    }

    public void applyTemplates(Document document) throws Exception {
        this.applyTemplates(document, this.modeName);
    }

    public void applyTemplates(List<Node> list) throws Exception {
        this.applyTemplates(list, this.modeName);
    }

    public void applyTemplates(Node node2, String mode) throws Exception {
        if (node2 instanceof Element) {
            this.applyTemplates((Element)node2, mode);
        } else if (node2 instanceof Document) {
            this.applyTemplates((Document)node2, mode);
        }
    }

    public void applyTemplates(Element element, String mode) throws Exception {
        Mode mod = this.ruleManager.getMode(mode);
        int size = element.nodeCount();
        for (int i2 = 0; i2 < size; ++i2) {
            Node node2 = element.node(i2);
            mod.fireRule(node2);
        }
    }

    public void applyTemplates(Document document, String mode) throws Exception {
        Mode mod = this.ruleManager.getMode(mode);
        int size = document.nodeCount();
        for (int i2 = 0; i2 < size; ++i2) {
            Node node2 = document.node(i2);
            mod.fireRule(node2);
        }
    }

    public void applyTemplates(List<? extends Node> list, String mode) throws Exception {
        for (Node node2 : list) {
            if (node2 instanceof Element) {
                this.applyTemplates((Element)node2, mode);
                continue;
            }
            if (!(node2 instanceof Document)) continue;
            this.applyTemplates((Document)node2, mode);
        }
    }

    public void clear() {
        this.ruleManager.clear();
    }

    public String getModeName() {
        return this.modeName;
    }

    public void setModeName(String modeName) {
        this.modeName = modeName;
    }

    public Action getValueOfAction() {
        return this.ruleManager.getValueOfAction();
    }

    public void setValueOfAction(Action valueOfAction) {
        this.ruleManager.setValueOfAction(valueOfAction);
    }
}

