/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.deps.gg.essential.elementa.markdown.selection;

import java.util.ArrayList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import meowing.zen.deps.gg.essential.elementa.markdown.DrawState;
import meowing.zen.deps.gg.essential.elementa.markdown.drawables.Drawable;
import meowing.zen.deps.gg.essential.elementa.markdown.drawables.ImageDrawable;
import meowing.zen.deps.gg.essential.elementa.markdown.drawables.TextDrawable;
import meowing.zen.deps.gg.essential.elementa.markdown.selection.Cursor;
import meowing.zen.deps.gg.essential.elementa.markdown.selection.TextCursor;
import meowing.zen.deps.gg.essential.universal.UMatrixStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\b\u0002\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0006\u0010\u0017\u001a\u00020\u000fJ(\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001d"}, d2={"Lmeowing/zen/deps/gg/essential/elementa/markdown/selection/Selection;", "", "start", "Lmeowing/zen/deps/gg/essential/elementa/markdown/selection/Cursor;", "end", "(Lgg/essential/elementa/markdown/selection/Cursor;Lgg/essential/elementa/markdown/selection/Cursor;)V", "drawables", "", "Lmeowing/zen/deps/gg/essential/elementa/markdown/drawables/Drawable;", "getDrawables", "()Ljava/util/List;", "getEnd", "()Lgg/essential/elementa/markdown/selection/Cursor;", "getStart", "draw", "", "state", "Lmeowing/zen/deps/gg/essential/elementa/markdown/DrawState;", "matrixStack", "Lmeowing/zen/deps/gg/essential/universal/UMatrixStack;", "firstTargetChild", "drawable", "nextTarget", "remove", "setSelected", "", "selected", "", "Companion", "Elementa"})
@SourceDebugExtension(value={"SMAP\nSelection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Selection.kt\ngg/essential/elementa/markdown/selection/Selection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1849#2,2:120\n*S KotlinDebug\n*F\n+ 1 Selection.kt\ngg/essential/elementa/markdown/selection/Selection\n*L\n64#1:120,2\n*E\n"})
public final class Selection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cursor<?> start;
    @NotNull
    private final Cursor<?> end;
    @NotNull
    private final List<Drawable> drawables;

    private Selection(Cursor<?> start, Cursor<?> end) {
        this.start = start;
        this.end = end;
        this.drawables = new ArrayList();
        if (Intrinsics.areEqual(this.start.getTarget(), this.end.getTarget())) {
            Pair<Integer, Integer> pair;
            this.drawables.add((Drawable)this.start.getTarget());
            if (this.start instanceof TextCursor) {
                Integer n = ((TextCursor)this.start).getOffset();
                Cursor<?> cursor = this.end;
                Intrinsics.checkNotNull(cursor, "null cannot be cast to non-null type gg.essential.elementa.markdown.selection.TextCursor");
                pair = TuplesKt.to(n, ((TextCursor)cursor).getOffset());
            } else {
                pair = TuplesKt.to(-1, -1);
            }
            Pair<Integer, Integer> pair2 = pair;
            int cursorStart = ((Number)pair2.component1()).intValue();
            int cursorEnd = ((Number)pair2.component2()).intValue();
            this.setSelected((Drawable)this.start.getTarget(), cursorStart, cursorEnd, true);
        } else {
            Pair<Integer, Integer> pair = this.start instanceof TextCursor ? TuplesKt.to(((TextCursor)this.start).getOffset(), ((TextDrawable)((TextCursor)this.start).getTarget()).plainText().length()) : TuplesKt.to(-1, -1);
            int cursorStart = ((Number)pair.component1()).intValue();
            int cursorEnd = ((Number)pair.component2()).intValue();
            this.setSelected((Drawable)this.start.getTarget(), cursorStart, cursorEnd, true);
            Object currentTarget = this.start.getTarget();
            while (currentTarget != null) {
                int cursorEnd2;
                int cursorStart2;
                Pair<Integer, Integer> pair3;
                this.drawables.add((Drawable)currentTarget);
                Object object = currentTarget = this.nextTarget((Drawable)currentTarget);
                if (object == null) {
                    throw new IllegalStateException();
                }
                if (Intrinsics.areEqual(object, this.end.getTarget())) {
                    this.drawables.add((Drawable)currentTarget);
                    pair3 = this.end instanceof TextCursor ? TuplesKt.to(0, ((TextCursor)this.end).getOffset()) : TuplesKt.to(-1, -1);
                    cursorStart2 = ((Number)pair3.component1()).intValue();
                    cursorEnd2 = ((Number)pair3.component2()).intValue();
                    this.setSelected((Drawable)currentTarget, cursorStart2, cursorEnd2, true);
                    break;
                }
                pair3 = currentTarget instanceof TextDrawable ? TuplesKt.to(0, ((TextDrawable)currentTarget).plainText().length()) : TuplesKt.to(-1, -1);
                cursorStart2 = ((Number)pair3.component1()).intValue();
                cursorEnd2 = ((Number)pair3.component2()).intValue();
                this.setSelected((Drawable)currentTarget, cursorStart2, cursorEnd2, true);
            }
        }
    }

    @NotNull
    public final Cursor<?> getStart() {
        return this.start;
    }

    @NotNull
    public final Cursor<?> getEnd() {
        return this.end;
    }

    @NotNull
    public final List<Drawable> getDrawables() {
        return this.drawables;
    }

    @Deprecated(message="For 1.17 this method requires you pass a UMatrixStack as the first argument.\n\nIf you are currently extending this method, you should instead extend the method with the added argument.\nNote however for this to be non-breaking, your parent class needs to transition before you do.\n\nIf you are calling this method and you cannot guarantee that your target class has been fully updated (such as when\ncalling an open method on an open class), you should instead call the method with the \"Compat\" suffix, which will\ncall both methods, the new and the deprecated one.\nIf you are sure that your target class has been updated (such as when calling the super method), you should\n(for super calls you must!) instead just call the method with the original name and added argument.", replaceWith=@ReplaceWith(expression="draw(matrixStack, state)", imports={}))
    public final void draw(@NotNull DrawState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        this.draw(new UMatrixStack(), state);
    }

    public final void draw(@NotNull UMatrixStack matrixStack, @NotNull DrawState state) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        Intrinsics.checkNotNullParameter(state, "state");
        this.start.draw(matrixStack, state);
        this.end.draw(matrixStack, state);
    }

    public final void remove() {
        Iterable $this$forEach$iv = this.drawables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it = (Drawable)element$iv;
            boolean bl = false;
            this.setSelected(it, -1, -1, false);
        }
    }

    private final Drawable nextTarget(Drawable drawable) {
        Drawable nextTarget;
        for (nextTarget = drawable.getNext(); nextTarget != null && !(nextTarget instanceof TextDrawable) && !(nextTarget instanceof ImageDrawable); nextTarget = nextTarget.getNext()) {
        }
        if (nextTarget instanceof TextDrawable || nextTarget instanceof ImageDrawable) {
            return nextTarget;
        }
        Drawable drawable2 = drawable.getParent();
        if (drawable2 == null) {
            return null;
        }
        Drawable nextContainer = drawable2;
        while (nextContainer.getNext() == null) {
            if (nextContainer.getParent() == null) {
                return null;
            }
            Intrinsics.checkNotNull(nextContainer.getParent());
        }
        Drawable drawable3 = nextContainer.getNext();
        Intrinsics.checkNotNull(drawable3);
        return this.firstTargetChild(drawable3);
    }

    private final Drawable firstTargetChild(Drawable drawable) {
        if (drawable instanceof TextDrawable || drawable instanceof ImageDrawable) {
            return drawable;
        }
        if (drawable.getChildren().isEmpty()) {
            return null;
        }
        return this.firstTargetChild(CollectionsKt.first(drawable.getChildren()));
    }

    private final void setSelected(Drawable drawable, int start, int end, boolean selected) {
        Drawable drawable2 = drawable;
        if (drawable2 instanceof TextDrawable) {
            ((TextDrawable)drawable).setSelectionStart(start);
            ((TextDrawable)drawable).setSelectionEnd(end);
        } else if (drawable2 instanceof ImageDrawable) {
            ((ImageDrawable)drawable).setSelected(selected);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public /* synthetic */ Selection(Cursor start, Cursor end, DefaultConstructorMarker $constructor_marker) {
        this(start, end);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a8\u0006\b"}, d2={"Lmeowing/zen/deps/gg/essential/elementa/markdown/selection/Selection$Companion;", "", "()V", "fromCursors", "Lmeowing/zen/deps/gg/essential/elementa/markdown/selection/Selection;", "first", "Lmeowing/zen/deps/gg/essential/elementa/markdown/selection/Cursor;", "second", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Selection fromCursors(@NotNull Cursor<?> first2, @NotNull Cursor<?> second2) {
            Intrinsics.checkNotNullParameter(first2, "first");
            Intrinsics.checkNotNullParameter(second2, "second");
            return first2.compareTo(second2) <= 0 ? new Selection(first2, second2, null) : new Selection(second2, first2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

