/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.features.dungeons;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import meowing.zen.Zen;
import meowing.zen.config.ui.ConfigUI;
import meowing.zen.config.ui.types.ConfigElement;
import meowing.zen.config.ui.types.ElementType;
import meowing.zen.events.ChatEvent;
import meowing.zen.events.EventBus;
import meowing.zen.features.Feature;
import meowing.zen.utils.ChatUtils;
import meowing.zen.utils.SimpleTimeMark;
import meowing.zen.utils.TimeUtils;
import meowing.zen.utils.TitleUtils;
import meowing.zen.utils.Utils;
import org.jetbrains.annotations.NotNull;

@Zen.Module
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lmeowing/zen/features/dungeons/BloodTimer;", "Lmeowing/zen/features/Feature;", "<init>", "()V", "bloodstart", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "dialogue", "bloodcamp", "bloodopen", "", "starttime", "Lmeowing/zen/utils/SimpleTimeMark;", "J", "addConfig", "Lmeowing/zen/config/ui/ConfigUI;", "configUI", "initialize", "", "onRegister", "onUnregister", "zen"})
@SourceDebugExtension(value={"SMAP\nBloodTimer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BloodTimer.kt\nmeowing/zen/features/dungeons/BloodTimer\n+ 2 Feature.kt\nmeowing/zen/features/Feature\n+ 3 EventBus.kt\nmeowing/zen/events/EventBus\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 TimeUtils.kt\nmeowing/zen/utils/TimeUtils\n+ 7 TimeUtils.kt\nmeowing/zen/utils/SimpleTimeMark\n*L\n1#1,66:1\n113#2,2:67\n115#2:77\n194#3,2:69\n196#3,3:74\n72#4,2:71\n1#5:73\n59#6:78\n59#6:79\n58#6:80\n58#6:82\n58#6:84\n59#6:85\n23#7:81\n23#7:83\n*S KotlinDebug\n*F\n+ 1 BloodTimer.kt\nmeowing/zen/features/dungeons/BloodTimer\n*L\n34#1:67,2\n34#1:77\n34#1:69,2\n34#1:74,3\n34#1:71,2\n34#1:73\n57#1:78\n63#1:79\n39#1:80\n42#1:82\n47#1:84\n22#1:85\n42#1:81\n47#1:83\n*E\n"})
public final class BloodTimer
extends Feature {
    @NotNull
    public static final BloodTimer INSTANCE = new BloodTimer();
    private static final Pattern bloodstart = Pattern.compile("\\[BOSS] The Watcher: .+");
    private static final Pattern dialogue = Pattern.compile("\\[BOSS] The Watcher: Let's see how you can handle this\\.");
    private static final Pattern bloodcamp = Pattern.compile("\\[BOSS] The Watcher: You have proven yourself\\. You may pass\\.");
    private static boolean bloodopen;
    private static long starttime;

    private BloodTimer() {
        super("bloodtimer", false, "catacombs", null, 10, null);
    }

    @Override
    @NotNull
    public ConfigUI addConfig(@NotNull ConfigUI configUI) {
        Intrinsics.checkNotNullParameter((Object)configUI, "configUI");
        return configUI.addElement("Dungeons", "Blood helper", new ConfigElement("bloodtimer", "Blood camp helper", new ElementType.Switch(false), null, 8, null), true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize() {
        void this_$iv$iv;
        Function1<ChatEvent.Receive, Unit> cb$iv = BloodTimer::initialize$lambda$0;
        int priority$iv = 0;
        boolean $i$f$register = false;
        List<EventBus.EventCall> list = ((Feature)this).getEvents();
        EventBus eventBus = EventBus.INSTANCE;
        boolean add$iv$iv = false;
        boolean $i$f$register2 = false;
        Class<ChatEvent.Receive> eventClass$iv$iv = ChatEvent.Receive.class;
        ConcurrentMap $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object == null) {
            boolean bl = false;
            Set default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            boolean bl2 = false;
            object = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object == null) {
                object = default$iv$iv$iv;
            }
        }
        Set handlers$iv$iv = (Set)object;
        EventBus.PrioritizedCallback<ChatEvent.Receive> prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback<ChatEvent.Receive>(priority$iv, cb$iv);
        Intrinsics.checkNotNull(handlers$iv$iv);
        list.add(new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv));
    }

    @Override
    public void onRegister() {
        bloodopen = false;
        TimeUtils this_$iv = TimeUtils.INSTANCE;
        boolean bl = false;
        starttime = SimpleTimeMark.constructor-impl(0L);
        super.onRegister();
    }

    @Override
    public void onUnregister() {
        bloodopen = false;
        TimeUtils this_$iv = TimeUtils.INSTANCE;
        boolean bl = false;
        starttime = SimpleTimeMark.constructor-impl(0L);
        super.onUnregister();
    }

    private static final Unit initialize$lambda$0(ChatEvent.Receive event) {
        Intrinsics.checkNotNullParameter(event, "event");
        String string = event.getEvent().message.func_150260_c();
        Intrinsics.checkNotNullExpressionValue(string, "getUnformattedText(...)");
        String text = Utils.INSTANCE.removeFormatting(string);
        if (!bloodopen && bloodstart.matcher(text).matches()) {
            bloodopen = true;
            TimeUtils this_$iv = TimeUtils.INSTANCE;
            boolean bl = false;
            starttime = SimpleTimeMark.constructor-impl(System.currentTimeMillis());
        } else if (dialogue.matcher(text).matches()) {
            long arg0$iv22 = starttime;
            boolean bl = false;
            TimeUtils this_$iv$iv = TimeUtils.INSTANCE;
            boolean bl2 = false;
            double diftime = Duration.getInWholeSeconds-impl(SimpleTimeMark.minus-iv8dxc0(SimpleTimeMark.constructor-impl(System.currentTimeMillis()), arg0$iv22));
            TitleUtils.showTitle$default(TitleUtils.INSTANCE, "\u00a7c\u00a7l!", "\u00a7cWatcher reached dialogue!", 3000, 0.0f, 8, null);
            StringBuilder stringBuilder = new StringBuilder().append("\u00a77[\u00a7bZen\u00a77] \u00a7fWatcher took \u00a7c");
            String arg0$iv22 = "%.2f";
            Object[] objectArray = new Object[]{diftime};
            String string2 = String.format(arg0$iv22, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            ChatUtils.addMessage$default(ChatUtils.INSTANCE, stringBuilder.append(string2).append("s \u00a7fto reach dialogue!").toString(), null, null, null, null, 30, null);
        } else if (bloodcamp.matcher(text).matches()) {
            long arg0$iv = starttime;
            boolean bl = false;
            TimeUtils this_$iv$iv = TimeUtils.INSTANCE;
            boolean bl3 = false;
            double camptime = Duration.getInWholeSeconds-impl(SimpleTimeMark.minus-iv8dxc0(SimpleTimeMark.constructor-impl(System.currentTimeMillis()), arg0$iv));
            StringBuilder stringBuilder = new StringBuilder().append("\u00a77[\u00a7bZen\u00a77] \u00a7fBlood camp took \u00a7c");
            String string3 = "%.2f";
            Object[] objectArray = new Object[]{camptime};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
            ChatUtils.addMessage$default(ChatUtils.INSTANCE, stringBuilder.append(string4).append('s').toString(), null, null, null, null, 30, null);
            bloodopen = false;
        }
        return Unit.INSTANCE;
    }

    static {
        TimeUtils this_$iv = TimeUtils.INSTANCE;
        boolean bl = false;
        starttime = SimpleTimeMark.constructor-impl(0L);
    }
}

