/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.features.dungeons;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import meowing.zen.Zen;
import meowing.zen.config.ui.ConfigUI;
import meowing.zen.config.ui.types.ConfigElement;
import meowing.zen.config.ui.types.ElementType;
import meowing.zen.events.ChatEvent;
import meowing.zen.events.Event;
import meowing.zen.events.EventBus;
import meowing.zen.events.TickEvent;
import meowing.zen.features.Feature;
import meowing.zen.utils.ChatUtils;
import meowing.zen.utils.TickUtils;
import meowing.zen.utils.Utils;
import org.jetbrains.annotations.NotNull;

@Zen.Module
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lmeowing/zen/features/dungeons/ServerLagTimer;", "Lmeowing/zen/features/Feature;", "<init>", "()V", "regex", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "sent", "", "ticking", "clienttick", "", "servertick", "addConfig", "Lmeowing/zen/config/ui/ConfigUI;", "configUI", "initialize", "", "onRegister", "onUnregister", "zen"})
@SourceDebugExtension(value={"SMAP\nServerLagTimer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerLagTimer.kt\nmeowing/zen/features/dungeons/ServerLagTimer\n+ 2 Feature.kt\nmeowing/zen/features/Feature\n+ 3 EventBus.kt\nmeowing/zen/events/EventBus\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n113#2,2:77\n115#2:87\n113#2,2:88\n115#2:98\n113#2,2:99\n115#2:109\n194#3,2:79\n196#3,3:84\n194#3,2:90\n196#3,3:95\n194#3,2:101\n196#3,3:106\n72#4,2:81\n72#4,2:92\n72#4,2:103\n1#5:83\n1#5:94\n1#5:105\n*S KotlinDebug\n*F\n+ 1 ServerLagTimer.kt\nmeowing/zen/features/dungeons/ServerLagTimer\n*L\n34#1:77,2\n34#1:87\n52#1:88,2\n52#1:98\n55#1:99,2\n55#1:109\n34#1:79,2\n34#1:84,3\n52#1:90,2\n52#1:95,3\n55#1:101,2\n55#1:106,3\n34#1:81,2\n52#1:92,2\n55#1:103,2\n34#1:83\n52#1:94\n55#1:105\n*E\n"})
public final class ServerLagTimer
extends Feature {
    @NotNull
    public static final ServerLagTimer INSTANCE = new ServerLagTimer();
    private static final Pattern regex = Pattern.compile("^\\s*\u2620 Defeated .+ in 0?[\\dhms ]+?\\s*(?:\\(NEW RECORD!\\))?$");
    private static boolean sent;
    private static boolean ticking;
    private static long clienttick;
    private static long servertick;

    private ServerLagTimer() {
        super("serverlagtimer", false, "catacombs", null, 10, null);
    }

    @Override
    @NotNull
    public ConfigUI addConfig(@NotNull ConfigUI configUI) {
        Intrinsics.checkNotNullParameter((Object)configUI, "configUI");
        return configUI.addElement("Dungeons", "Server lag timer", new ConfigElement("serverlagtimer", null, new ElementType.Switch(false), null, 8, null), true);
    }

    @Override
    public void initialize() {
        boolean bl;
        Set default$iv$iv$iv;
        boolean bl2;
        EventBus this_$iv$iv;
        Function1<Event, Unit> cb$iv = ServerLagTimer::initialize$lambda$1;
        int priority$iv = 0;
        boolean $i$f$register = false;
        List<EventBus.EventCall> list = ((Feature)this).getEvents();
        EventBus eventBus = EventBus.INSTANCE;
        boolean add$iv$iv = false;
        boolean $i$f$register2 = false;
        Class eventClass$iv$iv = ChatEvent.Receive.class;
        ConcurrentMap $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object == null) {
                object = default$iv$iv$iv;
            }
        }
        Set handlers$iv$iv = (Set)object;
        EventBus.PrioritizedCallback<ChatEvent.Receive> prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback<ChatEvent.Receive>(priority$iv, cb$iv);
        Intrinsics.checkNotNull(handlers$iv$iv);
        list.add(new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv));
        cb$iv = ServerLagTimer::initialize$lambda$2;
        priority$iv = 0;
        $i$f$register = false;
        List<EventBus.EventCall> list2 = ((Feature)this).getEvents();
        this_$iv$iv = EventBus.INSTANCE;
        add$iv$iv = false;
        $i$f$register2 = false;
        eventClass$iv$iv = TickEvent.Server.class;
        $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object2 == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object2 = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object2 == null) {
                object2 = default$iv$iv$iv;
            }
        }
        handlers$iv$iv = (Set)object2;
        prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback<ChatEvent.Receive>(priority$iv, cb$iv);
        Intrinsics.checkNotNull(handlers$iv$iv);
        list2.add(new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv));
        cb$iv = ServerLagTimer::initialize$lambda$3;
        priority$iv = 0;
        $i$f$register = false;
        List<EventBus.EventCall> list3 = ((Feature)this).getEvents();
        this_$iv$iv = EventBus.INSTANCE;
        add$iv$iv = false;
        $i$f$register2 = false;
        eventClass$iv$iv = TickEvent.Client.class;
        $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        $i$f$getOrPut = false;
        Object object3 = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object3 == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object3 = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object3 == null) {
                object3 = default$iv$iv$iv;
            }
        }
        handlers$iv$iv = (Set)object3;
        prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback<ChatEvent.Receive>(priority$iv, cb$iv);
        Intrinsics.checkNotNull(handlers$iv$iv);
        list3.add(new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv));
    }

    @Override
    public void onRegister() {
        sent = false;
        clienttick = 0L;
        servertick = 0L;
        ticking = false;
        super.onRegister();
    }

    @Override
    public void onUnregister() {
        sent = false;
        clienttick = 0L;
        servertick = 0L;
        ticking = false;
        super.onUnregister();
    }

    private static final Unit initialize$lambda$1$lambda$0(double $lagtime, long $lagtick) {
        StringBuilder stringBuilder = new StringBuilder().append("\u00a77[\u00a7bZen\u00a77] \u00a7fServer lagged for \u00a7c");
        String string = "%.1f";
        Object[] objectArray = new Object[]{$lagtime};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        ChatUtils.addMessage$default(ChatUtils.INSTANCE, stringBuilder.append(string2).append("s \u00a77| \u00a7c").append($lagtick).append(" ticks\u00a7f.").toString(), null, null, null, null, 30, null);
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$1(ChatEvent.Receive event) {
        Intrinsics.checkNotNullParameter(event, "event");
        String string = event.getEvent().message.func_150260_c();
        Intrinsics.checkNotNullExpressionValue(string, "getUnformattedText(...)");
        String text = Utils.INSTANCE.removeFormatting(string);
        if (Intrinsics.areEqual(text, "[NPC] Mort: Good luck.")) {
            ticking = true;
            sent = false;
        } else if (regex.matcher(text).matches() && !sent) {
            long lagtick = clienttick - servertick;
            double lagtime = (double)lagtick / 20.0;
            ticking = false;
            sent = true;
            TickUtils.INSTANCE.schedule(2L, () -> ServerLagTimer.initialize$lambda$1$lambda$0(lagtime, lagtick));
        }
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$2(TickEvent.Server event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (ticking) {
            long l = servertick;
            servertick = l + 1L;
        }
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$3(TickEvent.Client event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (ticking) {
            long l = clienttick;
            clienttick = l + 1L;
        }
        return Unit.INSTANCE;
    }
}

