/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.features.general;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import meowing.zen.Zen;
import meowing.zen.config.ui.ConfigUI;
import meowing.zen.config.ui.types.ConfigElement;
import meowing.zen.config.ui.types.ElementType;
import meowing.zen.events.ChatEvent;
import meowing.zen.events.EventBus;
import meowing.zen.features.Feature;
import meowing.zen.utils.ChatUtils;
import org.jetbrains.annotations.NotNull;

@Zen.Module
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lmeowing/zen/features/general/ChatEmotes;", "Lmeowing/zen/features/Feature;", "<init>", "()V", "HYPIXEL_EMOTES", "", "", "getHYPIXEL_EMOTES", "()Ljava/util/Map;", "addConfig", "Lmeowing/zen/config/ui/ConfigUI;", "configUI", "initialize", "", "zen"})
@SourceDebugExtension(value={"SMAP\nChatEmotes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatEmotes.kt\nmeowing/zen/features/general/ChatEmotes\n+ 2 Feature.kt\nmeowing/zen/features/Feature\n+ 3 EventBus.kt\nmeowing/zen/events/EventBus\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n113#2,2:77\n115#2:87\n194#3,2:79\n196#3,3:84\n72#4,2:81\n1#5:83\n*S KotlinDebug\n*F\n+ 1 ChatEmotes.kt\nmeowing/zen/features/general/ChatEmotes\n*L\n62#1:77,2\n62#1:87\n62#1:79,2\n62#1:84,3\n62#1:81,2\n62#1:83\n*E\n"})
public final class ChatEmotes
extends Feature {
    @NotNull
    public static final ChatEmotes INSTANCE = new ChatEmotes();
    @NotNull
    private static final Map<String, String> HYPIXEL_EMOTES;

    private ChatEmotes() {
        super("chatemotes", false, null, null, 14, null);
    }

    @NotNull
    public final Map<String, String> getHYPIXEL_EMOTES() {
        return HYPIXEL_EMOTES;
    }

    @Override
    @NotNull
    public ConfigUI addConfig(@NotNull ConfigUI configUI) {
        Intrinsics.checkNotNullParameter((Object)configUI, "configUI");
        return ConfigUI.addElement$default(configUI.addElement("General", "Chat Emotes", new ConfigElement("chatemotes", "Automatically replace emote codes with Unicode symbols in chat messages", new ElementType.Switch(true), null, 8, null), true), "General", "Chat Emotes", "", new ConfigElement("", null, new ElementType.TextParagraph("Automatically replace emote codes with Unicode symbols in chat messages, example: <3 becomes \u2764, use /emotes to see all supported emotes."), null, 8, null), false, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize() {
        void this_$iv$iv;
        Regex emotePattern = new Regex(CollectionsKt.joinToString$default(HYPIXEL_EMOTES.keySet(), "|", null, null, 0, null, ChatEmotes::initialize$lambda$0, 30, null));
        Function1<ChatEvent.Send, Unit> cb$iv = arg_0 -> ChatEmotes.initialize$lambda$2(emotePattern, arg_0);
        int priority$iv = 0;
        boolean $i$f$register = false;
        List<EventBus.EventCall> list = ((Feature)this).getEvents();
        EventBus eventBus = EventBus.INSTANCE;
        boolean add$iv$iv = false;
        boolean $i$f$register2 = false;
        Class<ChatEvent.Send> eventClass$iv$iv = ChatEvent.Send.class;
        ConcurrentMap $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object == null) {
            boolean bl = false;
            Set default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            boolean bl2 = false;
            object = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object == null) {
                object = default$iv$iv$iv;
            }
        }
        Set handlers$iv$iv = (Set)object;
        EventBus.PrioritizedCallback<ChatEvent.Send> prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback<ChatEvent.Send>(priority$iv, cb$iv);
        Intrinsics.checkNotNull(handlers$iv$iv);
        list.add(new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv));
    }

    private static final CharSequence initialize$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Regex.Companion.escape(it);
    }

    private static final CharSequence initialize$lambda$2$lambda$1(MatchResult matchResult) {
        Intrinsics.checkNotNullParameter(matchResult, "matchResult");
        String string = HYPIXEL_EMOTES.get(matchResult.getValue());
        return string != null ? (CharSequence)string : (CharSequence)matchResult.getValue();
    }

    private static final Unit initialize$lambda$2(Regex $emotePattern, ChatEvent.Send event) {
        Intrinsics.checkNotNullParameter($emotePattern, "$emotePattern");
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getChatUtils()) {
            return Unit.INSTANCE;
        }
        String newMessage = $emotePattern.replace((CharSequence)event.getMessage(), ChatEmotes::initialize$lambda$2$lambda$1);
        if (!Intrinsics.areEqual(newMessage, event.getMessage())) {
            event.cancel();
            ChatUtils.INSTANCE.chat(newMessage);
        }
        return Unit.INSTANCE;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to("<3", "\u2764"), TuplesKt.to(":star:", "\u272e"), TuplesKt.to(":yes:", "\u2714"), TuplesKt.to(":no:", "\u2716"), TuplesKt.to(":java:", "\u2615"), TuplesKt.to(":arrow:", "\u279c"), TuplesKt.to(":shrug:", "\u00af\\_(\u30c4)_/\u00af"), TuplesKt.to(":tableflip:", "(\u256f\u00b0\u25a1\u00b0\uff09\u256f\ufe35 \u253b\u2501\u253b"), TuplesKt.to("o/", "( \uff9f\u25e1\uff9f)/"), TuplesKt.to(":123:", "123"), TuplesKt.to(":totem:", "\u25ce_\u25ce"), TuplesKt.to(":typing:", "\u270e..."), TuplesKt.to(":maths:", "\u221a(\u03c0+x)=L"), TuplesKt.to(":snail:", "@'-'"), TuplesKt.to(":thinking:", "(0.o?)"), TuplesKt.to(":gimme:", "\u0f3c\u3064 \u25d5_\u25d5 \u0f3d\u3064"), TuplesKt.to(":wizard:", "('-')\u2283\u2501\u2606\uff9f.*\uff65\uff61\uff9f"), TuplesKt.to(":pvp:", "\u2694"), TuplesKt.to(":peace:", "\u270c"), TuplesKt.to(":oof:", "OOF"), TuplesKt.to(":puffer:", "<('O')>"), TuplesKt.to(":snow:", "\u2603"), TuplesKt.to(":dog:", "(\u1d54\u1d25\u1d54)"), TuplesKt.to(":sloth:", "( \u2b29 \u229d \u2b29 )"), TuplesKt.to(":dab:", "<o/"), TuplesKt.to(":cat:", "\u14da\u160f\u15e2")};
        HYPIXEL_EMOTES = MapsKt.mapOf(pairArray);
    }
}

