/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.features.general;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import meowing.zen.Zen;
import meowing.zen.config.ui.ConfigUI;
import meowing.zen.config.ui.types.ConfigElement;
import meowing.zen.config.ui.types.ElementType;
import meowing.zen.events.ChatEvent;
import meowing.zen.events.EventBus;
import meowing.zen.features.Feature;
import meowing.zen.utils.ChatUtils;
import meowing.zen.utils.Utils;
import org.jetbrains.annotations.NotNull;

@Zen.Module
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lmeowing/zen/features/general/CleanPartyMessage;", "Lmeowing/zen/features/Feature;", "<init>", "()V", "partyPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "rankPattern", "addConfig", "Lmeowing/zen/config/ui/ConfigUI;", "configUI", "initialize", "", "getRankColor", "", "rank", "zen"})
@SourceDebugExtension(value={"SMAP\nCleanMessages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CleanMessages.kt\nmeowing/zen/features/general/CleanPartyMessage\n+ 2 Feature.kt\nmeowing/zen/features/Feature\n+ 3 EventBus.kt\nmeowing/zen/events/EventBus\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n113#2,2:98\n115#2:108\n194#3,2:100\n196#3,3:105\n72#4,2:102\n1#5:104\n1#5:109\n*S KotlinDebug\n*F\n+ 1 CleanMessages.kt\nmeowing/zen/features/general/CleanPartyMessage\n*L\n72#1:98,2\n72#1:108\n72#1:100,2\n72#1:105,3\n72#1:102,2\n72#1:104\n*E\n"})
public final class CleanPartyMessage
extends Feature {
    @NotNull
    public static final CleanPartyMessage INSTANCE = new CleanPartyMessage();
    private static final Pattern partyPattern = Pattern.compile("Party > (\\[.+?])? ?(.+?): (.+)");
    private static final Pattern rankPattern = Pattern.compile("\\[(.+?)]");

    private CleanPartyMessage() {
        super("partymessage", false, null, null, 14, null);
    }

    @Override
    @NotNull
    public ConfigUI addConfig(@NotNull ConfigUI configUI) {
        Intrinsics.checkNotNullParameter((Object)configUI, "configUI");
        return ConfigUI.addElement$default(configUI, "General", "Clean Chat", "Clean messages", new ConfigElement("partymessage", "Clean party messages", new ElementType.Switch(false), null, 8, null), false, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize() {
        void this_$iv$iv;
        Function1<ChatEvent.Receive, Unit> cb$iv = CleanPartyMessage::initialize$lambda$0;
        int priority$iv = 0;
        boolean $i$f$register = false;
        List<EventBus.EventCall> list = ((Feature)this).getEvents();
        EventBus eventBus = EventBus.INSTANCE;
        boolean add$iv$iv = false;
        boolean $i$f$register2 = false;
        Class<ChatEvent.Receive> eventClass$iv$iv = ChatEvent.Receive.class;
        ConcurrentMap $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object == null) {
            boolean bl = false;
            Set default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            boolean bl2 = false;
            object = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object == null) {
                object = default$iv$iv$iv;
            }
        }
        Set handlers$iv$iv = (Set)object;
        EventBus.PrioritizedCallback<ChatEvent.Receive> prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback<ChatEvent.Receive>(priority$iv, cb$iv);
        Intrinsics.checkNotNull(handlers$iv$iv);
        list.add(new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getRankColor(String rank) {
        Matcher matcher;
        if (((CharSequence)rank).length() == 0) {
            return "7";
        }
        boolean bl = false;
        if (bl) {
            return "7";
        }
        Matcher it = matcher = rankPattern.matcher(rank);
        boolean bl2 = false;
        if (!it.find()) return "7";
        Matcher matcher2 = matcher;
        if (matcher2 == null) return "7";
        String string = matcher2.group(1);
        String string2 = string;
        if (string2 == null) return "7";
        int n = -1;
        switch (string2.hashCode()) {
            case -2137064498: {
                if (string2.equals("Helper")) {
                    n = 1;
                }
                break;
            }
            case 0x244D44: {
                if (string2.equals("MVP+")) {
                    n = 2;
                }
                break;
            }
            case 73751399: {
                if (string2.equals("MVP++")) {
                    n = 2;
                }
                break;
            }
            case 77538: {
                if (string2.equals("Mod")) {
                    n = 3;
                }
                break;
            }
            case 2278: {
                if (string2.equals("GM")) {
                    n = 3;
                }
                break;
            }
            case 76743: {
                if (string2.equals("MVP")) {
                    n = 2;
                }
                break;
            }
            case 2634702: {
                if (string2.equals("VIP+")) {
                    n = 4;
                }
                break;
            }
            case 63116079: {
                if (string2.equals("Admin")) {
                    n = 5;
                }
                break;
            }
            case 84989: {
                if (string2.equals("VIP")) {
                    n = 4;
                }
                break;
            }
        }
        switch (n) {
            case 5: {
                return "c";
            }
            case 3: {
                return "2";
            }
            case 1: {
                return "b";
            }
            case 2: {
                if (!StringsKt.contains$default((CharSequence)rank, "++", false, 2, null)) return "b";
                return "6";
            }
            case 4: {
                return "a";
            }
            default: {
                return "7";
            }
        }
    }

    private static final Unit initialize$lambda$0(ChatEvent.Receive event) {
        Intrinsics.checkNotNullParameter(event, "event");
        String string = event.getEvent().message.func_150260_c();
        Intrinsics.checkNotNullExpressionValue(string, "getUnformattedText(...)");
        String text = Utils.INSTANCE.removeFormatting(string);
        Matcher m = partyPattern.matcher(text);
        if (m.matches()) {
            String string2;
            String user;
            String string3;
            String hrank;
            event.cancel();
            String string4 = m.group(1);
            if (string4 == null) {
                string4 = hrank = "";
            }
            if ((string3 = m.group(2)) == null) {
                string3 = user = "";
            }
            if ((string2 = m.group(3)) == null) {
                string2 = "";
            }
            String msg = string2;
            String formatted = "\u00a79P \u00a78> \u00a7" + INSTANCE.getRankColor(hrank) + user + "\u00a7f: " + msg;
            ChatUtils.addMessage$default(ChatUtils.INSTANCE, formatted, null, null, null, null, 30, null);
        }
        return Unit.INSTANCE;
    }
}

