/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.features.hud;

import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.Regex;
import meowing.zen.Zen;
import meowing.zen.api.ItemAPI;
import meowing.zen.config.Handler;
import meowing.zen.config.ui.ConfigUI;
import meowing.zen.config.ui.types.ConfigElement;
import meowing.zen.config.ui.types.ElementType;
import meowing.zen.events.Event;
import meowing.zen.events.EventBus;
import meowing.zen.events.PacketEvent;
import meowing.zen.events.RenderEvent;
import meowing.zen.features.Feature;
import meowing.zen.features.hud.ItemPickupLog;
import meowing.zen.hud.HUDManager;
import meowing.zen.utils.ItemUtils;
import meowing.zen.utils.NumberUtils;
import meowing.zen.utils.Render2D;
import meowing.zen.utils.StringUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.S2FPacketSetSlot;
import org.jetbrains.annotations.NotNull;

@Zen.Module
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001)B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0002J\u0016\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0015\u0018\u00010$H\u0002J0\u0010%\u001a\u00020!2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150$2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150$H\u0002J\b\u0010(\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00190\u00180\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001b0\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006*"}, d2={"Lmeowing/zen/features/hud/ItemPickupLog;", "Lmeowing/zen/features/Feature;", "<init>", "()V", "name", "", "ignoreStacksRegex", "", "Lkotlin/text/Regex;", "abbreviateNumbers", "", "getAbbreviateNumbers", "()Z", "abbreviateNumbers$delegate", "Lmeowing/zen/config/Handler;", "npcSellingStackRegex", "addConfig", "Lmeowing/zen/config/ui/ConfigUI;", "configUI", "previousInventory", "", "", "currentInventory", "items", "Lkotlin/Pair;", "Lnet/minecraft/item/ItemStack;", "displayLines", "Lmeowing/zen/features/hud/ItemPickupLog$PickupEntry;", "getDisplayLines", "()Ljava/util/Map;", "setDisplayLines", "(Ljava/util/Map;)V", "initialize", "", "render", "getCurrentInventoryState", "", "compareInventories", "previous", "current", "getPreviousItemName", "PickupEntry", "zen"})
@SourceDebugExtension(value={"SMAP\nItemPickupLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemPickupLog.kt\nmeowing/zen/features/hud/ItemPickupLog\n+ 2 Feature.kt\nmeowing/zen/features/Feature\n+ 3 EventBus.kt\nmeowing/zen/events/EventBus\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 8 ItemUtils.kt\nmeowing/zen/utils/ItemUtils\n+ 9 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 10 ConfigDelegate.kt\nmeowing/zen/config/ConfigDelegateKt\n*L\n1#1,206:1\n113#2,2:207\n115#2:217\n113#2,2:218\n115#2:228\n67#2:243\n194#3,2:209\n196#3,3:214\n194#3,2:220\n196#3,3:225\n72#4,2:211\n72#4,2:222\n1#5:213\n1#5:224\n1#5:264\n774#6:229\n865#6,2:230\n1062#6:232\n1872#6,3:233\n503#7,7:236\n381#7,7:247\n381#7,7:256\n22#8:244\n20#8:245\n216#9:246\n217#9:254\n216#9:255\n217#9:263\n7#10:265\n*S KotlinDebug\n*F\n+ 1 ItemPickupLog.kt\nmeowing/zen/features/hud/ItemPickupLog\n*L\n51#1:207,2\n51#1:217\n59#1:218,2\n59#1:228\n101#1:243\n51#1:209,2\n51#1:214,3\n59#1:220,2\n59#1:225,3\n51#1:211,2\n59#1:222,2\n51#1:213\n59#1:224\n70#1:229\n70#1:230,2\n71#1:232\n73#1:233,3\n96#1:236,7\n136#1:247,7\n149#1:256,7\n116#1:244\n116#1:245\n128#1:246\n128#1:254\n143#1:255\n143#1:263\n27#1:265\n*E\n"})
public final class ItemPickupLog
extends Feature {
    @NotNull
    public static final ItemPickupLog INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final String name = "Item Pickup Log";
    @NotNull
    private static List<Regex> ignoreStacksRegex;
    @NotNull
    private static final Handler abbreviateNumbers$delegate;
    @NotNull
    private static final Regex npcSellingStackRegex;
    @NotNull
    private static Map<String, Integer> previousInventory;
    @NotNull
    private static Map<String, Integer> currentInventory;
    @NotNull
    private static Map<String, Pair<String, ItemStack>> items;
    @NotNull
    private static Map<String, PickupEntry> displayLines;

    private ItemPickupLog() {
        super("itempickuplog", false, null, null, 14, null);
    }

    private final boolean getAbbreviateNumbers() {
        return (Boolean)abbreviateNumbers$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Override
    @NotNull
    public ConfigUI addConfig(@NotNull ConfigUI configUI) {
        Intrinsics.checkNotNullParameter((Object)configUI, "configUI");
        return ConfigUI.addElement$default(configUI.addElement("HUD", name, new ConfigElement("itempickuplog", null, new ElementType.Switch(false), null, 8, null), true), "HUD", name, "Options", new ConfigElement("itempickuplogabbreviate", "Abbreviate Numbers", new ElementType.Switch(false), null, 8, null), false, 16, null);
    }

    @NotNull
    public final Map<String, PickupEntry> getDisplayLines() {
        return displayLines;
    }

    public final void setDisplayLines(@NotNull Map<String, PickupEntry> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        displayLines = map2;
    }

    @Override
    public void initialize() {
        boolean bl;
        Set default$iv$iv$iv;
        boolean bl2;
        EventBus this_$iv$iv;
        HUDManager.INSTANCE.register(name, "\u00a7a+5 \u00a7fPotato \u00a76$16\n\u00a7c-4 \u00a7fHay Bale \u00a76$54");
        Function1<Event, Unit> cb$iv = ItemPickupLog::initialize$lambda$0;
        int priority$iv = 0;
        boolean $i$f$register = false;
        List<EventBus.EventCall> list = ((Feature)this).getEvents();
        EventBus eventBus = EventBus.INSTANCE;
        boolean add$iv$iv = false;
        boolean $i$f$register2 = false;
        Class eventClass$iv$iv = PacketEvent.ReceivedPost.class;
        ConcurrentMap $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object == null) {
                object = default$iv$iv$iv;
            }
        }
        Set handlers$iv$iv = (Set)object;
        EventBus.PrioritizedCallback<PacketEvent.ReceivedPost> prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback<PacketEvent.ReceivedPost>(priority$iv, cb$iv);
        Intrinsics.checkNotNull(handlers$iv$iv);
        list.add(new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv));
        cb$iv = ItemPickupLog::initialize$lambda$1;
        priority$iv = 0;
        $i$f$register = false;
        List<EventBus.EventCall> list2 = ((Feature)this).getEvents();
        this_$iv$iv = EventBus.INSTANCE;
        add$iv$iv = false;
        $i$f$register2 = false;
        eventClass$iv$iv = RenderEvent.Text.class;
        $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object2 == null) {
            bl2 = false;
            default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            bl = false;
            object2 = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object2 == null) {
                object2 = default$iv$iv$iv;
            }
        }
        handlers$iv$iv = (Set)object2;
        prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback<PacketEvent.ReceivedPost>(priority$iv, cb$iv);
        Intrinsics.checkNotNull(handlers$iv$iv);
        list2.add(new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final void render() {
        boolean bl;
        PickupEntry it;
        void $this$filterTo$iv$iv;
        float x = HUDManager.INSTANCE.getX(name);
        float y = HUDManager.INSTANCE.getY(name);
        float scale = HUDManager.INSTANCE.getScale(name);
        long currentTime = System.currentTimeMillis();
        Iterable $this$filter$iv = displayLines.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            it = (PickupEntry)t;
            bl = false;
            if (!(!it.isExpired() && it.getCount() != 0)) continue;
            destination$iv$iv.add(t);
        }
        List visibleEntries = (List)destination$iv$iv;
        Iterable $this$sortedByDescending$iv = visibleEntries;
        boolean $i$f$sortedByDescending = false;
        List sortedEntries = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                PickupEntry it = (PickupEntry)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getLastUpdated());
                it = (PickupEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getLastUpdated());
            }
        });
        Iterable $this$forEachIndexed$iv = sortedEntries;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            JsonObject jsonObject;
            void entry;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (PickupEntry)item$iv;
            int index = n;
            boolean bl2 = false;
            float targetY = 10.0f * scale * (float)index;
            entry.updatePosition(targetY, currentTime);
            int alpha = entry.getAlpha();
            if (alpha <= 0) continue;
            String colorSymbol = entry.getCount() < 0 ? "\u00a7c-" : "\u00a73+";
            String count2 = INSTANCE.getAbbreviateNumbers() ? NumberUtils.INSTANCE.abbreviateNumber(Math.abs(entry.getCount())) : NumberUtils.INSTANCE.formatNumber(Math.abs(entry.getCount()));
            String display = colorSymbol + count2 + " \u00a7e" + entry.getItemName();
            JsonObject priceInfo = ItemAPI.INSTANCE.getItemInfo(entry.getItemId());
            JsonObject jsonObject2 = priceInfo;
            double price = (jsonObject2 != null && (jsonObject2 = jsonObject2.get("bazaarSell")) != null ? jsonObject2.getAsDouble() : ((jsonObject = priceInfo) != null && (jsonObject = jsonObject.get("lowestBin")) != null ? jsonObject.getAsDouble() : 0.0)) * (double)entry.getCount();
            if (!(price == 0.0)) {
                String formattedPrice = INSTANCE.getAbbreviateNumbers() ? NumberUtils.INSTANCE.abbreviateNumber(Math.abs(price)) : NumberUtils.INSTANCE.formatNumber(Math.abs(price));
                display = display + " \u00a76$" + formattedPrice;
            }
            Color color = new Color(255, 255, 255, alpha);
            Render2D.renderString$default(Render2D.INSTANCE, display, x, y + entry.getAnimatedY(), scale, color.getRGB(), null, 32, null);
        }
        Map<String, PickupEntry> $this$filterValues$iv = displayLines;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            it = (PickupEntry)entry.getValue();
            bl = false;
            if (!(!it.isExpired())) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        displayLines = TypeIntrinsics.asMutableMap(result$iv);
    }

    private final Map<String, Integer> getCurrentInventoryState() {
        ItemStack[] itemStackArray;
        Map inventoryState;
        block9: {
            block8: {
                inventoryState = new LinkedHashMap();
                Feature this_$iv = this;
                boolean $i$f$getPlayer = false;
                itemStackArray = Feature.access$getMc((Feature)this_$iv).field_71439_g;
                if (Feature.access$getMc((Feature)this_$iv).field_71439_g == null || (itemStackArray = itemStackArray.field_71071_by) == null) break block8;
                itemStackArray = itemStackArray.field_70462_a;
                if (itemStackArray.field_70462_a != null) break block9;
            }
            return null;
        }
        block0: for (ItemStack element : itemStackArray) {
            if (element == null) continue;
            String string = element.func_82833_r();
            if (string == null) {
                string = "Empty slot";
            }
            String displayName = string;
            for (Regex regex : ignoreStacksRegex) {
                if (!regex.matches(displayName)) continue;
                continue block0;
            }
            Object object = displayName;
            if (npcSellingStackRegex.matches((CharSequence)object)) {
                MatchGroupCollection matchGroupCollection = StringUtils.INSTANCE.getRegexGroups(displayName, npcSellingStackRegex);
                Intrinsics.checkNotNull(matchGroupCollection);
                MatchGroup matchGroup = matchGroupCollection.get(1);
                Intrinsics.checkNotNull(matchGroup);
                displayName = matchGroup.getValue();
            }
            object = items;
            ItemUtils itemUtils = ItemUtils.INSTANCE;
            ItemStack $this$skyblockID$iv = element;
            boolean $i$f$getSkyblockID = false;
            ItemUtils itemUtils2 = itemUtils;
            ItemStack $this$extraAttributes$iv$iv = $this$skyblockID$iv;
            boolean $i$f$getExtraAttributes = false;
            Object object2 = $this$extraAttributes$iv$iv.func_179543_a("ExtraAttributes", false);
            if (object2 == null || (object2 = object2.func_74779_i("id")) == null) {
                object2 = "";
            }
            Pair<NBTTagCompound, ItemStack> pair = new Pair<NBTTagCompound, ItemStack>((NBTTagCompound)object2, element);
            object.put((String)displayName, pair);
            int itemCount = element.field_77994_a;
            inventoryState.merge(displayName, itemCount, (arg_0, arg_1) -> ItemPickupLog.getCurrentInventoryState$lambda$6(getCurrentInventoryState.1.INSTANCE, arg_0, arg_1));
        }
        return inventoryState;
    }

    private final void compareInventories(Map<String, Integer> previous, Map<String, Integer> current) {
        String displayName;
        Map.Entry<String, Integer> entry;
        Map.Entry<String, Integer> element$iv;
        if (previous.isEmpty() || current.isEmpty()) {
            return;
        }
        Map<String, Integer> $this$forEach$iv = current;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Integer>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            PickupEntry pickupEntry;
            Pair<String, ItemStack> itemEntry;
            String itemName;
            entry = element$iv = iterator2.next();
            boolean bl = false;
            displayName = entry.getKey();
            int currentCount = ((Number)entry.getValue()).intValue();
            Integer n = previous.get(displayName);
            int previousCount = n != null ? n : 0;
            int countDifference = currentCount - previousCount;
            if (countDifference == 0) continue;
            String string = itemName = !Intrinsics.areEqual(displayName, "Empty slot") ? displayName : INSTANCE.getPreviousItemName();
            if (items.get(itemName) == null) {
                return;
            }
            String itemID = itemEntry.component1();
            Map<String, PickupEntry> $this$getOrPut$iv = displayLines;
            boolean $i$f$getOrPut = false;
            PickupEntry value$iv = $this$getOrPut$iv.get(itemName);
            if (value$iv == null) {
                boolean bl2 = false;
                PickupEntry answer$iv = new PickupEntry(itemName, itemID);
                $this$getOrPut$iv.put(itemName, answer$iv);
                pickupEntry = answer$iv;
            } else {
                pickupEntry = value$iv;
            }
            PickupEntry entry2 = pickupEntry;
            entry2.setCount(entry2.getCount() + countDifference);
            entry2.setLastUpdated(System.currentTimeMillis());
            displayLines.put(itemName, entry2);
        }
        $this$forEach$iv = previous;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            PickupEntry pickupEntry;
            Pair<String, ItemStack> itemEntry;
            String itemName;
            int currentCount;
            entry = element$iv = iterator2.next();
            boolean bl = false;
            displayName = entry.getKey();
            int previousCount = ((Number)entry.getValue()).intValue();
            Integer n = current.get(displayName);
            int n2 = currentCount = n != null ? n : 0;
            if (previousCount <= 0 || currentCount != 0) continue;
            String string = itemName = !Intrinsics.areEqual(displayName, "Empty slot") ? displayName : INSTANCE.getPreviousItemName();
            if (items.get(itemName) == null) {
                return;
            }
            String itemID = itemEntry.component1();
            Map<String, PickupEntry> $this$getOrPut$iv = displayLines;
            boolean $i$f$getOrPut = false;
            PickupEntry value$iv = $this$getOrPut$iv.get(itemName);
            if (value$iv == null) {
                boolean bl3 = false;
                PickupEntry answer$iv = new PickupEntry(itemName, itemID);
                $this$getOrPut$iv.put(itemName, answer$iv);
                pickupEntry = answer$iv;
            } else {
                pickupEntry = value$iv;
            }
            PickupEntry entry3 = pickupEntry;
            entry3.setCount(entry3.getCount() - previousCount);
            entry3.setLastUpdated(System.currentTimeMillis());
            displayLines.put(itemName, entry3);
        }
    }

    private final String getPreviousItemName() {
        Map.Entry previousItem;
        Object object;
        Object v0;
        block2: {
            Iterable iterable = previousInventory.entrySet();
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it.getKey(), "Empty slot") && ((Number)it.getValue()).intValue() == 0)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((object = (previousItem = (Map.Entry)v0)) == null || (object = (String)object.getKey()) == null) {
            object = "Unknown item";
        }
        return object;
    }

    private static final Unit initialize$lambda$0(PacketEvent.ReceivedPost event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getPacket() instanceof S2FPacketSetSlot) {
            Map<String, Integer> map2 = INSTANCE.getCurrentInventoryState();
            if (map2 == null || (map2 = MapsKt.toMutableMap(map2)) == null) {
                return Unit.INSTANCE;
            }
            currentInventory = map2;
            INSTANCE.compareInventories(previousInventory, currentInventory);
            previousInventory = currentInventory;
        }
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$1(RenderEvent.Text text) {
        Intrinsics.checkNotNullParameter(text, "<unused var>");
        if (HUDManager.INSTANCE.isEnabled(name)) {
            INSTANCE.render();
        }
        return Unit.INSTANCE;
    }

    private static final Integer getCurrentInventoryState$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ItemPickupLog.class, "abbreviateNumbers", "getAbbreviateNumbers()Z", 0))};
        $$delegatedProperties = objectArray;
        INSTANCE = new ItemPickupLog();
        objectArray = new Regex[]{new Regex("^\u00a78Quiver.*"), new Regex("^\u00a7aSkyBlock Menu \u00a77\\(Click\\)"), new Regex("^\u00a7bMagical Map")};
        ignoreStacksRegex = CollectionsKt.listOf(objectArray);
        String key$iv = "itempickuplogabbreviate";
        boolean $i$f$ConfigDelegate = false;
        abbreviateNumbers$delegate = new Handler<Boolean>(key$iv, Boolean.class);
        npcSellingStackRegex = new Regex("(.*) \u00a78x\\d+");
        previousInventory = new LinkedHashMap();
        currentInventory = new LinkedHashMap();
        items = new LinkedHashMap();
        displayLines = new LinkedHashMap();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u0013J\u0006\u0010*\u001a\u00020\u0013J\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\b\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u000e\u0010!\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0019X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lmeowing/zen/features/hud/ItemPickupLog$PickupEntry;", "", "itemName", "", "itemId", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getItemName", "()Ljava/lang/String;", "getItemId", "setItemId", "(Ljava/lang/String;)V", "count", "", "getCount", "()I", "setCount", "(I)V", "lastUpdated", "", "getLastUpdated", "()J", "setLastUpdated", "(J)V", "animatedY", "", "getAnimatedY", "()F", "setAnimatedY", "(F)V", "targetY", "getTargetY", "setTargetY", "lastTargetUpdate", "fadeInDuration", "fadeOutDuration", "totalDuration", "positionLerpSpeed", "updatePosition", "", "newTargetY", "currentTime", "timeSinceUpdate", "isExpired", "", "getAlpha", "zen"})
    public static final class PickupEntry {
        @NotNull
        private final String itemName;
        @NotNull
        private String itemId;
        private int count;
        private long lastUpdated;
        private float animatedY;
        private float targetY;
        private long lastTargetUpdate;
        private final long fadeInDuration;
        private final long fadeOutDuration;
        private final long totalDuration;
        private final float positionLerpSpeed;

        public PickupEntry(@NotNull String itemName, @NotNull String itemId) {
            Intrinsics.checkNotNullParameter(itemName, "itemName");
            Intrinsics.checkNotNullParameter(itemId, "itemId");
            this.itemName = itemName;
            this.itemId = itemId;
            this.fadeInDuration = 300L;
            this.fadeOutDuration = 300L;
            this.totalDuration = 5000L;
            this.positionLerpSpeed = 0.15f;
        }

        public /* synthetic */ PickupEntry(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            this(string, string2);
        }

        @NotNull
        public final String getItemName() {
            return this.itemName;
        }

        @NotNull
        public final String getItemId() {
            return this.itemId;
        }

        public final void setItemId(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.itemId = string;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        public final long getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(long l) {
            this.lastUpdated = l;
        }

        public final float getAnimatedY() {
            return this.animatedY;
        }

        public final void setAnimatedY(float f) {
            this.animatedY = f;
        }

        public final float getTargetY() {
            return this.targetY;
        }

        public final void setTargetY(float f) {
            this.targetY = f;
        }

        public final void updatePosition(float newTargetY, long currentTime) {
            if (!(this.targetY == newTargetY)) {
                this.targetY = newTargetY;
                this.lastTargetUpdate = currentTime;
            }
            long deltaTime = RangesKt.coerceAtMost(currentTime - this.lastTargetUpdate, 50L);
            float lerpFactor = RangesKt.coerceIn(this.positionLerpSpeed * (float)deltaTime / 16.67f, 0.0f, 1.0f);
            this.animatedY += (this.targetY - this.animatedY) * lerpFactor;
        }

        public final long timeSinceUpdate() {
            return System.currentTimeMillis() - this.lastUpdated;
        }

        public final boolean isExpired() {
            return this.timeSinceUpdate() >= this.totalDuration;
        }

        public final int getAlpha() {
            int n;
            long elapsed = this.timeSinceUpdate();
            if (elapsed < this.fadeInDuration) {
                float t = (float)elapsed / (float)this.fadeInDuration;
                n = RangesKt.coerceIn((int)(t * (float)255), 0, 255);
            } else if (elapsed > this.totalDuration - this.fadeOutDuration) {
                float t = (float)(this.totalDuration - elapsed) / (float)this.fadeOutDuration;
                n = RangesKt.coerceIn((int)(t * (float)255), 0, 255);
            } else {
                n = 255;
            }
            return n;
        }

        public PickupEntry() {
            this(null, null, 3, null);
        }
    }
}

