/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.hud;

import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import meowing.zen.hud.HUDManager;
import meowing.zen.utils.FontUtils;
import meowing.zen.utils.SimpleTimeMark;
import meowing.zen.utils.TimeUtils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0019\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u0005J\u0006\u0010/\u001a\u00020\u0005J\u0006\u00100\u001a\u00020\u0005J\u0010\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0005H\u0002J&\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u00020\rJ \u00108\u001a\u00020,2\u0006\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u00020\b2\u0006\u0010;\u001a\u00020\bH\u0002J\u0010\u0010<\u001a\u00020,2\u0006\u00109\u001a\u00020\rH\u0002J\u0018\u0010=\u001a\u00020,2\u0006\u00107\u001a\u00020\r2\u0006\u00109\u001a\u00020\rH\u0002J\u0016\u0010>\u001a\u00020\r2\u0006\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u0005J0\u0010?\u001a\u00020,2\u0006\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020\b2\u0006\u0010C\u001a\u00020\b2\u0006\u0010D\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0017\"\u0004\b$\u0010\u0019R\u001a\u0010%\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0017\"\u0004\b'\u0010\u0019R\u0010\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010*\u00a8\u0006E"}, d2={"Lmeowing/zen/hud/HUDElement;", "", "name", "", "initialX", "", "initialY", "width", "", "height", "exampleText", "scale", "enabled", "", "<init>", "(Ljava/lang/String;FFIILjava/lang/String;FZ)V", "getName", "()Ljava/lang/String;", "getWidth", "()I", "getHeight", "getExampleText", "getScale", "()F", "setScale", "(F)V", "getEnabled", "()Z", "setEnabled", "(Z)V", "fontObj", "Lnet/minecraft/client/gui/FontRenderer;", "currentX", "currentY", "targetX", "getTargetX", "setTargetX", "targetY", "getTargetY", "setTargetY", "lastUpdateTime", "Lmeowing/zen/utils/SimpleTimeMark;", "J", "setPosition", "", "x", "y", "getRenderX", "getRenderY", "easeOutCubic", "t", "render", "mouseX", "mouseY", "partialTicks", "previewMode", "renderCustomBackground", "isHovered", "customWidth", "customHeight", "renderBackground", "renderDefault", "isMouseOver", "drawHollowRect", "x1", "y1", "x2", "y2", "color", "zen"})
@SourceDebugExtension(value={"SMAP\nHUDElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HUDElement.kt\nmeowing/zen/hud/HUDElement\n+ 2 TimeUtils.kt\nmeowing/zen/utils/TimeUtils\n+ 3 TimeUtils.kt\nmeowing/zen/utils/SimpleTimeMark\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n58#2:143\n58#2:144\n58#2,6:146\n58#2,6:153\n23#3:145\n23#3:152\n1872#4,3:159\n*S KotlinDebug\n*F\n+ 1 HUDElement.kt\nmeowing/zen/hud/HUDElement\n*L\n27#1:143\n34#1:144\n38#1:146,6\n44#1:153,6\n38#1:145\n44#1:152\n116#1:159,3\n*E\n"})
public final class HUDElement {
    @NotNull
    private final String name;
    private final int width;
    private final int height;
    @NotNull
    private final String exampleText;
    private float scale;
    private boolean enabled;
    @NotNull
    private final FontRenderer fontObj;
    private float currentX;
    private float currentY;
    private float targetX;
    private float targetY;
    private long lastUpdateTime;

    public HUDElement(@NotNull String name, float initialX, float initialY, int width, int height, @NotNull String exampleText, float scale, boolean enabled) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(exampleText, "exampleText");
        this.name = name;
        this.width = width;
        this.height = height;
        this.exampleText = exampleText;
        this.scale = scale;
        this.enabled = enabled;
        this.fontObj = FontUtils.INSTANCE.getFontRenderer();
        this.currentX = initialX;
        this.currentY = initialY;
        this.targetX = initialX;
        this.targetY = initialY;
        TimeUtils this_$iv = TimeUtils.INSTANCE;
        boolean bl = false;
        this.lastUpdateTime = SimpleTimeMark.constructor-impl(System.currentTimeMillis());
    }

    public /* synthetic */ HUDElement(String string, float f, float f2, int n, int n2, String string2, float f3, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x40) != 0) {
            f3 = 1.0f;
        }
        if ((n3 & 0x80) != 0) {
            bl = true;
        }
        this(string, f, f2, n, n2, string2, f3, bl);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final String getExampleText() {
        return this.exampleText;
    }

    public final float getScale() {
        return this.scale;
    }

    public final void setScale(float f) {
        this.scale = f;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final float getTargetX() {
        return this.targetX;
    }

    public final void setTargetX(float f) {
        this.targetX = f;
    }

    public final float getTargetY() {
        return this.targetY;
    }

    public final void setTargetY(float f) {
        this.targetY = f;
    }

    public final void setPosition(float x, float y) {
        this.currentX = this.getRenderX();
        this.currentY = this.getRenderY();
        this.targetX = x;
        this.targetY = y;
        TimeUtils this_$iv = TimeUtils.INSTANCE;
        boolean bl = false;
        this.lastUpdateTime = SimpleTimeMark.constructor-impl(System.currentTimeMillis());
    }

    public final float getRenderX() {
        TimeUtils timeUtils = TimeUtils.INSTANCE;
        long arg0$iv = this.lastUpdateTime;
        boolean bl = false;
        TimeUtils this_$iv$iv = TimeUtils.INSTANCE;
        boolean bl2 = false;
        long $this$millis$iv = SimpleTimeMark.minus-iv8dxc0(SimpleTimeMark.constructor-impl(System.currentTimeMillis()), arg0$iv);
        boolean bl3 = false;
        float timeDiff = (float)Duration.getInWholeMilliseconds-impl($this$millis$iv) / 1000.0f;
        float progress = RangesKt.coerceIn(timeDiff * 8.0f, 0.0f, 1.0f);
        return this.currentX + (this.targetX - this.currentX) * this.easeOutCubic(progress);
    }

    public final float getRenderY() {
        TimeUtils timeUtils = TimeUtils.INSTANCE;
        long arg0$iv = this.lastUpdateTime;
        boolean bl = false;
        TimeUtils this_$iv$iv = TimeUtils.INSTANCE;
        boolean bl2 = false;
        long $this$millis$iv = SimpleTimeMark.minus-iv8dxc0(SimpleTimeMark.constructor-impl(System.currentTimeMillis()), arg0$iv);
        boolean bl3 = false;
        float timeDiff = (float)Duration.getInWholeMilliseconds-impl($this$millis$iv) / 1000.0f;
        float progress = RangesKt.coerceIn(timeDiff * 8.0f, 0.0f, 1.0f);
        return this.currentY + (this.targetY - this.currentY) * this.easeOutCubic(progress);
    }

    private final float easeOutCubic(float t) {
        return 1.0f + (float)Math.pow(t - 1.0f, 3);
    }

    public final void render(float mouseX, float mouseY, float partialTicks, boolean previewMode) {
        if (!this.enabled && previewMode) {
            return;
        }
        float renderX = this.getRenderX();
        float renderY = this.getRenderY();
        boolean isHovered = this.isMouseOver(mouseX, mouseY);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)renderX, (float)renderY, (float)0.0f);
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)1.0f);
        Function7<Float, Float, Integer, Integer, Float, Float, Boolean, Unit> customRenderer = HUDManager.INSTANCE.getCustomRenderer(this.name);
        if (customRenderer != null) {
            Pair<Integer, Integer> customDims;
            if (!previewMode) {
                customDims = HUDManager.INSTANCE.getCustomDimensions(this.name);
                if (customDims != null) {
                    this.renderCustomBackground(isHovered, ((Number)customDims.getFirst()).intValue(), ((Number)customDims.getSecond()).intValue());
                } else {
                    this.renderBackground(isHovered);
                }
            }
            Pair<Integer, Integer> pair = customDims = HUDManager.INSTANCE.getCustomDimensions(this.name);
            int renderWidth = pair != null ? ((Number)pair.getFirst()).intValue() : this.width;
            Pair<Integer, Integer> pair2 = customDims;
            int renderHeight = pair2 != null ? ((Number)pair2.getSecond()).intValue() : this.height;
            customRenderer.invoke(Float.valueOf(0.0f), Float.valueOf(0.0f), renderWidth, renderHeight, Float.valueOf(this.scale), Float.valueOf(partialTicks), previewMode);
        } else {
            this.renderDefault(previewMode, isHovered);
        }
        GlStateManager.func_179121_F();
    }

    private final void renderCustomBackground(boolean isHovered, int customWidth, int customHeight) {
        int alpha = !this.enabled ? 40 : (isHovered ? 140 : 90);
        int borderColor = !this.enabled ? new Color(200, 60, 60).getRGB() : (isHovered ? new Color(100, 180, 255).getRGB() : new Color(100, 100, 120).getRGB());
        Gui.func_73734_a((int)0, (int)0, (int)customWidth, (int)customHeight, (int)new Color(30, 35, 45, alpha).getRGB());
        this.drawHollowRect(0, 0, customWidth, customHeight, borderColor);
    }

    private final void renderBackground(boolean isHovered) {
        int alpha = !this.enabled ? 40 : (isHovered ? 140 : 90);
        int borderColor = !this.enabled ? new Color(200, 60, 60).getRGB() : (isHovered ? new Color(100, 180, 255).getRGB() : new Color(100, 100, 120).getRGB());
        Gui.func_73734_a((int)0, (int)0, (int)this.width, (int)this.height, (int)new Color(30, 35, 45, alpha).getRGB());
        this.drawHollowRect(0, 0, this.width, this.height, borderColor);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderDefault(boolean previewMode, boolean isHovered) {
        if (!previewMode) {
            this.renderBackground(isHovered);
        }
        String[] stringArray = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)this.exampleText, stringArray, false, 0, 6, null);
        int textAlpha = this.enabled ? 255 : 128;
        int textColor = new Color(220, 240, 255, textAlpha).getRGB();
        Iterable $this$forEachIndexed$iv = lines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            float textY = 5.0f + (float)(index * this.fontObj.field_78288_b);
            this.fontObj.func_175063_a((String)line, 5.0f, textY, textColor);
        }
    }

    public final boolean isMouseOver(float mouseX, float mouseY) {
        Pair<Integer, Integer> customDims;
        float renderX = this.getRenderX();
        float renderY = this.getRenderY();
        Pair<Integer, Integer> pair = customDims = HUDManager.INSTANCE.getCustomDimensions(this.name);
        int actualWidth = pair != null ? ((Number)pair.getFirst()).intValue() : this.width;
        Pair<Integer, Integer> pair2 = customDims;
        int actualHeight = pair2 != null ? ((Number)pair2.getSecond()).intValue() : this.height;
        float scaledWidth = (float)actualWidth * this.scale;
        float scaledHeight = (float)actualHeight * this.scale;
        return mouseX >= renderX && mouseX <= renderX + scaledWidth && mouseY >= renderY && mouseY <= renderY + scaledHeight;
    }

    private final void drawHollowRect(int x1, int y1, int x2, int y2, int color) {
        Gui.func_73734_a((int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)color);
        Gui.func_73734_a((int)x1, (int)(y2 - 1), (int)x2, (int)y2, (int)color);
        Gui.func_73734_a((int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)color);
        Gui.func_73734_a((int)(x2 - 1), (int)y1, (int)x2, (int)y2, (int)color);
    }
}

