/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.hud;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.internal.Intrinsics;
import meowing.zen.hud.HUDPosition;
import meowing.zen.hud.HUDPositions;
import meowing.zen.utils.DataUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006JV\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n26\u0010\u0018\u001a2\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\bJ\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u001aJ@\u0010\u001b\u001a4\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u0006J\u001c\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u0006J\u000e\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0006J\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0006J2\u0010!\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\b\b\u0002\u0010$\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020\u000bR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010\u0007\u001a>\u0012\u0004\u0012\u00020\u0006\u00124\u00122\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000e0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lmeowing/zen/hud/HUDManager;", "", "<init>", "()V", "elements", "", "", "customRenderers", "Lkotlin/Function7;", "", "", "", "", "customDimensions", "Lkotlin/Pair;", "hudData", "Lmeowing/zen/utils/DataUtils;", "Lmeowing/zen/hud/HUDPositions;", "register", "name", "exampleText", "registerCustom", "width", "height", "customRenderer", "getElements", "", "getCustomRenderer", "getCustomDimensions", "getX", "getY", "getScale", "isEnabled", "setPosition", "x", "y", "scale", "enabled", "zen"})
public final class HUDManager {
    @NotNull
    public static final HUDManager INSTANCE = new HUDManager();
    @NotNull
    private static final Map<String, String> elements = new LinkedHashMap();
    @NotNull
    private static final Map<String, Function7<Float, Float, Integer, Integer, Float, Float, Boolean, Unit>> customRenderers = new LinkedHashMap();
    @NotNull
    private static final Map<String, Pair<Integer, Integer>> customDimensions = new LinkedHashMap();
    @NotNull
    private static final DataUtils<HUDPositions> hudData = new DataUtils<HUDPositions>("hud_positions", new HUDPositions(null, 1, null));

    private HUDManager() {
    }

    public final void register(@NotNull String name, @NotNull String exampleText) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(exampleText, "exampleText");
        elements.put(name, exampleText);
    }

    public final void registerCustom(@NotNull String name, int width, int height, @NotNull Function7<? super Float, ? super Float, ? super Integer, ? super Integer, ? super Float, ? super Float, ? super Boolean, Unit> customRenderer) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(customRenderer, "customRenderer");
        elements.put(name, "");
        customRenderers.put(name, customRenderer);
        customDimensions.put(name, new Pair<Integer, Integer>(width, height));
    }

    @NotNull
    public final Map<String, String> getElements() {
        return elements;
    }

    @Nullable
    public final Function7<Float, Float, Integer, Integer, Float, Float, Boolean, Unit> getCustomRenderer(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return customRenderers.get(name);
    }

    @Nullable
    public final Pair<Integer, Integer> getCustomDimensions(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return customDimensions.get(name);
    }

    public final float getX(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        HUDPosition hUDPosition = hudData.getData().getPositions().get(name);
        return hUDPosition != null ? hUDPosition.getX() : 50.0f;
    }

    public final float getY(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        HUDPosition hUDPosition = hudData.getData().getPositions().get(name);
        return hUDPosition != null ? hUDPosition.getY() : 50.0f;
    }

    public final float getScale(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        HUDPosition hUDPosition = hudData.getData().getPositions().get(name);
        return hUDPosition != null ? hUDPosition.getScale() : 1.0f;
    }

    public final boolean isEnabled(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        HUDPosition hUDPosition = hudData.getData().getPositions().get(name);
        return hUDPosition != null ? hUDPosition.getEnabled() : true;
    }

    public final void setPosition(@NotNull String name, float x, float y, float scale, boolean enabled) {
        Intrinsics.checkNotNullParameter(name, "name");
        hudData.getData().getPositions().put(name, new HUDPosition(x, y, scale, enabled));
        hudData.save();
    }

    public static /* synthetic */ void setPosition$default(HUDManager hUDManager, String string, float f, float f2, float f3, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            f3 = 1.0f;
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        hUDManager.setPosition(string, f, f2, f3, bl);
    }
}

