/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.utils;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import meowing.zen.Zen;
import meowing.zen.events.EventBus;
import meowing.zen.features.Debug;
import meowing.zen.utils.SimpleTimeMark;
import meowing.zen.utils.TickUtils;
import meowing.zen.utils.TimeUtils;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.ClientCommandHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\rJ@\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\rH\u0007J$\u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rR\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lmeowing/zen/utils/ChatUtils;", "", "<init>", "()V", "nextAvailableTime", "Lmeowing/zen/utils/SimpleTimeMark;", "J", "schedule", "", "action", "Lkotlin/Function0;", "chat", "message", "", "clientCommand", "command", "addMessage", "hover", "clickAction", "Lnet/minecraft/event/ClickEvent$Action;", "clickValue", "siblingText", "createChatStyle", "Lnet/minecraft/util/ChatStyle;", "thresholds", "", "Lmeowing/zen/utils/ChatUtils$Threshold;", "formatNumber", "number", "Threshold", "zen"})
@SourceDebugExtension(value={"SMAP\nChatUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatUtils.kt\nmeowing/zen/utils/ChatUtils\n+ 2 TimeUtils.kt\nmeowing/zen/utils/TimeUtils\n+ 3 TimeUtils.kt\nmeowing/zen/utils/SimpleTimeMark\n+ 4 Debug.kt\nmeowing/zen/features/Debug\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n58#2:100\n58#2,6:103\n59#2:113\n24#3:101\n23#3:102\n146#4:109\n146#4:111\n146#4:112\n1#5:110\n*S KotlinDebug\n*F\n+ 1 ChatUtils.kt\nmeowing/zen/utils/ChatUtils\n*L\n20#1:100\n22#1:103,6\n17#1:113\n22#1:101\n22#1:102\n44#1:109\n37#1:111\n54#1:112\n*E\n"})
public final class ChatUtils {
    @NotNull
    public static final ChatUtils INSTANCE = new ChatUtils();
    private static long nextAvailableTime;
    @NotNull
    private static final List<Threshold> thresholds;

    private ChatUtils() {
    }

    /*
     * WARNING - void declaration
     */
    private final void schedule(Function0<Unit> action) {
        void $this$millis$iv;
        TimeUtils this_$iv = TimeUtils.INSTANCE;
        boolean bl = false;
        long now = SimpleTimeMark.constructor-impl(System.currentTimeMillis());
        nextAvailableTime = ComparisonsKt.maxOf(SimpleTimeMark.box-impl(now), SimpleTimeMark.box-impl(nextAvailableTime)).unbox-impl();
        TimeUtils timeUtils = TimeUtils.INSTANCE;
        long arg0$iv = nextAvailableTime;
        boolean bl2 = false;
        boolean bl3 = false;
        TimeUtils this_$iv$iv$iv = TimeUtils.INSTANCE;
        $i$f$getNow-k-uo7DU = false;
        arg0$iv = Duration.unaryMinus-UwyO8pc(SimpleTimeMark.minus-iv8dxc0(SimpleTimeMark.constructor-impl(System.currentTimeMillis()), arg0$iv));
        boolean bl4 = false;
        double delay2 = (double)Duration.getInWholeMilliseconds-impl((long)$this$millis$iv) / 50.0;
        TickUtils.INSTANCE.schedule((long)Math.ceil(delay2), () -> ChatUtils.schedule$lambda$0(action));
        nextAvailableTime = SimpleTimeMark.plus-YC60f-o(nextAvailableTime, DurationKt.toDuration(100, DurationUnit.MILLISECONDS));
    }

    public final void chat(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        EntityPlayerSP entityPlayerSP = Zen.Companion.getMc().field_71439_g;
        if (entityPlayerSP == null) {
            return;
        }
        EntityPlayerSP player = entityPlayerSP;
        this.schedule(() -> ChatUtils.chat$lambda$1(message, player));
    }

    public final void clientCommand(@NotNull String command2) {
        Intrinsics.checkNotNullParameter(command2, "command");
        String cmd = StringsKt.startsWith$default(command2, "/", false, 2, null) ? command2 : '/' + command2;
        ClientCommandHandler.instance.func_71556_a((ICommandSender)Zen.Companion.getMc().field_71439_g, cmd);
        Debug this_$iv = Debug.INSTANCE;
        boolean $i$f$getDebugmode = false;
        if (this_$iv.getData().getData().getDebugmode()) {
            ChatUtils.addMessage$default(this, "\u00a77[\u00a7bZen\u00a77] \u00a7fSent client-side command \"" + cmd + '\"', null, null, null, null, 30, null);
        }
    }

    public final void command(@NotNull String command2) {
        Intrinsics.checkNotNullParameter(command2, "command");
        EntityPlayerSP entityPlayerSP = Zen.Companion.getMc().field_71439_g;
        if (entityPlayerSP == null) {
            return;
        }
        EntityPlayerSP player = entityPlayerSP;
        String cmd = StringsKt.startsWith$default(command2, "/", false, 2, null) ? command2 : '/' + command2;
        this.schedule(() -> ChatUtils.command$lambda$2(cmd, player));
    }

    @JvmOverloads
    public final void addMessage(@NotNull String message, @Nullable String hover, @Nullable ClickEvent.Action clickAction, @Nullable String clickValue, @Nullable String siblingText) {
        ChatComponentText component2;
        EntityPlayerSP player;
        block5: {
            Object object;
            block4: {
                ChatComponentText chatComponentText;
                Intrinsics.checkNotNullParameter(message, "message");
                EntityPlayerSP entityPlayerSP = Zen.Companion.getMc().field_71439_g;
                if (entityPlayerSP == null) {
                    return;
                }
                player = entityPlayerSP;
                component2 = new ChatComponentText(message);
                object = siblingText;
                if (object == null) break block4;
                String text = object;
                boolean bl = false;
                ChatComponentText $this$addMessage_u24lambda_u244_u24lambda_u243 = chatComponentText = new ChatComponentText(text);
                boolean bl2 = false;
                $this$addMessage_u24lambda_u244_u24lambda_u243.func_150255_a(INSTANCE.createChatStyle(hover, clickAction, clickValue));
                ChatComponentText sibling = chatComponentText;
                IChatComponent iChatComponent = component2.func_150257_a((IChatComponent)sibling);
                object = iChatComponent;
                if (iChatComponent != null) break block5;
            }
            ChatUtils $this$addMessage_u24lambda_u245 = this;
            boolean bl = false;
            component2.func_150255_a($this$addMessage_u24lambda_u245.createChatStyle(hover, clickAction, clickValue));
            object = Unit.INSTANCE;
        }
        player.func_145747_a((IChatComponent)component2);
    }

    public static /* synthetic */ void addMessage$default(ChatUtils chatUtils, String string, String string2, ClickEvent.Action action, String string3, String string4, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            action = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        chatUtils.addMessage(string, string2, action, string3, string4);
    }

    @NotNull
    public final ChatStyle createChatStyle(@Nullable String hover, @Nullable ClickEvent.Action clickAction, @Nullable String clickValue) {
        ChatStyle chatStyle;
        ChatStyle $this$createChatStyle_u24lambda_u247 = chatStyle = new ChatStyle();
        boolean bl = false;
        String string = hover;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$createChatStyle_u24lambda_u247.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(it)));
        }
        if (clickAction != null && clickValue != null) {
            $this$createChatStyle_u24lambda_u247.func_150241_a(new ClickEvent(clickAction, clickValue));
        }
        return chatStyle;
    }

    @NotNull
    public final String formatNumber(@NotNull String number) {
        String string;
        Intrinsics.checkNotNullParameter(number, "number");
        try {
            String string2;
            Object v0;
            double num;
            block5: {
                num = Double.parseDouble(StringsKt.replace$default(number, ",", "", false, 4, null));
                Iterable iterable = thresholds;
                for (Object t : iterable) {
                    Threshold it = (Threshold)t;
                    boolean bl = false;
                    if (!(num >= it.getValue())) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            Threshold threshold = v0;
            if (threshold != null) {
                double formatted = num / threshold.getValue();
                String string3 = "%." + threshold.getPrecision() + 'f';
                Object[] objectArray = new Object[]{formatted};
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
                double rounded = Double.parseDouble(string4);
                string2 = rounded + threshold.getSymbol();
            } else {
                string2 = num == (double)((long)num) ? String.valueOf((long)num) : String.valueOf(num);
            }
            string = string2;
        }
        catch (NumberFormatException numberFormatException) {
            string = number;
        }
        return string;
    }

    @JvmOverloads
    public final void addMessage(@NotNull String message, @Nullable String hover, @Nullable ClickEvent.Action clickAction, @Nullable String clickValue) {
        Intrinsics.checkNotNullParameter(message, "message");
        ChatUtils.addMessage$default(this, message, hover, clickAction, clickValue, null, 16, null);
    }

    @JvmOverloads
    public final void addMessage(@NotNull String message, @Nullable String hover, @Nullable ClickEvent.Action clickAction) {
        Intrinsics.checkNotNullParameter(message, "message");
        ChatUtils.addMessage$default(this, message, hover, clickAction, null, null, 24, null);
    }

    @JvmOverloads
    public final void addMessage(@NotNull String message, @Nullable String hover) {
        Intrinsics.checkNotNullParameter(message, "message");
        ChatUtils.addMessage$default(this, message, hover, null, null, null, 28, null);
    }

    @JvmOverloads
    public final void addMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        ChatUtils.addMessage$default(this, message, null, null, null, null, 30, null);
    }

    private static final Unit schedule$lambda$0(Function0 $action) {
        Intrinsics.checkNotNullParameter($action, "$action");
        $action.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit chat$lambda$1(String $message, EntityPlayerSP $player) {
        Intrinsics.checkNotNullParameter($message, "$message");
        Intrinsics.checkNotNullParameter($player, "$player");
        EventBus.INSTANCE.getMessages().add($message);
        $player.func_71165_d($message);
        Debug this_$iv = Debug.INSTANCE;
        boolean $i$f$getDebugmode = false;
        if (this_$iv.getData().getData().getDebugmode()) {
            ChatUtils.addMessage$default(INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fSent message \"" + $message + '\"', null, null, null, null, 30, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit command$lambda$2(String $cmd, EntityPlayerSP $player) {
        Intrinsics.checkNotNullParameter($cmd, "$cmd");
        Intrinsics.checkNotNullParameter($player, "$player");
        EventBus.INSTANCE.getMessages().add($cmd);
        $player.func_71165_d($cmd);
        Debug this_$iv = Debug.INSTANCE;
        boolean $i$f$getDebugmode = false;
        if (this_$iv.getData().getData().getDebugmode()) {
            ChatUtils.addMessage$default(INSTANCE, "\u00a77[\u00a7bZen\u00a77] \u00a7fSent command \"" + $cmd + '\"', null, null, null, null, 30, null);
        }
        return Unit.INSTANCE;
    }

    static {
        TimeUtils this_$iv = TimeUtils.INSTANCE;
        boolean bl = false;
        nextAvailableTime = SimpleTimeMark.constructor-impl(0L);
        Threshold[] thresholdArray = new Threshold[]{new Threshold(1.0E9, "b", 1), new Threshold(1000000.0, "m", 1), new Threshold(1000.0, "k", 1)};
        thresholds = CollectionsKt.listOf(thresholdArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lmeowing/zen/utils/ChatUtils$Threshold;", "", "value", "", "symbol", "", "precision", "", "<init>", "(DLjava/lang/String;I)V", "getValue", "()D", "getSymbol", "()Ljava/lang/String;", "getPrecision", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "zen"})
    private static final class Threshold {
        private final double value;
        @NotNull
        private final String symbol;
        private final int precision;

        public Threshold(double value, @NotNull String symbol, int precision) {
            Intrinsics.checkNotNullParameter(symbol, "symbol");
            this.value = value;
            this.symbol = symbol;
            this.precision = precision;
        }

        public final double getValue() {
            return this.value;
        }

        @NotNull
        public final String getSymbol() {
            return this.symbol;
        }

        public final int getPrecision() {
            return this.precision;
        }

        public final double component1() {
            return this.value;
        }

        @NotNull
        public final String component2() {
            return this.symbol;
        }

        public final int component3() {
            return this.precision;
        }

        @NotNull
        public final Threshold copy(double value, @NotNull String symbol, int precision) {
            Intrinsics.checkNotNullParameter(symbol, "symbol");
            return new Threshold(value, symbol, precision);
        }

        public static /* synthetic */ Threshold copy$default(Threshold threshold, double d, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                d = threshold.value;
            }
            if ((n2 & 2) != 0) {
                string = threshold.symbol;
            }
            if ((n2 & 4) != 0) {
                n = threshold.precision;
            }
            return threshold.copy(d, string, n);
        }

        @NotNull
        public String toString() {
            return "Threshold(value=" + this.value + ", symbol=" + this.symbol + ", precision=" + this.precision + ')';
        }

        public int hashCode() {
            int result = Double.hashCode(this.value);
            result = result * 31 + this.symbol.hashCode();
            result = result * 31 + Integer.hashCode(this.precision);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Threshold)) {
                return false;
            }
            Threshold threshold = (Threshold)other;
            if (Double.compare(this.value, threshold.value) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual(this.symbol, threshold.symbol)) {
                return false;
            }
            return this.precision == threshold.precision;
        }
    }
}

