/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import meowing.zen.events.EventBus;
import meowing.zen.events.GameEvent;
import meowing.zen.utils.LoopUtils;
import meowing.zen.utils.SimpleTimeMark;
import meowing.zen.utils.TimeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 5*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u00015B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\b\u0010\nJ\u000f\u0010\u0016\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0017\u0010\u0018\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0019\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010!\u001a\u00020\u001cJ\u0010\u0010\"\u001a\u00020\u001c2\b\b\u0002\u0010#\u001a\u00020$J\u0013\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00028\u0000\u00a2\u0006\u0002\u0010'J\u000b\u0010(\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010)\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0017J\u001f\u0010*\u001a\u00020\u001c2\u0017\u0010+\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0,\u00a2\u0006\u0002\b-J\u001f\u0010.\u001a\u00020\u001c2\u0017\u0010+\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0,\u00a2\u0006\u0002\b-J\u0006\u0010/\u001a\u00020\u001cJ\u0006\u00100\u001a\u00020\u001cJ\u0006\u00101\u001a\u00020\u001cJ\u000b\u00102\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u0006\u00103\u001a\u00020 J\u0006\u00104\u001a\u00020 R\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0012\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u00066"}, d2={"Lmeowing/zen/utils/DataUtils;", "T", "", "fileName", "", "defaultObject", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "<init>", "(Ljava/lang/String;Ljava/lang/Object;Lcom/google/gson/reflect/TypeToken;)V", "(Ljava/lang/String;Ljava/lang/Object;)V", "Ljava/lang/Object;", "dataFile", "Ljava/io/File;", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "Lcom/google/gson/Gson;", "data", "lastSavedTime", "Lmeowing/zen/utils/SimpleTimeMark;", "J", "loadData", "()Ljava/lang/Object;", "fromJson", "file", "(Ljava/io/File;)Ljava/lang/Object;", "toJson", "", "obj", "(Ljava/io/File;Ljava/lang/Object;)V", "hasChanges", "", "save", "autosave", "intervalMinutes", "", "setData", "newData", "(Ljava/lang/Object;)V", "getData", "invoke", "update", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "updateAndSave", "reset", "resetAndSave", "reload", "copy", "exists", "delete", "Companion", "zen"})
@SourceDebugExtension(value={"SMAP\nDataUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataUtils.kt\nmeowing/zen/utils/DataUtils\n+ 2 TimeUtils.kt\nmeowing/zen/utils/TimeUtils\n+ 3 EventBus.kt\nmeowing/zen/events/EventBus\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n58#2:184\n206#3:185\n194#3,2:186\n196#3,3:191\n72#4,2:188\n1#5:190\n1#5:194\n*S KotlinDebug\n*F\n+ 1 DataUtils.kt\nmeowing/zen/utils/DataUtils\n*L\n65#1:184\n92#1:185\n92#1:186,2\n92#1:191,3\n92#1:188,2\n92#1:190\n*E\n"})
public final class DataUtils<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final T defaultObject;
    @Nullable
    private final TypeToken<T> typeToken;
    @NotNull
    private final File dataFile;
    private final Gson gson;
    @NotNull
    private T data;
    private long lastSavedTime;
    @NotNull
    private static final ConcurrentHashMap<DataUtils<?>, Long> autosaveIntervals = new ConcurrentHashMap();
    private static boolean isLoopStarted;

    /*
     * WARNING - void declaration
     */
    public DataUtils(@NotNull String fileName, @NotNull T defaultObject, @Nullable TypeToken<T> typeToken) {
        void priority$iv$iv;
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(defaultObject, "defaultObject");
        this.defaultObject = defaultObject;
        this.typeToken = typeToken;
        this.dataFile = new File("config/Zen/" + fileName + ".json");
        this.gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter((Type)((Object)Number.class), (Object)new TypeAdapter<Number>(){

            public void write(JsonWriter out, Number value) {
                Intrinsics.checkNotNullParameter(out, "out");
                Number number = value;
                JsonWriter jsonWriter = number == null ? out.nullValue() : out.value(number);
            }

            public Number read(JsonReader reader) {
                Intrinsics.checkNotNullParameter(reader, "reader");
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return null;
                }
                double value = reader.nextDouble();
                return value % 1.0 == 0.0 && value >= -2.147483648E9 && value <= 2.147483647E9 ? (Number)((Number)((int)value)) : (Number)((Number)value);
            }
        }).registerTypeAdapter((Type)((Object)Color.class), (Object)new JsonSerializer<Color>(){

            public JsonElement serialize(Color src, Type typeOfSrc, JsonSerializationContext context) {
                Intrinsics.checkNotNullParameter(src, "src");
                Intrinsics.checkNotNullParameter(typeOfSrc, "typeOfSrc");
                Intrinsics.checkNotNullParameter(context, "context");
                JsonObject obj = new JsonObject();
                obj.addProperty("r", (Number)src.getRed());
                obj.addProperty("g", (Number)src.getGreen());
                obj.addProperty("b", (Number)src.getBlue());
                obj.addProperty("a", (Number)src.getAlpha());
                return (JsonElement)obj;
            }

            public Color deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
                Intrinsics.checkNotNullParameter(json, "json");
                Intrinsics.checkNotNullParameter(typeOfT, "typeOfT");
                Intrinsics.checkNotNullParameter(context, "context");
                JsonObject obj = json.getAsJsonObject();
                int r = obj.get("r").getAsInt();
                int g = obj.get("g").getAsInt();
                int b = obj.get("b").getAsInt();
                int a = obj.get("a").getAsInt();
                return new Color(r, g, b, a);
            }
        }).create();
        T t = this.loadData();
        if (t == null) {
            t = this.defaultObject;
        }
        this.data = t;
        Object this_$iv = TimeUtils.INSTANCE;
        boolean bl = false;
        this.lastSavedTime = SimpleTimeMark.constructor-impl(System.currentTimeMillis());
        this.dataFile.getParentFile().mkdirs();
        this.autosave(5L);
        DataUtils.Companion.startSaveLoop();
        this_$iv = EventBus.INSTANCE;
        Function1<GameEvent.Unload, Unit> callback$iv = arg_0 -> DataUtils._init_$lambda$0(this, arg_0);
        boolean $i$f$register = false;
        Object object = this_$iv;
        boolean bl2 = false;
        boolean add$iv$iv = true;
        boolean $i$f$register2 = false;
        Class<GameEvent.Unload> eventClass$iv$iv = GameEvent.Unload.class;
        ConcurrentMap $this$getOrPut$iv$iv$iv = this_$iv$iv.getListeners();
        boolean $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv$iv$iv.get(eventClass$iv$iv);
        if (object2 == null) {
            boolean bl3 = false;
            Set default$iv$iv$iv = ConcurrentHashMap.newKeySet();
            boolean bl4 = false;
            object2 = $this$getOrPut$iv$iv$iv.putIfAbsent(eventClass$iv$iv, default$iv$iv$iv);
            if (object2 == null) {
                object2 = default$iv$iv$iv;
            }
        }
        Set handlers$iv$iv = (Set)object2;
        EventBus.PrioritizedCallback<GameEvent.Unload> prioritizedCallback$iv$iv = new EventBus.PrioritizedCallback<GameEvent.Unload>((int)priority$iv$iv, callback$iv);
        handlers$iv$iv.add(prioritizedCallback$iv$iv);
        Intrinsics.checkNotNull(handlers$iv$iv);
        EventBus.EventCall cfr_ignored_0 = new EventBus.EventCallImpl(prioritizedCallback$iv$iv, handlers$iv$iv);
    }

    public /* synthetic */ DataUtils(String string, Object object, TypeToken typeToken, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            typeToken = null;
        }
        this(string, object, typeToken);
    }

    public DataUtils(@NotNull String fileName, @NotNull T defaultObject) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(defaultObject, "defaultObject");
        this(fileName, defaultObject, null);
    }

    private final T loadData() {
        Object var1_1;
        try {
            var1_1 = this.dataFile.exists() ? this.fromJson(this.dataFile) : null;
        }
        catch (Exception exception) {
            var1_1 = null;
        }
        return var1_1;
    }

    private final T fromJson(File file) {
        Object object;
        try {
            Object object2 = this.typeToken;
            if (object2 == null || (object2 = object2.getType()) == null) {
                object2 = this.defaultObject.getClass();
            }
            Object type2 = object2;
            object = this.gson.fromJson(FilesKt.readText$default(file, null, 1, null), type2);
        }
        catch (Exception exception) {
            object = null;
        }
        return (T)object;
    }

    private final void toJson(File file, T obj) {
        String string = this.gson.toJson(obj);
        Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
        FilesKt.writeText$default(file, string, null, 2, null);
    }

    private final boolean hasChanges() {
        boolean bl;
        try {
            Object currentFileData = this.dataFile.exists() ? this.fromJson(this.dataFile) : null;
            bl = !Intrinsics.areEqual(currentFileData, this.data);
        }
        catch (Exception exception) {
            bl = true;
        }
        return bl;
    }

    public final synchronized void save() {
        try {
            this.toJson(this.dataFile, this.data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void autosave(long intervalMinutes) {
        ((Map)autosaveIntervals).put(this, intervalMinutes * (long)60000);
    }

    public static /* synthetic */ void autosave$default(DataUtils dataUtils, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 5L;
        }
        dataUtils.autosave(l);
    }

    public final void setData(@NotNull T newData) {
        Intrinsics.checkNotNullParameter(newData, "newData");
        this.data = newData;
    }

    @NotNull
    public final T getData() {
        return this.data;
    }

    @NotNull
    public final T invoke() {
        return this.data;
    }

    public final void update(@NotNull Function1<? super T, Unit> block) {
        Intrinsics.checkNotNullParameter(block, "block");
        block.invoke(this.data);
    }

    public final void updateAndSave(@NotNull Function1<? super T, Unit> block) {
        Intrinsics.checkNotNullParameter(block, "block");
        this.update(block);
        this.save();
    }

    public final void reset() {
        this.data = this.defaultObject;
    }

    public final void resetAndSave() {
        this.reset();
        this.save();
    }

    public final void reload() {
        block0: {
            T t = this.loadData();
            if (t == null) break block0;
            T it = t;
            boolean bl = false;
            this.data = it;
        }
    }

    @NotNull
    public final T copy() {
        Object object = this.gson.fromJson(this.gson.toJson(this.data), this.data.getClass());
        Intrinsics.checkNotNullExpressionValue(object, "fromJson(...)");
        return (T)object;
    }

    public final boolean exists() {
        return this.dataFile.exists();
    }

    public final boolean delete() {
        boolean bl;
        try {
            bl = this.dataFile.delete();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private static final Unit _init_$lambda$0(DataUtils this$0, GameEvent.Unload it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.save();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lmeowing/zen/utils/DataUtils$Companion;", "", "<init>", "()V", "autosaveIntervals", "Ljava/util/concurrent/ConcurrentHashMap;", "Lmeowing/zen/utils/DataUtils;", "", "isLoopStarted", "", "startSaveLoop", "", "zen"})
    @SourceDebugExtension(value={"SMAP\nDataUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataUtils.kt\nmeowing/zen/utils/DataUtils$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 TimeUtils.kt\nmeowing/zen/utils/SimpleTimeMark\n+ 4 TimeUtils.kt\nmeowing/zen/utils/TimeUtils\n*L\n1#1,183:1\n216#2:184\n217#2:193\n23#3:185\n58#4,6:186\n58#4:192\n*S KotlinDebug\n*F\n+ 1 DataUtils.kt\nmeowing/zen/utils/DataUtils$Companion\n*L\n77#1:184\n77#1:193\n78#1:185\n78#1:186,6\n81#1:192\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final synchronized void startSaveLoop() {
            if (isLoopStarted) {
                return;
            }
            isLoopStarted = true;
            LoopUtils.loop$default(LoopUtils.INSTANCE, 10000L, null, Companion::startSaveLoop$lambda$1, 2, null);
        }

        private static final Unit startSaveLoop$lambda$1() {
            Map $this$forEach$iv = autosaveIntervals;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl = false;
                DataUtils dataUtils = (DataUtils)entry.getKey();
                long interval = ((Number)entry.getValue()).longValue();
                TimeUtils timeUtils = TimeUtils.INSTANCE;
                long arg0$iv = dataUtils.lastSavedTime;
                boolean bl2 = false;
                TimeUtils this_$iv$iv = TimeUtils.INSTANCE;
                boolean bl3 = false;
                long $this$millis$iv = SimpleTimeMark.minus-iv8dxc0(SimpleTimeMark.constructor-impl(System.currentTimeMillis()), arg0$iv);
                boolean bl4 = false;
                if (Duration.getInWholeMilliseconds-impl($this$millis$iv) < interval || !dataUtils.hasChanges()) continue;
                dataUtils.save();
                TimeUtils this_$iv = TimeUtils.INSTANCE;
                $i$f$getNow-k-uo7DU = false;
                dataUtils.lastSavedTime = SimpleTimeMark.constructor-impl(System.currentTimeMillis());
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

