/*
 * Decompiled with CFR 0.152.
 */
package meowing.zen.utils;

import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\n\u001a\u00020\b*\u00020\u000bJ\n\u0010\f\u001a\u00020\b*\u00020\u000bJ\u0014\u0010\r\u001a\u00020\b*\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\n\u0010\u0010\u001a\u00020\b*\u00020\u000bR\"\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0011"}, d2={"Lmeowing/zen/utils/NumberUtils;", "", "<init>", "()V", "suffixes", "", "Lkotlin/Pair;", "", "", "[Lkotlin/Pair;", "abbreviateNumber", "", "formatNumber", "toFormattedDuration", "short", "", "format", "zen"})
@SourceDebugExtension(value={"SMAP\nNumberUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberUtils.kt\nmeowing/zen/utils/NumberUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class NumberUtils {
    @NotNull
    public static final NumberUtils INSTANCE = new NumberUtils();
    @NotNull
    private static final Pair<Long, String>[] suffixes;

    private NumberUtils() {
    }

    @NotNull
    public final String abbreviateNumber(@NotNull Number $this$abbreviateNumber) {
        String string;
        Pair<Double, String> pair;
        Intrinsics.checkNotNullParameter($this$abbreviateNumber, "<this>");
        double num = Math.abs($this$abbreviateNumber.doubleValue());
        String sign = $this$abbreviateNumber.doubleValue() < 0.0 ? "-" : "";
        if (num >= 1.0E12) {
            pair = TuplesKt.to(1.0E12, "T");
        } else if (num >= 1.0E9) {
            pair = TuplesKt.to(1.0E9, "B");
        } else if (num >= 1000000.0) {
            pair = TuplesKt.to(1000000.0, "M");
        } else if (num >= 1000.0) {
            pair = TuplesKt.to(1000.0, "k");
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(sign);
            String string2 = "%.0f";
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{num};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            return stringBuilder.append(string3).toString();
        }
        Pair<Double, String> pair2 = pair;
        double divisor = ((Number)pair2.component1()).doubleValue();
        String suffix = pair2.component2();
        double value = num / divisor;
        if (value % 1.0 == 0.0) {
            string = String.valueOf((int)value);
        } else {
            String string4 = "%.1f";
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{value};
            String string5 = String.format(locale, string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string5, "format(...)");
            String decimal = string5;
            string = StringsKt.endsWith$default(decimal, ".0", false, 2, null) ? StringsKt.dropLast(decimal, 2) : decimal;
        }
        String formatted = string;
        return sign + formatted + suffix;
    }

    @NotNull
    public final String formatNumber(@NotNull Number $this$formatNumber) {
        Intrinsics.checkNotNullParameter($this$formatNumber, "<this>");
        String string = "%,.0f";
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{$this$formatNumber.doubleValue()};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @NotNull
    public final String toFormattedDuration(long $this$toFormattedDuration, boolean bl) {
        StringBuilder stringBuilder;
        long seconds = $this$toFormattedDuration / (long)1000;
        long days = seconds / (long)86400;
        long hours = seconds % (long)86400 / (long)3600;
        long minutes = seconds % (long)3600 / (long)60;
        long remainingSeconds = seconds % (long)60;
        if (bl) {
            return days > 0L ? "" + days + 'd' : (hours > 0L ? "" + hours + 'h' : (minutes > 0L ? "" + minutes + 'm' : "" + remainingSeconds + 's'));
        }
        StringBuilder $this$toFormattedDuration_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl2 = false;
        if (days > 0L) {
            $this$toFormattedDuration_u24lambda_u240.append(days + "d ");
        }
        if (hours > 0L) {
            $this$toFormattedDuration_u24lambda_u240.append(hours + "h ");
        }
        if (minutes > 0L) {
            $this$toFormattedDuration_u24lambda_u240.append(minutes + "m ");
        }
        if (remainingSeconds > 0L) {
            $this$toFormattedDuration_u24lambda_u240.append("" + remainingSeconds + 's');
        }
        return ((Object)StringsKt.trimEnd((CharSequence)stringBuilder.toString())).toString();
    }

    public static /* synthetic */ String toFormattedDuration$default(NumberUtils numberUtils, long l, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return numberUtils.toFormattedDuration(l, bl);
    }

    @NotNull
    public final String format(@NotNull Number $this$format) {
        Pair<Long, String> pair;
        long longValue;
        block6: {
            Intrinsics.checkNotNullParameter($this$format, "<this>");
            longValue = $this$format.longValue();
            if (longValue == Long.MIN_VALUE) {
                return this.format(-9223372036854775807L);
            }
            if (longValue < 0L) {
                return '-' + this.format(-longValue);
            }
            if (longValue < 1000L) {
                return String.valueOf(longValue);
            }
            Pair<Long, String>[] pairArray = suffixes;
            int n = pairArray.length + -1;
            if (0 <= n) {
                do {
                    Pair<Long, String> pair2;
                    int n2 = n--;
                    Pair<Long, String> it = pair2 = pairArray[n2];
                    boolean bl = false;
                    if (!(longValue >= ((Number)it.getFirst()).longValue())) continue;
                    pair = pair2;
                    break block6;
                } while (0 <= n);
            }
            pair = null;
        }
        if (pair == null) {
            return String.valueOf(longValue);
        }
        Pair<Long, String> pair3 = pair;
        long threshold = ((Number)pair3.component1()).longValue();
        String suffix = (String)pair3.component2();
        long scaled = longValue * (long)10 / threshold;
        return scaled < 100L && scaled % (long)10 != 0L ? (double)scaled / 10.0 + suffix : scaled / (long)10 + suffix;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(1000L, "k"), TuplesKt.to(1000000L, "m"), TuplesKt.to(1000000000L, "b"), TuplesKt.to(1000000000000L, "t"), TuplesKt.to(1000000000000000L, "p"), TuplesKt.to(1000000000000000000L, "e")};
        suffixes = pairArray;
    }
}

