/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.config.ui.elements;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.vexel.animations.EasingType;
import xyz.meowing.vexel.animations.PresetsKt;
import xyz.meowing.vexel.components.base.Pos;
import xyz.meowing.vexel.components.base.Size;
import xyz.meowing.vexel.components.base.VexelElement;
import xyz.meowing.vexel.components.core.Container;
import xyz.meowing.vexel.components.core.Rectangle;
import xyz.meowing.vexel.components.core.Text;
import xyz.meowing.vexel.utils.render.NVGRenderer;
import xyz.meowing.zen.config.ui.elements.utils.ExtensionsKt;
import xyz.meowing.zen.config.ui.panels.SectionButton;
import xyz.meowing.zen.ui.Theme;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 /2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001/B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\fJ\u000f\u0010\u000e\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000e\u0010\fJ\u000f\u0010\u000f\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\fJ\u001f\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0014\u0010\fJ\u000f\u0010\u0015\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0015\u0010\fJ\u001f\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001bR\u0016\u0010\u001d\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001eR$\u0010\u0007\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00068\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0007\u0010!\u001a\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010&R\u0014\u0010+\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010)R\u0014\u0010-\u001a\u00020,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.\u00a8\u00060"}, d2={"Lxyz/meowing/zen/config/ui/elements/DropdownElement;", "Lxyz/meowing/vexel/components/base/VexelElement;", "", "name", "", "options", "", "selectedIndex", "<init>", "(Ljava/lang/String;Ljava/util/List;I)V", "", "createOptions", "()V", "updateButtonSize", "expand", "collapse", "index", "option", "selectOption", "(ILjava/lang/String;)V", "cycleOption", "invalidateParentLayout", "", "mouseX", "mouseY", "onRender", "(FF)V", "Ljava/util/List;", "", "expanded", "Z", "isAnimating", "value", "I", "getSelectedIndex", "()I", "Lxyz/meowing/vexel/components/core/Text;", "label", "Lxyz/meowing/vexel/components/core/Text;", "Lxyz/meowing/vexel/components/core/Rectangle;", "selectedButton", "Lxyz/meowing/vexel/components/core/Rectangle;", "selectedText", "optionsContainer", "Lxyz/meowing/vexel/components/core/Container;", "actualContainer", "Lxyz/meowing/vexel/components/core/Container;", "Companion", "Zen"})
@SourceDebugExtension(value={"SMAP\nDropdownElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DropdownElement.kt\nxyz/meowing/zen/config/ui/elements/DropdownElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n1878#2,3:204\n1869#2:207\n1869#2,2:208\n1870#2:210\n1869#2,2:211\n*S KotlinDebug\n*F\n+ 1 DropdownElement.kt\nxyz/meowing/zen/config/ui/elements/DropdownElement\n*L\n90#1:204,3\n168#1:207\n170#1:208,2\n168#1:210\n182#1:211,2\n*E\n"})
public final class DropdownElement
extends VexelElement<DropdownElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> options;
    private boolean expanded;
    private boolean isAnimating;
    private int selectedIndex;
    @NotNull
    private final Text label;
    @NotNull
    private final Rectangle selectedButton;
    @NotNull
    private final Text selectedText;
    @NotNull
    private final Rectangle optionsContainer;
    @NotNull
    private final Container actualContainer;
    @Nullable
    private static DropdownElement openDropdown;

    public DropdownElement(@NotNull String name, @NotNull List<String> options, int selectedIndex) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        super(null, null, 3, null);
        this.options = options;
        this.selectedIndex = selectedIndex;
        this.label = (Text)((Text)new Text(name, Theme.Text.getColor(), 16.0f, false, null, 24, null).setPositioning(6.0f, Pos.ParentPixels, 8.0f, Pos.ParentPixels)).childOf((VexelElement)this);
        this.selectedButton = (Rectangle)((Rectangle)((Rectangle)((Rectangle)new Rectangle(Theme.BgLight.getColor(), Theme.Border.getColor(), 5.0f, 1.0f, null, null, null, null, null, false, 1008, null).setPositioning(-6.0f, Pos.ParentPixels, 0.0f, Pos.MatchSibling)).alignRight()).setOffset(0.0f, -2.0f)).childOf((VexelElement)this);
        this.selectedText = (Text)((Text)new Text(this.options.get(selectedIndex), Theme.Text.getColor(), 16.0f, false, null, 24, null).setPositioning(0.0f, Pos.ParentCenter, 0.0f, Pos.ParentCenter)).childOf((VexelElement)this.selectedButton);
        this.optionsContainer = (Rectangle)((Rectangle)((Rectangle)new Rectangle(Theme.BgLight.getColor(), 0, 5.0f, 0.0f, null, null, null, null, null, false, 1008, null).setSizing(228.0f, Size.Pixels, 0.0f, Size.Pixels)).setPositioning(6.0f, Pos.ParentPixels, 32.0f, Pos.ParentPixels)).childOf((VexelElement)this);
        this.actualContainer = (Container)((Container)((Container)new Container(null, false, null, null, 15, null).setSizing(Size.Fill, Size.Auto)).setPositioning(Pos.ParentCenter, Pos.ParentCenter)).childOf((VexelElement)this.optionsContainer);
        this.setSizing(240.0f, Size.Pixels, 32.0f, Size.Pixels);
        this.setPositioning(Pos.ParentPixels, Pos.AfterSibling);
        this.updateButtonSize();
        this.selectedButton.onHover((Function2)new Function2<Float, Float, Unit>(){

            public final void invoke(float f, float f2) {
                PresetsKt.colorTo$default((VexelElement)((VexelElement)selectedButton), (int)Theme.Highlight.getColor(), (long)150L, (EasingType)EasingType.EASE_OUT, null, (int)8, null);
            }
        }, (Function2)new Function2<Float, Float, Unit>(){

            public final void invoke(float f, float f2) {
                PresetsKt.colorTo$default((VexelElement)((VexelElement)selectedButton), (int)Theme.BgLight.getColor(), (long)150L, (EasingType)EasingType.EASE_IN, null, (int)8, null);
            }
        });
        this.selectedButton.onClick((Function3)new Function3<Float, Float, Integer, Boolean>(){

            public final Boolean invoke(float f, float f2, int button2) {
                return switch (button2) {
                    case 0 -> {
                        if (!isAnimating) {
                            if (expanded) {
                                this.collapse();
                            } else {
                                this.expand();
                            }
                        }
                        yield true;
                    }
                    case 1 -> {
                        this.cycleOption();
                        yield true;
                    }
                    default -> false;
                };
            }
        });
        this.optionsContainer.setVisible(false);
        this.createOptions();
    }

    public final int getSelectedIndex() {
        return this.selectedIndex;
    }

    /*
     * WARNING - void declaration
     */
    private final void createOptions() {
        Iterable $this$forEachIndexed$iv = this.options;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void option;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            boolean isFirst = index == 0;
            boolean isLast = index == this.options.size() - 1;
            float topLeftRadius = isFirst ? 5.0f : 0.0f;
            float topRightRadius = isFirst ? 5.0f : 0.0f;
            float bottomLeftRadius = isLast ? 5.0f : 0.0f;
            float bottomRightRadius = isLast ? 5.0f : 0.0f;
            Rectangle optionRect = (Rectangle)((Rectangle)((Rectangle)new Rectangle(0, 0, 0.0f, 0.0f, null, null, null, null, null, false, 1008, null).borderRadiusVarying(topLeftRadius, topRightRadius, bottomLeftRadius, bottomRightRadius).setSizing(228.0f, Size.Pixels, 26.0f, Size.Pixels)).setPositioning(0.0f, Pos.ParentPixels, 0.0f, Pos.AfterSibling)).childOf((VexelElement)this.actualContainer);
            Text optionText = (Text)((Text)new Text((String)option, Theme.Text.getColor(), 16.0f, false, null, 24, null).setPositioning(0.0f, Pos.ParentCenter, 0.0f, Pos.ParentCenter)).childOf((VexelElement)optionRect);
            optionText.setVisible(false);
            optionRect.onHover((Function2)new Function2<Float, Float, Unit>(optionRect){
                final /* synthetic */ Rectangle $optionRect;
                {
                    this.$optionRect = $optionRect;
                    super(2);
                }

                public final void invoke(float f, float f2) {
                    PresetsKt.colorTo$default((VexelElement)((VexelElement)this.$optionRect), (int)Theme.Highlight.getColor(), (long)150L, (EasingType)EasingType.EASE_OUT, null, (int)8, null);
                }
            }, (Function2)new Function2<Float, Float, Unit>(optionRect){
                final /* synthetic */ Rectangle $optionRect;
                {
                    this.$optionRect = $optionRect;
                    super(2);
                }

                public final void invoke(float f, float f2) {
                    PresetsKt.colorTo$default((VexelElement)((VexelElement)this.$optionRect), (int)0, (long)150L, (EasingType)EasingType.EASE_IN, null, (int)8, null);
                }
            });
            optionRect.onClick((Function3)new Function3<Float, Float, Integer, Boolean>(this, index, (String)option){
                final /* synthetic */ DropdownElement this$0;
                final /* synthetic */ int $index;
                final /* synthetic */ String $option;
                {
                    this.this$0 = $receiver;
                    this.$index = $index;
                    this.$option = $option;
                    super(3);
                }

                public final Boolean invoke(float f, float f2, int n) {
                    DropdownElement.access$selectOption(this.this$0, this.$index, this.$option);
                    return true;
                }
            });
        }
    }

    private final void updateButtonSize() {
        float textWidth = NVGRenderer.INSTANCE.textWidth(this.selectedText.getText(), 16.0f, NVGRenderer.INSTANCE.getDefaultFont());
        this.selectedButton.setSizing(textWidth + 12.0f, Size.Pixels, 20.0f, Size.Pixels);
    }

    private final void expand() {
        if (this.expanded) {
            return;
        }
        Companion.closeAllDropdowns();
        openDropdown = this;
        this.expanded = true;
        this.isAnimating = true;
        this.optionsContainer.setVisible(true);
        float targetHeight = 32.0f + (float)this.options.size() * 26.0f + 6.0f;
        float containerHeight = (float)this.options.size() * 26.0f;
        xyz.meowing.vexel.animations.ExtensionsKt.animateSize((VexelElement)this, (float)240.0f, (float)targetHeight, (long)200L, (EasingType)EasingType.EASE_OUT, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DropdownElement this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                DropdownElement.access$setAnimating$p(this.this$0, false);
                DropdownElement.access$invalidateParentLayout(this.this$0);
            }
        }));
        xyz.meowing.vexel.animations.ExtensionsKt.animateSize((VexelElement)((VexelElement)this.optionsContainer), (float)228.0f, (float)containerHeight, (long)200L, (EasingType)EasingType.EASE_OUT, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DropdownElement this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Iterable $this$forEach$iv = DropdownElement.access$getOptionsContainer$p(this.this$0).getChildren();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    VexelElement child = (VexelElement)element$iv;
                    boolean bl = false;
                    ExtensionsKt.fadeIn$default(child, 50L, null, false, null, 14, null);
                    Iterable $this$forEach$iv2 = child.getChildren();
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        VexelElement it = (VexelElement)element$iv2;
                        boolean bl2 = false;
                        it.setVisible(true);
                        ExtensionsKt.fadeIn$default(it, 50L, null, false, null, 14, null);
                    }
                }
            }
        }));
    }

    private final void collapse() {
        if (!this.expanded) {
            return;
        }
        this.expanded = false;
        this.isAnimating = true;
        openDropdown = null;
        xyz.meowing.vexel.animations.ExtensionsKt.animateSize((VexelElement)this, (float)240.0f, (float)32.0f, (long)200L, (EasingType)EasingType.EASE_IN, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DropdownElement this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                DropdownElement.access$setAnimating$p(this.this$0, false);
                DropdownElement.access$invalidateParentLayout(this.this$0);
            }
        }));
        Iterable $this$forEach$iv = this.optionsContainer.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VexelElement child = (VexelElement)element$iv;
            boolean bl = false;
            ExtensionsKt.fadeOut$default(child, 50L, null, false, null, 14, null);
            Iterable $this$forEach$iv2 = child.getChildren();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                VexelElement it = (VexelElement)element$iv2;
                boolean bl2 = false;
                ExtensionsKt.fadeOut$default(it, 50L, null, false, null, 14, null);
            }
        }
        xyz.meowing.vexel.animations.ExtensionsKt.animateSize((VexelElement)((VexelElement)this.optionsContainer), (float)228.0f, (float)0.0f, (long)200L, (EasingType)EasingType.EASE_IN, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DropdownElement this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                DropdownElement.access$getOptionsContainer$p(this.this$0).setVisible(false);
            }
        }));
    }

    private final void selectOption(int index, String option) {
        this.selectedIndex = index;
        this.selectedText.setText(option);
        this.updateButtonSize();
        Iterable $this$forEach$iv = this.getOnValueChange();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)this.selectedIndex);
        }
        if (!this.isAnimating) {
            this.collapse();
        }
    }

    private final void cycleOption() {
        int nextIndex = this.selectedIndex >= this.options.size() - 1 ? 0 : this.selectedIndex + 1;
        this.selectOption(nextIndex, this.options.get(nextIndex));
    }

    private final void invalidateParentLayout() {
        block1: {
            VexelElement current;
            Object object = this.getParent();
            VexelElement vexelElement = current = object instanceof VexelElement ? (VexelElement)object : null;
            while (current != null && !(current instanceof SectionButton)) {
                object = current.getParent();
                current = object instanceof VexelElement ? (VexelElement)object : null;
            }
            SectionButton sectionButton = (SectionButton)current;
            if (sectionButton == null) break block1;
            sectionButton.recalculateHeight();
        }
    }

    protected void onRender(float mouseX, float mouseY) {
    }

    public static final /* synthetic */ void access$setAnimating$p(DropdownElement $this, boolean bl) {
        $this.isAnimating = bl;
    }

    public static final /* synthetic */ void access$invalidateParentLayout(DropdownElement $this) {
        $this.invalidateParentLayout();
    }

    public static final /* synthetic */ Rectangle access$getOptionsContainer$p(DropdownElement $this) {
        return $this.optionsContainer;
    }

    public static final /* synthetic */ void access$selectOption(DropdownElement $this, int index, String option) {
        $this.selectOption(index, option);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R$\u0010\b\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lxyz/meowing/zen/config/ui/elements/DropdownElement$Companion;", "", "<init>", "()V", "", "closeAllDropdowns", "()Lkotlin/Unit;", "Lxyz/meowing/zen/config/ui/elements/DropdownElement;", "openDropdown", "Lxyz/meowing/zen/config/ui/elements/DropdownElement;", "getOpenDropdown", "()Lxyz/meowing/zen/config/ui/elements/DropdownElement;", "setOpenDropdown", "(Lxyz/meowing/zen/config/ui/elements/DropdownElement;)V", "Zen"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DropdownElement getOpenDropdown() {
            return openDropdown;
        }

        public final void setOpenDropdown(@Nullable DropdownElement dropdownElement) {
            openDropdown = dropdownElement;
        }

        @Nullable
        public final Unit closeAllDropdowns() {
            Unit unit;
            DropdownElement dropdownElement = this.getOpenDropdown();
            if (dropdownElement != null) {
                dropdownElement.collapse();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return unit;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

