/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.zen.features.hud.tradeHistory;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.knit.api.input.KnitKeyboard;
import xyz.meowing.knit.api.input.KnitMouse;
import xyz.meowing.knit.api.screen.KnitScreen;
import xyz.meowing.zen.api.item.ItemAPI;
import xyz.meowing.zen.api.skyblock.TradeAPI;
import xyz.meowing.zen.ui.Theme;
import xyz.meowing.zen.utils.Render2D;
import xyz.meowing.zen.utils.Utils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0015\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002mnB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\f\u001a\u00020\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ/\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012JG\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015JO\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ/\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJW\u0010&\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b&\u0010'J%\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010-\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b-\u0010.J\u0017\u00101\u001a\u0002002\u0006\u0010/\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b1\u00102J\u001f\u00104\u001a\u0002032\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b4\u00105J\u001f\u00106\u001a\u0002032\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b6\u00107J\u0017\u00109\u001a\u00020\u00162\u0006\u00108\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b9\u0010:J\u0013\u0010<\u001a\u00020\u0016*\u00020;H\u0002\u00a2\u0006\u0004\b<\u0010=J'\u0010?\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010>\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b?\u0010@J'\u0010E\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020A2\u0006\u0010C\u001a\u00020\u00062\u0006\u0010D\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\bE\u0010FJ\u001f\u0010I\u001a\u00020\u000b2\u0006\u0010G\u001a\u00020;2\u0006\u0010H\u001a\u00020;H\u0016\u00a2\u0006\u0004\bI\u0010JR\u0014\u0010L\u001a\u00020K8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bL\u0010MR\u0014\u0010O\u001a\u00020N8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bO\u0010PR\"\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\t0Q8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bR\u0010SR\"\u0010T\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\t0Q8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bT\u0010SR\u0018\u0010U\u001a\u0004\u0018\u00010\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bU\u0010VR\u0016\u0010W\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bW\u0010VR\u0016\u0010X\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bX\u0010YR\u0016\u0010Z\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bZ\u0010YR\u0016\u0010[\u001a\u0002038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b[\u0010\\R\u0016\u0010]\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b]\u0010^R\u0014\u0010_\u001a\u00020\u00068\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b_\u0010^R\u0014\u0010`\u001a\u00020\u00068\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b`\u0010^R\u0014\u0010a\u001a\u00020\u00068\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\ba\u0010^R\u0014\u0010b\u001a\u00020\u00068\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\bb\u0010^R\u0014\u0010c\u001a\u00020\u00068\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\bc\u0010^R\u0014\u0010d\u001a\u00020\u00068\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\bd\u0010^R\u0014\u0010e\u001a\u00020\u00068\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\be\u0010^R\u0014\u0010f\u001a\u00020\u00068\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\bf\u0010^R\u001a\u0010i\u001a\b\u0012\u0004\u0012\u00020h0g8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bi\u0010jR\u001a\u0010l\u001a\b\u0012\u0004\u0012\u00020k0g8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bl\u0010j\u00a8\u0006o"}, d2={"Lxyz/meowing/zen/features/hud/tradeHistory/TradeHistoryHUD;", "Lxyz/meowing/knit/api/screen/KnitScreen;", "<init>", "()V", "Lnet/minecraft/class_332;", "context", "", "mouseX", "mouseY", "", "deltaTicks", "", "onRender", "(Lnet/minecraft/class_332;IIF)V", "x", "y", "width", "renderHeader", "(Lnet/minecraft/class_332;III)V", "height", "renderContent", "(Lnet/minecraft/class_332;IIIIII)V", "", "date", "Lcom/google/gson/JsonArray;", "trades", "renderDateSection", "(Lnet/minecraft/class_332;IIILjava/lang/String;Lcom/google/gson/JsonArray;II)I", "Lcom/google/gson/JsonObject;", "trade", "renderTradeCard", "(Lnet/minecraft/class_332;IILcom/google/gson/JsonObject;)V", "title", "items", "", "coins", "color", "customValueKey", "renderTradeSide", "(Lnet/minecraft/class_332;IILjava/lang/String;Lcom/google/gson/JsonArray;JILcom/google/gson/JsonObject;Ljava/lang/String;)J", "", "Lnet/minecraft/class_2561;", "createDateSummary", "(Ljava/lang/String;Lcom/google/gson/JsonArray;)Ljava/util/List;", "skyblockId", "getItemValue", "(Ljava/lang/String;)J", "itemObj", "Lnet/minecraft/class_1799;", "createItemStack", "(Lcom/google/gson/JsonObject;)Lnet/minecraft/class_1799;", "", "dateShouldShow", "(Ljava/lang/String;Lcom/google/gson/JsonArray;)Z", "matchesSearch", "(Lcom/google/gson/JsonObject;Ljava/lang/String;)Z", "num", "abbreviateNumber", "(J)Ljava/lang/String;", "", "format", "(D)Ljava/lang/String;", "button", "onMouseClick", "(III)V", "", "typedChar", "keyCode", "scanCode", "onKeyType", "(CII)V", "horizontal", "vertical", "onMouseScroll", "(DD)V", "Ljava/text/DecimalFormat;", "formatter", "Ljava/text/DecimalFormat;", "Ljava/text/SimpleDateFormat;", "timeFormatter", "Ljava/text/SimpleDateFormat;", "", "horizontalScrollOffsets", "Ljava/util/Map;", "maxHorizontalScrolls", "currentScrollingDate", "Ljava/lang/String;", "searchQuery", "scrollOffset", "F", "maxScroll", "searchFocused", "Z", "searchCursorPos", "I", "padding", "headerHeight", "searchBoxWidth", "searchBoxHeight", "cardWidth", "cardHeight", "cardSpacing", "itemSize", "", "Lxyz/meowing/zen/features/hud/tradeHistory/TradeHistoryHUD$HoverElement;", "hoverElements", "Ljava/util/List;", "Lxyz/meowing/zen/features/hud/tradeHistory/TradeHistoryHUD$ItemRender;", "itemsToRender", "HoverElement", "ItemRender", "Zen"})
@SourceDebugExtension(value={"SMAP\nTradeHistoryHUD.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TradeHistoryHUD.kt\nxyz/meowing/zen/features/hud/tradeHistory/TradeHistoryHUD\n+ 2 Render2D.kt\nxyz/meowing/zen/utils/Render2D\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,419:1\n75#2,11:420\n1563#3:431\n1634#3,3:432\n1068#3:435\n774#3:436\n865#3,2:437\n1878#3,2:439\n1563#3:441\n1634#3,3:442\n1880#3:445\n1869#3:446\n1869#3,2:447\n1869#3,2:449\n1870#3:451\n1869#3,2:454\n1869#3:456\n1869#3,2:457\n1870#3:459\n216#4,2:452\n*S KotlinDebug\n*F\n+ 1 TradeHistoryHUD.kt\nxyz/meowing/zen/features/hud/tradeHistory/TradeHistoryHUD\n*L\n73#1:420,11\n131#1:431\n131#1:432,3\n131#1:435\n166#1:436\n166#1:437,2\n239#1:439,2\n242#1:441\n242#1:442,3\n239#1:445\n281#1:446\n285#1:447,2\n292#1:449,2\n281#1:451\n339#1:454,2\n351#1:456\n352#1:457,2\n351#1:459\n306#1:452,2\n*E\n"})
public final class TradeHistoryHUD
extends KnitScreen {
    @NotNull
    private final DecimalFormat formatter = new DecimalFormat("#,###");
    @NotNull
    private final SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm");
    @NotNull
    private Map<String, Float> horizontalScrollOffsets = new LinkedHashMap();
    @NotNull
    private Map<String, Float> maxHorizontalScrolls = new LinkedHashMap();
    @Nullable
    private String currentScrollingDate;
    @NotNull
    private String searchQuery = "";
    private float scrollOffset;
    private float maxScroll;
    private boolean searchFocused;
    private int searchCursorPos;
    private final int padding;
    private final int headerHeight;
    private final int searchBoxWidth;
    private final int searchBoxHeight;
    private final int cardWidth;
    private final int cardHeight;
    private final int cardSpacing;
    private final int itemSize;
    @NotNull
    private final List<HoverElement> hoverElements = new ArrayList();
    @NotNull
    private final List<ItemRender> itemsToRender = new ArrayList();

    public TradeHistoryHUD() {
        super("Trade History");
        this.padding = 8;
        this.headerHeight = 30;
        this.searchBoxWidth = 200;
        this.searchBoxHeight = 20;
        this.cardWidth = 220;
        this.cardHeight = 150;
        this.cardSpacing = 4;
        this.itemSize = 12;
    }

    public void onRender(@Nullable class_332 context, int mouseX, int mouseY, float deltaTicks) {
        if (context == null) {
            return;
        }
        this.hoverElements.clear();
        this.itemsToRender.clear();
        int screenWidth = this.field_22789;
        int screenHeight = this.field_22790;
        int mainWidth = (int)((float)screenWidth * 0.9f);
        int mainHeight = (int)((float)screenHeight * 0.9f);
        int mainX = (screenWidth - mainWidth) / 2;
        int mainY = (screenHeight - mainHeight) / 2;
        context.method_25294(mainX, mainY, mainX + mainWidth, mainY + mainHeight, Theme.BgDark.getColor());
        Render2D.INSTANCE.renderBorder(context, mainX, mainY, mainWidth, mainHeight, Theme.Primary.getColor());
        this.renderHeader(context, mainX, mainY, mainWidth);
        this.renderContent(context, mainX, mainY + this.headerHeight, mainWidth, mainHeight - this.headerHeight, mouseX, mouseY);
        context.method_44379(mainX + this.padding, mainY + this.headerHeight, mainX + mainWidth - this.padding, mainY + mainHeight);
        for (ItemRender item : this.itemsToRender) {
            Render2D render2D = Render2D.INSTANCE;
            class_332 $this$pushPop$iv = context;
            boolean $i$f$pushPop = false;
            $this$pushPop$iv.method_51448().pushMatrix();
            boolean bl = false;
            context.method_51448().translate((float)item.getX(), (float)item.getY());
            context.method_51448().scale(item.getScale(), item.getScale());
            context.method_51427(item.getStack(), 0, 0);
            context.method_51431(this.field_22793, item.getStack(), 0, 0);
            $this$pushPop$iv.method_51448().popMatrix();
        }
        context.method_44380();
        for (HoverElement element : this.hoverElements) {
            if (mouseX < element.getX() || mouseX > element.getX() + element.getWidth() || mouseY < element.getY() || mouseY > element.getY() + element.getHeight()) continue;
            context.method_51434(this.field_22793, element.getTooltip(), mouseX, mouseY);
            break;
        }
    }

    private final void renderHeader(class_332 context, int x, int y, int width) {
        context.method_51433(this.field_22793, "Trade History", x + this.padding, y + (this.headerHeight - this.field_22793.field_2000) / 2, Theme.Text.getColor(), false);
        int searchX = x + width - this.searchBoxWidth - this.padding / 2;
        int searchY = y + (this.headerHeight - this.searchBoxHeight) / 2;
        double mouseX = KnitMouse.Scaled.INSTANCE.getX();
        double mouseY = KnitMouse.Scaled.INSTANCE.getY();
        boolean searchHovered = mouseX >= (double)searchX && mouseX <= (double)(searchX + this.searchBoxWidth) && mouseY >= (double)searchY && mouseY <= (double)(searchY + this.searchBoxHeight);
        int searchBg = searchHovered ? Theme.BgLight.getColor() : Theme.Bg.getColor();
        context.method_25294(searchX, searchY, searchX + this.searchBoxWidth, searchY + this.searchBoxHeight, searchBg);
        String displayText = ((CharSequence)this.searchQuery).length() == 0 && !this.searchFocused ? "Search trades..." : this.searchQuery;
        int textColor = ((CharSequence)this.searchQuery).length() == 0 && !this.searchFocused ? -2136291329 : Theme.Text.getColor();
        context.method_51433(this.field_22793, displayText, searchX + 6, searchY + (this.searchBoxHeight - this.field_22793.field_2000 + 2) / 2, textColor, false);
        if (this.searchFocused && System.currentTimeMillis() % (long)1000 < 500L) {
            String string = this.searchQuery.substring(0, Math.min(this.searchCursorPos, this.searchQuery.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            int cursorX = searchX + 6 + this.field_22793.method_1727(string);
            context.method_25294(cursorX, searchY + 4, cursorX + 1, searchY + this.searchBoxHeight - 4, Theme.Text.getColor());
        }
        context.method_25294(x, y + this.headerHeight - 1, x + width, y + this.headerHeight, Theme.Primary.withAlpha(0.5f));
    }

    /*
     * WARNING - void declaration
     */
    private final void renderContent(class_332 context, int x, int y, int width, int height, int mouseX, int mouseY) {
        void $this$sortedByDescending$iv;
        void $this$mapTo$iv$iv;
        JsonObject tradeHistory = TradeAPI.INSTANCE.getTradeHistory();
        if (tradeHistory.entrySet().isEmpty()) {
            context.method_25300(this.field_22793, "No trades recorded yet", x + width / 2, y + height / 2, Theme.Text.getColor());
            return;
        }
        context.method_44379(x, y, x + width, y + height);
        Set set2 = tradeHistory.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"entrySet(...)");
        Iterable $this$map$iv = set2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List sortedDates = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            /*
             * WARNING - void declaration
             */
            public final int compare(T a, T b) {
                void var3_3;
                String it = (String)b;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it);
                it = (String)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)var3_3));
            }
        });
        int currentY = y + this.padding - (int)this.scrollOffset;
        for (String date : sortedDates) {
            JsonArray trades = tradeHistory.getAsJsonArray(date);
            if (trades.size() <= 0) continue;
            Intrinsics.checkNotNull((Object)date);
            Intrinsics.checkNotNull((Object)trades);
            if (!this.dateShouldShow(date, trades)) continue;
            currentY = this.renderDateSection(context, x, currentY, width, date, trades, mouseX, mouseY);
            currentY += this.padding;
        }
        this.maxScroll = Math.max(0.0f, (float)currentY + this.scrollOffset - (float)y - (float)height + (float)this.padding);
        if (this.maxScroll > 0.0f) {
            int scrollbarHeight = Math.max(20, (int)((float)(height * height) / ((float)height + this.maxScroll)));
            int scrollbarY = y + (int)(this.scrollOffset / this.maxScroll * (float)(height - scrollbarHeight));
            context.method_25294(x + width - 6, scrollbarY, x + width - 3, scrollbarY + scrollbarHeight, -8618883);
        }
        context.method_44380();
    }

    /*
     * WARNING - void declaration
     */
    private final int renderDateSection(class_332 context, int x, int y, int width, String date, JsonArray trades, int mouseX, int mouseY) {
        void $this$filterTo$iv$iv;
        int headerHeight = 25;
        context.method_25294(x + this.padding, y, x + width - this.padding, y + headerHeight, Theme.Bg.getColor());
        context.method_51433(this.field_22793, date, x + this.padding * 2, y + (headerHeight - this.field_22793.field_2000) / 2, Theme.Text.getColor(), false);
        context.method_51433(this.field_22793, trades.size() + " trades", x + width - this.padding * 2 - this.field_22793.method_1727(trades.size() + " trades"), y + (headerHeight - this.field_22793.field_2000) / 2, Theme.TextMuted.getColor(), false);
        this.hoverElements.add(new HoverElement(x + this.padding, y, width - this.padding * 2, headerHeight, this.createDateSummary(date, trades)));
        int scrollY = y + headerHeight;
        int scrollHeight = this.cardHeight + 10;
        int scrollWidth = width - this.padding * 2;
        Iterable $this$filter$iv = (Iterable)trades;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JsonElement it = (JsonElement)element$iv$iv;
            boolean bl = false;
            JsonObject jsonObject2 = it.getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
            if (!this.matchesSearch(jsonObject2, date)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredTrades = (List)destination$iv$iv;
        int totalContentWidth = filteredTrades.size() * (this.cardWidth + this.cardSpacing) + this.cardSpacing;
        float maxHScroll = Math.max(0.0f, (float)totalContentWidth - (float)scrollWidth);
        this.maxHorizontalScrolls.put(date, Float.valueOf(maxHScroll));
        float hScrollOffset = ((Number)this.horizontalScrollOffsets.getOrDefault(date, Float.valueOf(0.0f))).floatValue();
        if (mouseX >= x + this.padding && mouseX <= x + width - this.padding && mouseY >= scrollY && mouseY <= scrollY + scrollHeight) {
            this.currentScrollingDate = date;
        }
        context.method_44379(x + this.padding, scrollY, x + width - this.padding, scrollY + scrollHeight);
        int cardX = x + this.padding + this.cardSpacing - (int)hScrollOffset;
        for (JsonElement trade : CollectionsKt.reversed((Iterable)filteredTrades)) {
            JsonObject jsonObject3 = trade.getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject3, (String)"getAsJsonObject(...)");
            this.renderTradeCard(context, cardX, scrollY + 5, jsonObject3);
            cardX += this.cardWidth + this.cardSpacing;
        }
        context.method_44380();
        if (maxHScroll > 0.0f) {
            int scrollbarWidth = Math.max(40, scrollWidth * scrollWidth / totalContentWidth);
            int scrollbarX = x + this.padding + (int)(hScrollOffset / maxHScroll * (float)(scrollWidth - scrollbarWidth));
            context.method_25294(scrollbarX, scrollY + scrollHeight, scrollbarX + scrollbarWidth, scrollY + scrollHeight - 1, -8618883);
        }
        return scrollY + scrollHeight + 4;
    }

    private final void renderTradeCard(class_332 context, int x, int y, JsonObject trade) {
        context.method_25294(x, y, x + this.cardWidth, y + this.cardHeight, Theme.Bg.getColor());
        Render2D.INSTANCE.renderBorder(context, x, y, this.cardWidth, this.cardHeight, Theme.Primary.getColor());
        long timestamp = trade.get("timestamp").getAsLong();
        String username = trade.get("username").getAsString();
        long yourCoins = trade.get("yourCoins").getAsLong();
        long theirCoins = trade.get("theirCoins").getAsLong();
        JsonArray yourItems = trade.getAsJsonArray("yourItems");
        JsonArray theirItems = trade.getAsJsonArray("theirItems");
        context.method_51433(this.field_22793, username, x + 8, y + 10, Theme.Warning.getColor(), false);
        context.method_51433(this.field_22793, this.timeFormatter.format(new Date(timestamp)), x + this.cardWidth - 8 - this.field_22793.method_1727(this.timeFormatter.format(new Date(timestamp))), y + 10, Theme.TextMuted.getColor(), false);
        context.method_25294(x, y + 29, x + this.cardWidth, y + 30, Theme.Primary.getColor());
        int leftX = x + 8;
        int rightX = x + this.cardWidth / 2 + 8;
        int contentY = y + 35;
        Intrinsics.checkNotNull((Object)yourItems);
        long yourCustomWorth = this.renderTradeSide(context, leftX, contentY, "You Gave", yourItems, yourCoins, Theme.Danger.getColor(), trade, "yourCustomValue");
        Intrinsics.checkNotNull((Object)theirItems);
        long theirCustomWorth = this.renderTradeSide(context, rightX, contentY, "You Received", theirItems, theirCoins, Theme.Success.getColor(), trade, "theirCustomValue");
        context.method_25294(x + this.cardWidth / 2, y + 40, x + this.cardWidth / 2 + 1, y + this.cardHeight - 30, Theme.Primary.getColor());
        long profit = theirCustomWorth - yourCustomWorth;
        String profitText = profit >= 0L ? "Profit: +" + this.abbreviateNumber(profit) : "Loss: " + this.abbreviateNumber(profit);
        int profitColor = profit >= 0L ? Theme.Success.getColor() : Theme.Danger.getColor();
        context.method_51433(this.field_22793, profitText, x + (this.cardWidth - this.field_22793.method_1727(profitText)) / 2, y + this.cardHeight - 20, profitColor, false);
    }

    /*
     * WARNING - void declaration
     */
    private final long renderTradeSide(class_332 context, int x, int y, String title, JsonArray items, long coins, int color, JsonObject trade, String customValueKey) {
        long totalWorth;
        int titleWidth = this.field_22793.method_1727(title);
        int sectionWidth = this.cardWidth / 2 - 16;
        context.method_51433(this.field_22793, title, x + (sectionWidth - titleWidth) / 2, y, color, false);
        int itemsStartY = y + 15;
        long itemWorth = 0L;
        int maxCols = 4;
        int gridWidth = maxCols * (this.itemSize + 4) - 4;
        int startX = x + (sectionWidth - gridWidth) / 2;
        Iterable $this$forEachIndexed$iv = (Iterable)items;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void $this$mapTo$iv$iv;
            void itemElement;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JsonElement jsonElement = (JsonElement)item$iv;
            int index = n;
            boolean bl = false;
            JsonObject jsonObject2 = itemElement.getAsJsonObject();
            Intrinsics.checkNotNull((Object)jsonObject2);
            class_1799 stack = this.createItemStack(jsonObject2);
            String string = jsonObject2.get("lore").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            char[] cArray = new char[]{'\n'};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(class_2561.method_43470((String)it));
            }
            List loreLines = (List)destination$iv$iv;
            String name = jsonObject2.get("name").getAsString();
            String skyblockId = jsonObject2.has("skyblockId") ? jsonObject2.get("skyblockId").getAsString() : "null";
            int row = index / maxCols;
            int col = index % maxCols;
            int itemX = startX + col * (this.itemSize + 4);
            int itemY = itemsStartY + row * (this.itemSize + 4);
            this.itemsToRender.add(new ItemRender(stack, itemX, itemY, 0.75f));
            List tooltip = new ArrayList();
            class_5250 class_52502 = class_2561.method_43470((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
            tooltip.add(class_52502);
            tooltip.addAll(loreLines);
            this.hoverElements.add(new HoverElement(itemX, itemY, this.itemSize, this.itemSize, tooltip));
            Intrinsics.checkNotNull((Object)skyblockId);
            itemWorth += this.getItemValue(skyblockId) * (long)stack.method_7947();
        }
        long currentWorth = totalWorth = itemWorth + coins;
        if (trade.has(customValueKey)) {
            currentWorth = trade.get(customValueKey).getAsLong();
        }
        if (coins > 0L) {
            String coinText = this.abbreviateNumber(coins) + " coins";
            int coinWidth = this.field_22793.method_1727(coinText);
            context.method_51433(this.field_22793, coinText, x + (sectionWidth - coinWidth) / 2, y + 70, Theme.Warning.getColor(), false);
        }
        return currentWorth;
    }

    private final List<class_2561> createDateSummary(String date, JsonArray trades) {
        long coinChange = 0L;
        Map itemChanges = new LinkedHashMap();
        Iterable $this$forEach$iv = (Iterable)trades;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key;
            class_1799 stack;
            JsonObject itemObj;
            JsonElement item;
            JsonElement tradeElement = (JsonElement)element$iv;
            boolean bl = false;
            JsonObject trade = tradeElement.getAsJsonObject();
            coinChange += trade.get("theirCoins").getAsLong() - trade.get("yourCoins").getAsLong();
            JsonArray jsonArray = trade.getAsJsonArray("yourItems");
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
            Iterable $this$forEach$iv2 = (Iterable)jsonArray;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                item = (JsonElement)element$iv2;
                boolean bl2 = false;
                itemObj = item.getAsJsonObject();
                Intrinsics.checkNotNull((Object)itemObj);
                stack = this.createItemStack(itemObj);
                key = Utils.INSTANCE.removeFormatting(stack.method_7964().getString());
                itemChanges.put(key, ((Number)itemChanges.getOrDefault(key, 0)).intValue() - stack.method_7947());
            }
            JsonArray jsonArray2 = trade.getAsJsonArray("theirItems");
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray2, (String)"getAsJsonArray(...)");
            $this$forEach$iv2 = (Iterable)jsonArray2;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                item = (JsonElement)element$iv2;
                boolean bl3 = false;
                itemObj = item.getAsJsonObject();
                Intrinsics.checkNotNull((Object)itemObj);
                stack = this.createItemStack(itemObj);
                key = Utils.INSTANCE.removeFormatting(stack.method_7964().getString());
                itemChanges.put(key, ((Number)itemChanges.getOrDefault(key, 0)).intValue() + stack.method_7947());
            }
        }
        List tooltip = new ArrayList();
        class_5250 class_52502 = class_2561.method_43470((String)("\u00a7e\u00a7l" + date + " Summary"));
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
        tooltip.add(class_52502);
        class_5250 class_52503 = class_2561.method_43470((String)("\u00a77Coin Change: " + (coinChange >= 0L ? "\u00a7a+" : "\u00a7c") + this.formatter.format(coinChange)));
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"literal(...)");
        tooltip.add(class_52503);
        if (!itemChanges.isEmpty()) {
            class_5250 class_52504 = class_2561.method_43470((String)"\u00a77Item Changes:");
            Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"literal(...)");
            tooltip.add(class_52504);
            Map $this$forEach$iv3 = itemChanges;
            boolean $i$f$forEach3 = false;
            Iterator iterator = $this$forEach$iv3.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String item = (String)entry.getKey();
                int change = ((Number)entry.getValue()).intValue();
                if (change == 0) continue;
                class_5250 class_52505 = class_2561.method_43470((String)(" " + (change > 0 ? "\u00a7a+" : "\u00a7c") + change + " \u00a77" + item));
                Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"literal(...)");
                tooltip.add(class_52505);
            }
        }
        return tooltip;
    }

    private final long getItemValue(String skyblockId) {
        if (Intrinsics.areEqual((Object)skyblockId, (Object)"null")) {
            return 0L;
        }
        JsonObject jsonObject2 = ItemAPI.INSTANCE.getItemInfo(skyblockId);
        if (jsonObject2 == null) {
            return 0L;
        }
        JsonObject itemInfo = jsonObject2;
        return itemInfo.has("lowestBin") && itemInfo.get("lowestBin").getAsLong() > 0L ? itemInfo.get("lowestBin").getAsLong() : (itemInfo.has("bazaarSell") && itemInfo.get("bazaarSell").getAsDouble() > 0.0 ? (long)itemInfo.get("bazaarSell").getAsDouble() : (itemInfo.has("bazaarBuy") && itemInfo.get("bazaarBuy").getAsDouble() > 0.0 ? (long)itemInfo.get("bazaarBuy").getAsDouble() : (itemInfo.has("avgLowestBin") && itemInfo.get("avgLowestBin").getAsLong() > 0L ? itemInfo.get("avgLowestBin").getAsLong() : (itemInfo.has("npcSell") && itemInfo.get("npcSell").getAsLong() > 1L ? itemInfo.get("npcSell").getAsLong() : 0L))));
    }

    private final class_1799 createItemStack(JsonObject itemObj) {
        Object object = class_7923.field_41178.method_63535(class_2960.method_60654((String)itemObj.get("id").getAsString()));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        class_1792 item = (class_1792)object;
        return new class_1799((class_1935)item, itemObj.get("count").getAsInt());
    }

    private final boolean dateShouldShow(String date, JsonArray trades) {
        if (((CharSequence)this.searchQuery).length() == 0) {
            return true;
        }
        if (StringsKt.contains((CharSequence)date, (CharSequence)this.searchQuery, (boolean)true)) {
            return true;
        }
        Iterable $this$forEach$iv = (Iterable)trades;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonElement tradeElement = (JsonElement)element$iv;
            boolean bl = false;
            JsonObject trade = tradeElement.getAsJsonObject();
            Intrinsics.checkNotNull((Object)trade);
            if (!this.matchesSearch(trade, date)) continue;
            return true;
        }
        return false;
    }

    private final boolean matchesSearch(JsonObject trade, String date) {
        if (((CharSequence)this.searchQuery).length() == 0) {
            return true;
        }
        if (StringsKt.contains((CharSequence)date, (CharSequence)this.searchQuery, (boolean)true)) {
            return true;
        }
        String string = trade.get("username").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
        if (StringsKt.contains((CharSequence)string, (CharSequence)this.searchQuery, (boolean)true)) {
            return true;
        }
        Object[] objectArray = new String[]{"yourItems", "theirItems"};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String itemsKey = (String)element$iv;
            boolean bl = false;
            JsonArray jsonArray = trade.getAsJsonArray(itemsKey);
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
            Iterable $this$forEach$iv2 = (Iterable)jsonArray;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                JsonElement itemElement = (JsonElement)element$iv2;
                boolean bl2 = false;
                String name = itemElement.getAsJsonObject().get("name").getAsString();
                if (!StringsKt.contains((CharSequence)Utils.INSTANCE.removeFormatting(name), (CharSequence)this.searchQuery, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    private final String abbreviateNumber(long num) {
        return num >= 1000000000000L ? this.format((double)num / 1.0E12) + "T" : (num >= 1000000000L ? this.format((double)num / 1.0E9) + "B" : (num >= 1000000L ? this.format((double)num / 1000000.0) + "M" : (num >= 1000L ? this.format((double)num / 1000.0) + "K" : String.valueOf(num))));
    }

    private final String format(double $this$format) {
        String string;
        if ($this$format == (double)((int)$this$format)) {
            string = String.valueOf((int)$this$format);
        } else {
            String string2 = "%.1f";
            Object[] objectArray = new Object[]{$this$format};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        }
        return string;
    }

    public void onMouseClick(int mouseX, int mouseY, int button2) {
        int searchX = this.field_22789 - (int)((float)this.field_22789 * 0.05f) - this.searchBoxWidth - this.padding;
        int searchY = (int)((float)this.field_22790 * 0.05f) + (this.headerHeight - this.searchBoxHeight) / 2;
        boolean bl = this.searchFocused = mouseX >= searchX && mouseX <= searchX + this.searchBoxWidth && mouseY >= searchY && mouseY <= searchY + this.searchBoxHeight;
        if (this.searchFocused) {
            this.searchCursorPos = this.searchQuery.length();
        }
    }

    public void onKeyType(char typedChar, int keyCode, int scanCode) {
        if (!this.searchFocused) {
            return;
        }
        if (keyCode == 259 && ((CharSequence)this.searchQuery).length() > 0) {
            this.searchQuery = StringsKt.dropLast((String)this.searchQuery, (int)1);
            this.searchCursorPos = this.searchQuery.length();
        } else if (keyCode == 257 || keyCode == 335) {
            this.searchFocused = false;
        } else if (Character.isLetterOrDigit(typedChar) || typedChar == ' ') {
            this.searchQuery = this.searchQuery + typedChar;
            this.searchCursorPos = this.searchQuery.length();
        }
    }

    public void onMouseScroll(double horizontal, double vertical) {
        if (this.currentScrollingDate != null && KnitKeyboard.isShiftKeyPressed()) {
            String string = this.currentScrollingDate;
            Intrinsics.checkNotNull((Object)string);
            String date = string;
            float maxHScroll = ((Number)this.maxHorizontalScrolls.getOrDefault(date, Float.valueOf(0.0f))).floatValue();
            if (maxHScroll > 0.0f) {
                float currentOffset = ((Number)this.horizontalScrollOffsets.getOrDefault(date, Float.valueOf(0.0f))).floatValue();
                this.horizontalScrollOffsets.put(date, Float.valueOf(RangesKt.coerceIn((float)(currentOffset - (float)horizontal * (float)20 - (float)vertical * (float)20), (float)0.0f, (float)maxHScroll)));
            }
            this.currentScrollingDate = null;
        } else {
            this.scrollOffset = RangesKt.coerceIn((float)(this.scrollOffset - (float)vertical * (float)20), (float)0.0f, (float)this.maxScroll);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0082\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\rJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012JH\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00022\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001a\u0010\u0017\u001a\u00020\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\rJ\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\rR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001d\u001a\u0004\b\u001f\u0010\rR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b \u0010\rR\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001d\u001a\u0004\b!\u0010\rR\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\"\u001a\u0004\b#\u0010\u0012\u00a8\u0006$"}, d2={"Lxyz/meowing/zen/features/hud/tradeHistory/TradeHistoryHUD$HoverElement;", "", "", "x", "y", "width", "height", "", "Lnet/minecraft/class_2561;", "tooltip", "<init>", "(IIIILjava/util/List;)V", "component1", "()I", "component2", "component3", "component4", "component5", "()Ljava/util/List;", "copy", "(IIIILjava/util/List;)Lxyz/meowing/zen/features/hud/tradeHistory/TradeHistoryHUD$HoverElement;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getX", "getY", "getWidth", "getHeight", "Ljava/util/List;", "getTooltip", "Zen"})
    private static final class HoverElement {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        @NotNull
        private final List<class_2561> tooltip;

        public HoverElement(int x, int y, int width, int height, @NotNull List<? extends class_2561> tooltip) {
            Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.tooltip = tooltip;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        @NotNull
        public final List<class_2561> getTooltip() {
            return this.tooltip;
        }

        public final int component1() {
            return this.x;
        }

        public final int component2() {
            return this.y;
        }

        public final int component3() {
            return this.width;
        }

        public final int component4() {
            return this.height;
        }

        @NotNull
        public final List<class_2561> component5() {
            return this.tooltip;
        }

        @NotNull
        public final HoverElement copy(int x, int y, int width, int height, @NotNull List<? extends class_2561> tooltip) {
            Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
            return new HoverElement(x, y, width, height, tooltip);
        }

        public static /* synthetic */ HoverElement copy$default(HoverElement hoverElement, int n, int n2, int n3, int n4, List list, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = hoverElement.x;
            }
            if ((n5 & 2) != 0) {
                n2 = hoverElement.y;
            }
            if ((n5 & 4) != 0) {
                n3 = hoverElement.width;
            }
            if ((n5 & 8) != 0) {
                n4 = hoverElement.height;
            }
            if ((n5 & 0x10) != 0) {
                list = hoverElement.tooltip;
            }
            return hoverElement.copy(n, n2, n3, n4, list);
        }

        @NotNull
        public String toString() {
            return "HoverElement(x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ", tooltip=" + this.tooltip + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.x);
            result = result * 31 + Integer.hashCode(this.y);
            result = result * 31 + Integer.hashCode(this.width);
            result = result * 31 + Integer.hashCode(this.height);
            result = result * 31 + ((Object)this.tooltip).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HoverElement)) {
                return false;
            }
            HoverElement hoverElement = (HoverElement)other;
            if (this.x != hoverElement.x) {
                return false;
            }
            if (this.y != hoverElement.y) {
                return false;
            }
            if (this.width != hoverElement.width) {
                return false;
            }
            if (this.height != hoverElement.height) {
                return false;
            }
            return Intrinsics.areEqual(this.tooltip, hoverElement.tooltip);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J8\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u000eJ\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001e\u001a\u0004\b\u001f\u0010\u000eR\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001e\u001a\u0004\b \u0010\u000eR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010!\u001a\u0004\b\"\u0010\u0011\u00a8\u0006#"}, d2={"Lxyz/meowing/zen/features/hud/tradeHistory/TradeHistoryHUD$ItemRender;", "", "Lnet/minecraft/class_1799;", "stack", "", "x", "y", "", "scale", "<init>", "(Lnet/minecraft/class_1799;IIF)V", "component1", "()Lnet/minecraft/class_1799;", "component2", "()I", "component3", "component4", "()F", "copy", "(Lnet/minecraft/class_1799;IIF)Lxyz/meowing/zen/features/hud/tradeHistory/TradeHistoryHUD$ItemRender;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_1799;", "getStack", "I", "getX", "getY", "F", "getScale", "Zen"})
    private static final class ItemRender {
        @NotNull
        private final class_1799 stack;
        private final int x;
        private final int y;
        private final float scale;

        public ItemRender(@NotNull class_1799 stack, int x, int y, float scale) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            this.stack = stack;
            this.x = x;
            this.y = y;
            this.scale = scale;
        }

        @NotNull
        public final class_1799 getStack() {
            return this.stack;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final float getScale() {
            return this.scale;
        }

        @NotNull
        public final class_1799 component1() {
            return this.stack;
        }

        public final int component2() {
            return this.x;
        }

        public final int component3() {
            return this.y;
        }

        public final float component4() {
            return this.scale;
        }

        @NotNull
        public final ItemRender copy(@NotNull class_1799 stack, int x, int y, float scale) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return new ItemRender(stack, x, y, scale);
        }

        public static /* synthetic */ ItemRender copy$default(ItemRender itemRender, class_1799 class_17992, int n, int n2, float f, int n3, Object object) {
            if ((n3 & 1) != 0) {
                class_17992 = itemRender.stack;
            }
            if ((n3 & 2) != 0) {
                n = itemRender.x;
            }
            if ((n3 & 4) != 0) {
                n2 = itemRender.y;
            }
            if ((n3 & 8) != 0) {
                f = itemRender.scale;
            }
            return itemRender.copy(class_17992, n, n2, f);
        }

        @NotNull
        public String toString() {
            return "ItemRender(stack=" + this.stack + ", x=" + this.x + ", y=" + this.y + ", scale=" + this.scale + ")";
        }

        public int hashCode() {
            int result = this.stack.hashCode();
            result = result * 31 + Integer.hashCode(this.x);
            result = result * 31 + Integer.hashCode(this.y);
            result = result * 31 + Float.hashCode(this.scale);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ItemRender)) {
                return false;
            }
            ItemRender itemRender = (ItemRender)other;
            if (!Intrinsics.areEqual((Object)this.stack, (Object)itemRender.stack)) {
                return false;
            }
            if (this.x != itemRender.x) {
                return false;
            }
            if (this.y != itemRender.y) {
                return false;
            }
            return Float.compare(this.scale, itemRender.scale) == 0;
        }
    }
}

