/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.storagebox;

import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1181;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_747;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.pitan76.storagebox.ModConfig;
import net.pitan76.storagebox.StorageBoxScreenHandler;
import net.pitan76.storagebox.StorageBoxUtil;

public class StorageBoxItem
extends class_1792 {
    public static String KEY_ITEM_ID = "StorageItem";
    public static String KEY_SIZE = "StorageSize";
    public static String KEY_AUTO = "StorageAuto";
    public static String KEY_ITEM_DATA = "StorageItemData";
    public static StorageBoxItem instance = new StorageBoxItem(new class_1792.class_1793());

    public static class_1792 getItem(class_1799 storageBoxStack) {
        class_1799 stack = StorageBoxItem.getStackInStorageBox(storageBoxStack);
        if (stack != null) {
            return stack.method_7909();
        }
        Optional<class_1792> item = StorageBoxItem.fixItemId(storageBoxStack);
        return item.orElse(null);
    }

    public static Optional<class_1792> fixItemId(class_1799 storageBoxStack) {
        int itemId = StorageBoxItem.getItemDataAsInt(storageBoxStack, KEY_ITEM_ID);
        if (itemId != 0 && StorageBoxItem.getItemDataAsInt(storageBoxStack, KEY_SIZE) > 0) {
            class_1792 item = class_7923.field_41178.method_10250(new class_2960(class_1181.method_5018((int)itemId))) ? (class_1792)class_7923.field_41178.method_10223(new class_2960(class_1181.method_5018((int)itemId))) : class_1792.method_7875((int)itemId);
            StorageBoxItem.setItemStack(storageBoxStack, new class_1799((class_1935)item));
            StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_ITEM_ID);
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public static boolean hasStackInStorageBox(class_1799 storageBoxStack) {
        return StorageBoxItem.getStackInStorageBox(storageBoxStack) != null;
    }

    public static class_1799 getStackInStorageBox(class_1799 storageBoxStack) {
        int oldDamage;
        String newId;
        String old;
        if (!storageBoxStack.method_7985()) {
            return null;
        }
        class_2487 nbt = storageBoxStack.method_7969();
        if (nbt.method_10545("item")) {
            StorageBoxItem.setItemStack(storageBoxStack, class_1799.method_7915((class_2487)nbt.method_10562("item")));
            if (nbt.method_10545("countInBox")) {
                StorageBoxItem.setItemStackSize(storageBoxStack, nbt.method_10550("countInBox"));
                nbt.method_10551("countInBox");
            }
            nbt.method_10551("item");
            storageBoxStack.method_7980(nbt);
        }
        if (nbt.method_10545(KEY_ITEM_ID)) {
            return StorageBoxItem.fixItemId(storageBoxStack).map(class_1799::new).orElse(null);
        }
        if (!nbt.method_10545(KEY_ITEM_DATA)) {
            return null;
        }
        if ((nbt = nbt.method_10562(KEY_ITEM_DATA)).method_33133()) {
            return null;
        }
        if (nbt.method_10573("Damage", 99) && !(old = nbt.method_10558("id")).equals(newId = StorageBoxUtil.oldItemIDtoNewItemID(old, oldDamage = Math.max(0, nbt.method_10568("Damage"))))) {
            nbt.method_10582("id", newId);
        }
        class_1799 result = class_1799.method_7915((class_2487)nbt);
        result.method_7939(1);
        return result;
    }

    public static int getItemDataAsInt(class_1799 storageBoxStack, String key) {
        int data = 0;
        class_2487 nbt = storageBoxStack.method_7969();
        if (nbt != null) {
            if (key.equals(KEY_SIZE) && nbt.method_10545("countInBox")) {
                return nbt.method_10550("countInBox");
            }
            data = nbt.method_10550(key);
        }
        if (key.equals(KEY_AUTO) && (nbt == null || !nbt.method_10545(key))) {
            Boolean defaultAutoCollect = ModConfig.getBoolean("DefaultAutoCollect");
            if (defaultAutoCollect == null) {
                return 0;
            }
            return defaultAutoCollect != false ? 0 : 1;
        }
        return data;
    }

    public static boolean isAutoCollect(class_1799 storageBoxStack) {
        class_2487 nbt;
        if (storageBoxStack.method_7985() && !(nbt = storageBoxStack.method_7969()).method_10545(KEY_AUTO) && nbt.method_10545("autoCollect")) {
            return nbt.method_10577("autoCollect");
        }
        return StorageBoxItem.getItemDataAsInt(storageBoxStack, KEY_AUTO) == 0;
    }

    public static void changeAutoCollect(class_1799 storageBoxStack) {
        int value = StorageBoxItem.isAutoCollect(storageBoxStack) ? 1 : 0;
        StorageBoxItem.setItemDataAsInt(storageBoxStack, KEY_AUTO, value);
    }

    public static void setItemDataAsInt(class_1799 storageBoxStack, String key, int data) {
        class_2487 stackNbt = storageBoxStack.method_7969();
        if (stackNbt == null) {
            stackNbt = new class_2487();
        }
        stackNbt.method_10569(key, data);
        storageBoxStack.method_7980(stackNbt);
    }

    public static void setItemDataAsInt(class_1799 storageBoxStack, String key, class_2487 nbt) {
        class_2487 stackNbt = storageBoxStack.method_7969();
        if (stackNbt == null) {
            stackNbt = new class_2487();
        }
        if (nbt != null) {
            stackNbt.method_10566(key, (class_2520)nbt);
        } else if (stackNbt.method_10545(key)) {
            stackNbt.method_10551(key);
        }
        storageBoxStack.method_7980(stackNbt);
    }

    public static void removeItemDataAsInt(class_1799 stack, String key) {
        StorageBoxItem.setItemDataAsInt(stack, key, null);
    }

    public static void setItemStack(class_1799 storageBoxStack, class_1799 newStack) {
        if (storageBoxStack == class_1799.field_8037) {
            return;
        }
        if (newStack == null || class_1799.field_8037 == newStack || newStack.method_7960()) {
            StorageBoxItem.setItemDataAsInt(storageBoxStack, KEY_ITEM_DATA, null);
            return;
        }
        class_2487 nbt = new class_2487();
        newStack.method_7953(nbt);
        StorageBoxItem.setItemDataAsInt(storageBoxStack, KEY_ITEM_DATA, nbt);
    }

    public static void setItemStackSize(class_1799 storageBoxStack, int size) {
        if (storageBoxStack == class_1799.field_8037) {
            return;
        }
        StorageBoxItem.setItemDataAsInt(storageBoxStack, KEY_SIZE, size);
    }

    public StorageBoxItem(class_1792.class_1793 settings) {
        super(settings.method_7889(1));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41060).register(entries -> entries.method_45421((class_1935)this));
    }

    public static void showBar(class_1657 player, class_1799 storageBoxStack) {
        if (StorageBoxItem.hasStackInStorageBox(storageBoxStack)) {
            class_1799 stack = StorageBoxItem.getStackInStorageBox(storageBoxStack);
            player.method_7353((class_2561)class_2561.method_43470((String)(stack.method_7964().getString() + "/" + StorageBoxItem.calcItemNumByUnit(StorageBoxItem.getItemDataAsInt(storageBoxStack, KEY_SIZE), true, stack.method_7914()))), true);
            return;
        }
        player.method_7353((class_2561)class_2561.method_43470((String)"Empty"), true);
    }

    public void dropItemStack(class_1309 entity, class_1799 itemstack) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            player.method_7328(itemstack.method_7972(), false);
            itemstack.method_7939(0);
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 storageBoxStack = user.method_5998(hand);
        if (StorageBoxItem.hasStackInStorageBox(storageBoxStack)) {
            int countInBox;
            class_1799 stack = StorageBoxItem.getStackInStorageBox(storageBoxStack);
            int stackMax = stack.method_7914();
            boolean canUse = true;
            int itemInBoxCount = countInBox = StorageBoxItem.getItemDataAsInt(storageBoxStack, KEY_SIZE);
            boolean countIsOverMax = false;
            if (countInBox > stackMax) {
                countIsOverMax = true;
                itemInBoxCount = stackMax;
                countInBox -= stackMax;
            }
            stack.method_7939(0);
            user.method_6122(hand, stack);
            stack.method_7939(itemInBoxCount);
            class_1271 result = stack.method_7913(world, user, hand);
            if (!result.equals(class_1271.method_22427((Object)stack)) || !result.equals(class_1271.method_22428((Object)stack))) {
                canUse = false;
            }
            int i = storageBoxStack.method_7947();
            storageBoxStack.method_7939(0);
            user.method_6122(hand, storageBoxStack);
            storageBoxStack.method_7939(i);
            if (result.method_5467() == class_1269.field_5814) {
                return new class_1271(result.method_5467(), (Object)storageBoxStack);
            }
            if (stack.method_7909().equals(((class_1799)result.method_5466()).method_7909())) {
                if (user.method_6115()) {
                    user.method_6075();
                    user.method_6019(hand);
                }
            } else {
                stack.method_7939(itemInBoxCount - 1);
                if (result.method_5467().equals((Object)class_1269.field_21466) || result.method_5466() != stack) {
                    class_1799 copyNewStack = ((class_1799)result.method_5466()).method_7972();
                    copyNewStack.method_7939(1);
                    user.method_31548().method_7398(copyNewStack);
                }
            }
            countInBox = countIsOverMax ? (countInBox += stack.method_7947()) : stack.method_7947();
            if (countInBox <= 0) {
                StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_SIZE);
                StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_ITEM_DATA);
                StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_ITEM_ID);
                StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_AUTO);
            } else {
                StorageBoxItem.setItemStackSize(storageBoxStack, countInBox);
            }
            return canUse ? class_1271.method_22427((Object)storageBoxStack) : class_1271.method_22430((Object)storageBoxStack);
        }
        if (!world.field_9236 && storageBoxStack.equals(user.method_6118(class_1304.field_6173))) {
            class_747 screenHandlerFactory = new class_747(StorageBoxScreenHandler::new, (class_2561)class_2561.method_43470((String)""));
            user.method_17355((class_3908)screenHandlerFactory);
        }
        return class_1271.method_22427((Object)storageBoxStack);
    }

    public class_1799 method_7861(class_1799 storageBoxStack, class_1937 world, class_1309 user) {
        class_1792 item = StorageBoxItem.getItem(storageBoxStack);
        if (item != null && StorageBoxItem.hasStackInStorageBox(storageBoxStack)) {
            class_1799 stack = StorageBoxItem.getStackInStorageBox(storageBoxStack).method_7972();
            int stackMax = stack.method_7914();
            stack.method_7939(stackMax);
            class_1799 result = item.method_7861(stack, world, user);
            if (!stack.method_7909().equals(result.method_7909())) {
                if (user instanceof class_1657) {
                    class_1657 playerEntity = (class_1657)user;
                    if (!playerEntity.method_31548().method_7394(result)) {
                        this.dropItemStack(user, result);
                    }
                } else {
                    this.dropItemStack(user, result);
                }
            }
            StorageBoxItem.setItemStackSize(storageBoxStack, StorageBoxItem.getItemDataAsInt(storageBoxStack, KEY_SIZE) - (stackMax - stack.method_7947()));
        }
        return super.method_7861(storageBoxStack, world, user);
    }

    public boolean method_7879(class_1799 storageBoxStack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        class_1792 item = StorageBoxItem.getItem(storageBoxStack);
        if (item != null && StorageBoxItem.hasStackInStorageBox(storageBoxStack)) {
            class_1799 stack = StorageBoxItem.getStackInStorageBox(storageBoxStack).method_7972();
            int stackMax = stack.method_7914();
            stack.method_7939(stackMax);
            boolean result = item.method_7879(stack, world, state, pos, miner);
            StorageBoxItem.setItemStackSize(storageBoxStack, StorageBoxItem.getItemDataAsInt(storageBoxStack, KEY_SIZE) - (stackMax - stack.method_7947()));
            return result;
        }
        return super.method_7879(storageBoxStack, world, state, pos, miner);
    }

    public class_1269 method_7847(class_1799 storageBoxStack, class_1657 user, class_1309 entity, class_1268 hand) {
        class_1269 result;
        class_1792 item = StorageBoxItem.getItem(storageBoxStack);
        if (item != null && StorageBoxItem.hasStackInStorageBox(storageBoxStack)) {
            class_1799 tempStack2;
            class_1799 tempStack1;
            int countInBox;
            class_1799 stack = StorageBoxItem.getStackInStorageBox(storageBoxStack).method_7972();
            int stackMax = stack.method_7914();
            int itemInBoxCount = countInBox = StorageBoxItem.getItemDataAsInt(storageBoxStack, KEY_SIZE);
            boolean countIsOverMax = false;
            if (countInBox > stackMax) {
                countIsOverMax = true;
                itemInBoxCount = stackMax;
                countInBox -= stackMax;
            }
            stack.method_7939(itemInBoxCount);
            class_1799 preStack = stack.method_7972();
            result = item.method_7847(stack, user, entity, hand);
            if (user.method_7337()) {
                tempStack1 = preStack.method_7972();
                tempStack1.method_7939(1);
                tempStack2 = stack.method_7972();
                tempStack2.method_7939(1);
                if (stack.method_7960() && !preStack.method_7960() || class_1799.method_7973((class_1799)tempStack1, (class_1799)tempStack2) && preStack.method_7947() != stack.method_7947()) {
                    stack = preStack.method_7972();
                }
            }
            if (!stack.method_7960()) {
                tempStack1 = preStack.method_7972();
                tempStack1.method_7939(1);
                tempStack2 = stack.method_7972();
                tempStack2.method_7939(1);
                if (!class_1799.method_7973((class_1799)tempStack1, (class_1799)tempStack2)) {
                    if (!user.method_31548().method_7394(stack)) {
                        this.dropItemStack((class_1309)user, stack);
                    }
                    stack.method_7939(0);
                }
            }
            countInBox = countIsOverMax ? (countInBox += stack.method_7947()) : stack.method_7947();
            if (countInBox <= 0) {
                StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_SIZE);
                StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_ITEM_DATA);
                StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_ITEM_ID);
                StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_AUTO);
            } else {
                StorageBoxItem.setItemStackSize(storageBoxStack, countInBox);
            }
        } else {
            result = super.method_7847(storageBoxStack, user, entity, hand);
        }
        return result;
    }

    public class_1839 method_7853(class_1799 storageBoxStack) {
        class_1839 result;
        class_1792 item = StorageBoxItem.getItem(storageBoxStack);
        if (item != null) {
            class_1799 stack = StorageBoxItem.getStackInStorageBox(storageBoxStack);
            result = item.method_7853(stack);
        } else {
            result = super.method_7853(storageBoxStack);
        }
        return result;
    }

    public int method_7881(class_1799 storageBoxStack) {
        class_1792 item = StorageBoxItem.getItem(storageBoxStack);
        if (item != null) {
            class_1799 stack = StorageBoxItem.getStackInStorageBox(storageBoxStack);
            return item.method_7881(stack);
        }
        return super.method_7881(storageBoxStack);
    }

    public void method_7840(class_1799 storageBoxStack, class_1937 world, class_1309 user, int remainingUseTicks) {
        class_1792 item = StorageBoxItem.getItem(storageBoxStack);
        if (item == null) {
            super.method_7840(storageBoxStack, world, user, remainingUseTicks);
            return;
        }
        class_1799 stack = StorageBoxItem.getStackInStorageBox(storageBoxStack).method_7972();
        int stackMax = stack.method_7914();
        stack.method_7939(stackMax);
        item.method_7840(stack, world, user, remainingUseTicks);
        StorageBoxItem.setItemStackSize(storageBoxStack, StorageBoxItem.getItemDataAsInt(storageBoxStack, KEY_SIZE) - (64 - stack.method_7947()));
    }

    public class_1269 method_7884(class_1838 context) {
        class_1268 hand;
        class_1657 user = context.method_8036();
        class_1799 storageBoxStack = user.method_5998(hand = context.method_20287());
        if (StorageBoxItem.hasStackInStorageBox(storageBoxStack)) {
            class_1799 tempStack2;
            class_1799 tempStack1;
            int countInBox;
            class_1799 stack = StorageBoxItem.getStackInStorageBox(storageBoxStack);
            int stackMax = stack.method_7914();
            boolean canUse = true;
            int itemInBoxCount = countInBox = StorageBoxItem.getItemDataAsInt(storageBoxStack, KEY_SIZE);
            boolean countIsOverMax = false;
            if (countInBox > stackMax) {
                countIsOverMax = true;
                itemInBoxCount = stackMax;
                countInBox -= stackMax;
            }
            stack.method_7939(0);
            user.method_6122(hand, stack);
            stack.method_7939(itemInBoxCount);
            class_1799 preStack = stack.method_7972();
            class_3965 hit = new class_3965(context.method_17698(), context.method_8038(), context.method_8037(), context.method_17699());
            class_1269 result = stack.method_7981(new class_1838(context.method_8045(), context.method_8036(), context.method_20287(), stack, hit));
            stack = context.method_8036().method_5998(context.method_20287());
            if (result != class_1269.field_5812) {
                canUse = false;
            }
            storageBoxStack.method_7939(0);
            user.method_6122(hand, storageBoxStack);
            storageBoxStack.method_7939(1);
            if (user.method_7337()) {
                tempStack1 = preStack.method_7972();
                tempStack1.method_7939(1);
                tempStack2 = stack.method_7972();
                tempStack2.method_7939(1);
                if (stack.method_7960() && !preStack.method_7960() || class_1799.method_7973((class_1799)tempStack1, (class_1799)tempStack2) && preStack.method_7947() != stack.method_7947()) {
                    stack = preStack.method_7972();
                }
            }
            if (!stack.method_7960()) {
                tempStack1 = preStack.method_7972();
                tempStack1.method_7939(1);
                tempStack2 = stack.method_7972();
                tempStack2.method_7939(1);
                if (!class_1799.method_7973((class_1799)tempStack1, (class_1799)tempStack2)) {
                    if (!user.method_31548().method_7394(stack)) {
                        this.dropItemStack((class_1309)user, stack);
                    }
                    stack.method_7939(0);
                }
            }
            countInBox = countIsOverMax ? (countInBox += stack.method_7947()) : stack.method_7947();
            if (countInBox <= 0) {
                StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_SIZE);
                StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_ITEM_DATA);
                StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_ITEM_ID);
                StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_AUTO);
            } else {
                StorageBoxItem.setItemStackSize(storageBoxStack, countInBox);
            }
            return canUse ? class_1269.field_5812 : class_1269.field_5811;
        }
        return super.method_7884(context);
    }

    public static void keyboardEvent(int type, class_1657 player, class_1799 storageBoxStack) {
        if (player.field_7512 instanceof StorageBoxScreenHandler) {
            return;
        }
        if (type == 0) {
            if (player.field_7512 != null && !(player.field_7512 instanceof class_1723) && player.field_7512.field_7761.size() > 0 && StorageBoxItem.hasStackInStorageBox(storageBoxStack)) {
                class_1799 itemInBox = StorageBoxItem.getStackInStorageBox(storageBoxStack);
                int count = StorageBoxItem.getItemDataAsInt(storageBoxStack, KEY_SIZE);
                for (class_1735 slot : player.field_7512.field_7761) {
                    class_1799 stack;
                    if (slot.field_7871 == player.method_31548() || !(stack = slot.method_7677()).method_7960()) continue;
                    class_1799 newStack = itemInBox.method_7972();
                    int stackMax = itemInBox.method_7914();
                    if (count > stackMax) {
                        newStack.method_7939(stackMax);
                        slot.method_48931(newStack);
                        count -= stackMax;
                        continue;
                    }
                    newStack.method_7939(count);
                    slot.method_48931(newStack);
                    StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_SIZE);
                    StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_ITEM_DATA);
                    StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_ITEM_ID);
                    StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_AUTO);
                    break;
                }
                StorageBoxItem.setItemStackSize(storageBoxStack, count);
                return;
            }
            if (StorageBoxItem.hasStackInStorageBox(storageBoxStack)) {
                class_1799 itemInBox = StorageBoxItem.getStackInStorageBox(storageBoxStack);
                int stackMax = itemInBox.method_7914();
                int count = StorageBoxItem.getItemDataAsInt(storageBoxStack, KEY_SIZE);
                class_1799 giveStack = itemInBox.method_7972();
                if (count > stackMax) {
                    giveStack.method_7939(stackMax);
                    if (StorageBoxItem.canGive((class_2371<class_1799>)player.method_31548().field_7547)) {
                        player.method_7270(giveStack);
                    } else {
                        player.method_7328(giveStack, false);
                    }
                    StorageBoxItem.setItemStackSize(storageBoxStack, count - stackMax);
                } else {
                    giveStack.method_7939(count);
                    if (StorageBoxItem.canGive((class_2371<class_1799>)player.method_31548().field_7547)) {
                        player.method_7270(giveStack);
                    } else {
                        player.method_7328(giveStack, false);
                    }
                    StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_SIZE);
                    StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_ITEM_DATA);
                    StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_ITEM_ID);
                    StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_AUTO);
                }
                return;
            }
        }
        if (type == 1 && StorageBoxItem.hasStackInStorageBox(storageBoxStack)) {
            class_1799 itemInBox = StorageBoxItem.getStackInStorageBox(storageBoxStack);
            int count = StorageBoxItem.getItemDataAsInt(storageBoxStack, KEY_SIZE);
            class_1799 dropStack = itemInBox.method_7972();
            int stackMax = itemInBox.method_7914();
            if (count > stackMax) {
                dropStack.method_7939(stackMax);
                player.method_7328(dropStack, false);
                StorageBoxItem.setItemStackSize(storageBoxStack, count - stackMax);
            } else {
                dropStack.method_7939(count);
                player.method_7328(dropStack, false);
                StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_SIZE);
                StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_ITEM_DATA);
                StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_ITEM_ID);
                StorageBoxItem.removeItemDataAsInt(storageBoxStack, KEY_AUTO);
            }
            return;
        }
        if (type == 2) {
            if (StorageBoxItem.hasStackInStorageBox(storageBoxStack) && !(player.field_7512 instanceof class_1723) && player.field_7512 != null) {
                class_1799 itemInBox = StorageBoxItem.getStackInStorageBox(storageBoxStack);
                int count = StorageBoxItem.getItemDataAsInt(storageBoxStack, KEY_SIZE);
                for (class_1735 slot : player.field_7512.field_7761) {
                    class_1799 stack;
                    if (slot.field_7871 == player.method_31548() || (stack = slot.method_7677()).method_7909() != itemInBox.method_7909() || !StorageBoxItem.canInsertStack(stack, storageBoxStack)) continue;
                    count += stack.method_7947();
                    player.method_31548().method_7378(stack);
                    stack.method_7939(0);
                    stack = class_1799.field_8037;
                    slot.method_48931(stack);
                }
                StorageBoxItem.setItemStackSize(storageBoxStack, count);
                return;
            }
            if (StorageBoxItem.hasStackInStorageBox(storageBoxStack)) {
                class_1799 itemInBox = StorageBoxItem.getStackInStorageBox(storageBoxStack);
                int count = StorageBoxItem.getItemDataAsInt(storageBoxStack, KEY_SIZE);
                for (class_1799 stack : player.method_31548().field_7547) {
                    if (stack.method_7909() != itemInBox.method_7909() || !StorageBoxItem.canInsertStack(stack, storageBoxStack)) continue;
                    count += stack.method_7947();
                    player.method_31548().method_7378(stack);
                    stack.method_7939(0);
                }
                StorageBoxItem.setItemStackSize(storageBoxStack, count);
                return;
            }
        }
        if (type == 3) {
            if (StorageBoxItem.isAutoCollect(storageBoxStack)) {
                StorageBoxItem.changeAutoCollect(storageBoxStack);
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a77[StorageBox] \u00a7cAutoCollect changed OFF"), false);
            } else {
                StorageBoxItem.changeAutoCollect(storageBoxStack);
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a77[StorageBox] \u00a7aAutoCollect changed ON"), false);
            }
        }
    }

    public void method_7851(class_1799 storageBoxStack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(storageBoxStack, world, tooltip, context);
        if (StorageBoxItem.hasStackInStorageBox(storageBoxStack)) {
            class_1792 item = StorageBoxItem.getItem(storageBoxStack);
            class_1799 stack = StorageBoxItem.getStackInStorageBox(storageBoxStack);
            int count = StorageBoxItem.getItemDataAsInt(storageBoxStack, KEY_SIZE);
            tooltip.add((class_2561)class_2561.method_43470((String)("\u00a77Name: " + stack.method_7909().method_7848().getString())));
            tooltip.add((class_2561)class_2561.method_43470((String)("\u00a77Unit: " + StorageBoxItem.calcItemNumByUnit(count, false, stack.method_7914()))));
            tooltip.add((class_2561)class_2561.method_43470((String)("\u00a77Items: " + count)));
            tooltip.add((class_2561)class_2561.method_43470((String)("\u00a77AutoCollect: " + (StorageBoxItem.isAutoCollect(storageBoxStack) ? "ON" : "OFF"))));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77[Information]"));
            if (item != null) {
                item.method_7851(stack, world, tooltip, context);
            }
        }
    }

    public static StringBuilder calcItemNumByUnit(int count, boolean appendItemNum, int maxStackCount) {
        StringBuilder sb = new StringBuilder("Empty");
        sb.setLength(0);
        int LCNUM = 54 * maxStackCount;
        int n = count;
        int i = n / LCNUM;
        boolean isHigherUnit = false;
        if (i >= 1) {
            isHigherUnit = true;
            sb.append(i).append("LC");
            n -= i * LCNUM;
        }
        if ((i = n / maxStackCount) >= 1) {
            isHigherUnit = true;
            if (sb.length() >= 1) {
                sb.append('+');
            }
            sb.append(i).append("stacks");
            n -= i * maxStackCount;
        }
        if (n >= 1) {
            if (sb.length() >= 1) {
                sb.append('+');
            }
            sb.append(n).append("items");
        }
        if (isHigherUnit && appendItemNum) {
            sb.append('(').append(count).append("items)");
        }
        return sb;
    }

    public static boolean canGive(class_2371<class_1799> inv) {
        for (class_1799 stack : inv) {
            if (!stack.method_7960()) continue;
            return true;
        }
        return false;
    }

    public static boolean canInsertStack(class_1799 stack) {
        if (stack.method_7909() == instance) {
            return false;
        }
        if (stack.method_7923()) {
            return false;
        }
        return !stack.method_7963();
    }

    public static boolean canInsertStack(class_1799 stack, class_1799 storageBoxStack) {
        if (stack.method_7909() == instance) {
            return false;
        }
        if (stack.method_7923()) {
            return false;
        }
        if (stack.method_7963()) {
            return false;
        }
        if (stack.method_7985()) {
            class_1799 stackInBox = StorageBoxItem.getStackInStorageBox(storageBoxStack);
            if (stackInBox == null || stackInBox.method_7960()) {
                return false;
            }
            if (!stackInBox.method_7985()) {
                return false;
            }
            if (!stackInBox.method_7969().equals((Object)stack.method_7969())) {
                return false;
            }
        }
        return true;
    }
}

