/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.storagebox.mixin;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_2480;
import net.minecraft.class_3468;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.pitan76.storagebox.DataComponentTypes;
import net.pitan76.storagebox.ModConfig;
import net.pitan76.storagebox.StorageBoxItem;
import net.pitan76.storagebox.mixin.ItemEntityAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1542.class})
public class ItemPickupMixin {
    @Unique
    private static boolean process(class_1799 stack, class_1799 pickupStack) {
        class_9323 components;
        Boolean supportShulkerBox;
        Boolean supportSimpleBackpack;
        if (stack.method_7909() instanceof StorageBoxItem) {
            if (!StorageBoxItem.isAutoCollect(stack)) {
                return false;
            }
            class_1799 stackInNbt = StorageBoxItem.getStackInStorageBox(stack);
            if (stackInNbt == null) {
                return false;
            }
            if (stackInNbt.method_7909() == pickupStack.method_7909()) {
                if (!StorageBoxItem.canInsertStack(pickupStack, stack)) {
                    return false;
                }
                StorageBoxItem.setItemStackSize(stack, StorageBoxItem.getComponentAsInt(stack, DataComponentTypes.ITEM_COUNT) + pickupStack.method_7947());
                return true;
            }
        }
        if ((supportSimpleBackpack = ModConfig.getBoolean("SupportSimpleBackpack")) == null) {
            supportSimpleBackpack = true;
        }
        if ((supportShulkerBox = ModConfig.getBoolean("SupportShulkerBox")) == null) {
            supportShulkerBox = true;
        }
        if (supportShulkerBox.booleanValue() && stack.method_7909() instanceof class_1747 && ((class_1747)stack.method_7909()).method_7711() instanceof class_2480 && (components = stack.method_57353()).method_57832(class_9334.field_49622)) {
            class_9288 component = (class_9288)components.method_58694(class_9334.field_49622);
            class_2371 items = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
            component.method_57492(items);
            for (int i = 0; i < items.size(); ++i) {
                class_1799 inStack = (class_1799)items.get(i);
                if (!ItemPickupMixin.process(inStack, pickupStack)) continue;
                items.set(i, (Object)inStack);
                stack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493((List)items));
                return true;
            }
        }
        return false;
    }

    @Inject(method={"onPlayerCollision"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPickup(class_1657 player, CallbackInfo ci) {
        class_1542 itemEntity = (class_1542)this;
        Boolean supportEnderChest = ModConfig.getBoolean("SupportEnderChest");
        if (supportEnderChest == null) {
            supportEnderChest = true;
        }
        if (!itemEntity.method_73183().method_8608()) {
            class_1799 itemStack = itemEntity.method_6983();
            class_1792 item = itemStack.method_7909();
            int count = itemStack.method_7947();
            if (((ItemEntityAccessor)itemEntity).getPickupDelay() == 0 && (((ItemEntityAccessor)itemEntity).getOwner() == null || ((ItemEntityAccessor)itemEntity).getOwner().equals(player.method_5667()))) {
                boolean insertedBox = false;
                boolean checkedEnderChest = false;
                for (class_1799 inStack : player.method_31548().method_67533()) {
                    if (supportEnderChest.booleanValue() && inStack.method_7909() == class_1802.field_8466 && !checkedEnderChest) {
                        for (class_1799 enderChestStack : player.method_7274().method_54454()) {
                            if (enderChestStack.method_57353().method_57837() || !ItemPickupMixin.process(enderChestStack, itemStack)) continue;
                            insertedBox = true;
                            itemStack = class_1799.field_8037;
                            checkedEnderChest = true;
                            break;
                        }
                    }
                    if (inStack.method_57353().method_57837() || !ItemPickupMixin.process(inStack, itemStack)) continue;
                    insertedBox = true;
                    itemStack = class_1799.field_8037;
                    break;
                }
                if (!insertedBox && !player.method_6079().method_57353().method_57837() && ItemPickupMixin.process(player.method_6079(), itemStack)) {
                    insertedBox = true;
                    itemStack = class_1799.field_8037;
                }
                if (insertedBox) {
                    player.method_6103((class_1297)itemEntity, count);
                    if (itemStack.method_7960()) {
                        itemEntity.method_31472();
                        itemStack.method_7939(count);
                    }
                    player.method_7342(class_3468.field_15392.method_14956((Object)item), count);
                    player.method_29499(itemEntity);
                    ci.cancel();
                }
            }
        }
    }
}

