/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.storagebox;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    public static File dir = FabricLoader.getInstance().getConfigDir().toFile();
    public static File file = new File(dir, "storagebox.json");
    private static Map<String, Object> configMap = new LinkedHashMap<String, Object>();

    public static void init() {
        ModConfig.setDefault();
        if (!ModConfig.load()) {
            ModConfig.save();
        }
    }

    public static boolean save() {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(configMap);
        return ModConfig.fileWriteContents(file, json);
    }

    public static boolean load() {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (file.exists()) {
            String json = ModConfig.fileReadContents(file);
            Gson gson = new Gson();
            Type jsonMap = new TypeToken<LinkedHashMap<String, Object>>(){}.getType();
            configMap = (Map)gson.fromJson(json, jsonMap);
            return true;
        }
        return false;
    }

    public static void setDefault() {
        ModConfig.setBoolean("DefaultAutoCollect", true);
        ModConfig.setBoolean("SupportEnderChest", true);
        ModConfig.setBoolean("SupportShulkerBox", true);
        ModConfig.setBoolean("SupportSimpleBackpack", true);
    }

    public static Object get(String key) {
        return configMap.get(key);
    }

    public static void setBoolean(String key, boolean value) {
        configMap.put(key, value);
    }

    public static void setInt(String key, int value) {
        configMap.put(key, value);
    }

    public static void setString(String key, String value) {
        configMap.put(key, value);
    }

    public static Boolean getBoolean(String key) {
        Object value = ModConfig.get(key);
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            return i != 0;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.getBoolean((String)value);
        }
        return null;
    }

    public static Integer getInt(String key) {
        Object value = ModConfig.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.getInteger((String)value);
        }
        return null;
    }

    public static String getString(String key) {
        Object value = ModConfig.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static Map<String, Object> getConfigMap() {
        return configMap;
    }

    public static boolean fileWriteContents(File file, String contents) {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            writer.println(contents);
            writer.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String fileReadContents(File file) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            StringBuilder contents = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                contents.append(line).append("\n");
            }
            reader.close();
            return contents.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

