/*
 * Decompiled with CFR 0.152.
 */
package io.github.smootheez.dnp.handler;

import io.github.smootheez.dnp.config.DnpConfig;
import io.github.smootheez.dnp.particle.TextParticle;
import io.github.smootheez.smoothiezapi.config.ConfigManager;
import io.github.smootheez.smoothiezapi.config.OptionList;
import io.github.smootheez.smoothiezapi.util.ColorUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4066;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_746;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public final class HandleTextParticle {
    private static final class_310 MINECRAFT = class_310.method_1551();
    private static final Deque<TextParticle> PARTICLES = new ArrayDeque<TextParticle>();
    private static final DnpConfig DNP_CONFIG = (DnpConfig)ConfigManager.getConfig(DnpConfig.class);
    private static final Map<class_1309, Float> LAST_HEALTH_MAP = new WeakHashMap<class_1309, Float>();

    private HandleTextParticle() {
    }

    public static void onHealthChange(class_1309 entity) {
        if (Boolean.FALSE.equals(DNP_CONFIG.getEnableDnp().getValue())) {
            return;
        }
        float newHealth = entity.method_6032();
        Float oldHealth = LAST_HEALTH_MAP.get(entity);
        if (oldHealth != null && oldHealth.floatValue() != newHealth) {
            HandleTextParticle.renderParticleNumber(entity, oldHealth.floatValue(), newHealth);
        }
        LAST_HEALTH_MAP.put(entity, Float.valueOf(newHealth));
    }

    private static void renderParticleNumber(class_1309 entity, float oldHealth, float newHealth) {
        int color;
        if (Boolean.FALSE.equals(DNP_CONFIG.getEnableDnp().getValue())) {
            return;
        }
        class_638 level = (class_638)entity.method_73183();
        if (HandleTextParticle.shouldSkipRendering(entity)) {
            return;
        }
        HandleTextParticle.ensureParticleLimit();
        float bbHeight = entity.method_17682();
        double yOffset = class_3532.method_15350((double)((double)bbHeight * 0.55), (double)1.0, (double)4.0);
        class_243 position = entity.method_73189().method_1031(0.0, yOffset, 0.0);
        class_243 velocity = HandleTextParticle.computeVelocity(level, entity, position);
        float diff = oldHealth - newHealth;
        if (diff == 0.0f) {
            return;
        }
        float baseScale = 0.023f;
        float scaleMultiplier = class_3532.method_15355((float)bbHeight);
        float scaled = baseScale * scaleMultiplier;
        float amount = Math.abs(diff);
        float maxChange = ((Double)DNP_CONFIG.getDamageThreshold().getValue()).floatValue();
        float intensity = class_3532.method_15363((float)(amount / maxChange), (float)0.0f, (float)1.0f);
        int yellow = 0xFFFF00;
        int red = 0xFF0000;
        int green = 65280;
        Object healthChangeValue = String.format("%.1f", Float.valueOf(amount));
        if (diff > 0.0f) {
            color = ColorUtils.lerpRGB((int)yellow, (int)red, (float)intensity);
            healthChangeValue = "-" + (String)healthChangeValue;
        } else {
            color = ColorUtils.lerpRGB((int)yellow, (int)green, (float)intensity);
            healthChangeValue = "+" + (String)healthChangeValue;
        }
        TextParticle particle = new TextParticle(level, position, velocity, (String)healthChangeValue, class_3532.method_15363((float)scaled, (float)0.02f, (float)0.045f), color);
        PARTICLES.add(particle);
        HandleTextParticle.MINECRAFT.field_1713.method_3058((class_703)particle);
    }

    private static boolean shouldSkipRendering(class_1309 entity) {
        class_746 player = HandleTextParticle.MINECRAFT.field_1724;
        if (entity == player && Boolean.TRUE.equals(DNP_CONFIG.getSelfParticle().getValue())) {
            return true;
        }
        class_2960 entityType = class_7923.field_41177.method_10221((Object)entity.method_5864());
        if (((OptionList)DNP_CONFIG.getBlacklist().getValue()).values().contains(entityType.toString())) {
            return true;
        }
        int maxDistance = (Integer)DNP_CONFIG.getParticleRadius().getValue();
        return entity.method_5858((class_1297)player) > (double)(maxDistance * maxDistance);
    }

    private static void ensureParticleLimit() {
        int particleLimit;
        switch ((class_4066)HandleTextParticle.MINECRAFT.field_1690.method_42475().method_41753()) {
            default: {
                throw new MatchException(null, null);
            }
            case field_18197: {
                int n = 255;
                break;
            }
            case field_18198: {
                int n = 127;
                break;
            }
            case field_18199: {
                int n = particleLimit = 63;
            }
        }
        while (PARTICLES.size() > particleLimit) {
            TextParticle oldestParticle = PARTICLES.poll();
            if (oldestParticle == null) continue;
            oldestParticle.method_3085();
        }
    }

    private static class_243 computeVelocity(class_638 level, class_1309 entity, class_243 particlePos) {
        if (level == null) {
            return class_243.field_1353;
        }
        double spread = 0.05;
        double randomX = (level.field_9229.method_43058() - 0.5) * spread;
        double randomZ = (level.field_9229.method_43058() - 0.5) * spread;
        double upward = 0.1;
        class_243 velocity = new class_243(randomX, upward, randomZ);
        class_243 backward = HandleTextParticle.MINECRAFT.field_1773.method_19418().method_19326().method_1020(particlePos).method_1029().method_1021((double)entity.method_17681() * 0.5);
        return velocity.method_1031(backward.field_1352, 0.1, backward.field_1350);
    }
}

