/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.client.hint;

import com.mojang.blaze3d.platform.Window;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import tnt.tarkovcraft.core.client.hint.OnScreenHint;

public class LabelOnScreenHint
implements OnScreenHint {
    private final Component label;

    public LabelOnScreenHint(Component label) {
        this.label = Objects.requireNonNull(label);
    }

    @Override
    public void render(GuiGraphics graphics, Font font, Window window, int x, int y, int width, int height, float delta) {
        graphics.drawString(font, this.label, x, y + this.getHeightOffset(), this.getTextColor(), this.enableTextShadow());
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    public boolean isAdvanced() {
        return false;
    }

    @Override
    public void onHintUpdate() {
    }

    @Override
    public int getHintWidth(Window window, Font font) {
        return font.width((FormattedText)this.label);
    }

    @Override
    public int getHintHeight(Window window, Font font) {
        return 15;
    }

    protected boolean enableTextShadow() {
        return false;
    }

    protected int getTextColor() {
        return -1;
    }

    protected int getHeightOffset() {
        return 3;
    }
}

