/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.client.screen.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import tnt.tarkovcraft.core.util.helper.RenderUtils;

public class EntityWidget
extends AbstractWidget {
    private final LivingEntity entity;
    private Vector3f offset;
    private Quaternionf pose;
    private Quaternionf camera;
    private int background;

    public EntityWidget(int x, int y, int width, int height, LivingEntity entity) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.entity = entity;
        this.offset = new Vector3f();
        this.pose = new Quaternionf().rotateZ((float)Math.PI);
        this.camera = new Quaternionf().rotateX((float)Math.toRadians(-15.0));
        this.pose.mul((Quaternionfc)this.camera);
    }

    public void setBackground(int background) {
        this.background = background;
    }

    public void setOffset(Vector3f offset) {
        this.offset = offset;
    }

    public void setOffset(float x, float y, float z) {
        this.offset = new Vector3f(x, y, z);
    }

    public void setPose(Quaternionf pose) {
        this.pose = pose;
    }

    public void setCamera(Quaternionf camera) {
        this.camera = camera;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.enableScissor(this.getX(), this.getY(), this.getRight(), this.getBottom());
        if (RenderUtils.isVisibleColor(this.background)) {
            guiGraphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), this.background);
        }
        float yBodyRot = this.entity.yBodyRot;
        float yRot = this.entity.getYRot();
        float xRot = this.entity.getXRot();
        float yHeadRotO = this.entity.yHeadRotO;
        float yHeadRot = this.entity.yHeadRot;
        this.entity.setYRot(0.0f);
        this.entity.setXRot(-10.0f);
        this.entity.setYBodyRot(160.0f);
        this.entity.setYHeadRot(180.0f);
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (int)this.getX(), (int)this.getY(), (int)this.getRight(), (int)this.getBottom(), (float)((float)Math.min(this.width, this.height) / 3.0f), (Vector3f)this.offset, (Quaternionf)this.pose, (Quaternionf)this.camera, (LivingEntity)this.entity);
        this.entity.yBodyRot = yBodyRot;
        this.entity.setYRot(yRot);
        this.entity.setXRot(xRot);
        this.entity.yHeadRotO = yHeadRotO;
        this.entity.yHeadRot = yHeadRot;
        guiGraphics.disableScissor();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return false;
    }
}

