/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common;

import java.util.Objects;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import tnt.tarkovcraft.core.TarkovCraftCore;
import tnt.tarkovcraft.core.network.message.notification.S2C_SendNotification;

public final class Notification {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Notification");
    public static final int DEFAULT_LIFETIME = 100;
    public static final StreamCodec<RegistryFriendlyByteBuf, Notification> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(Severity.class), Notification::getSeverity, (StreamCodec)ComponentSerialization.STREAM_CODEC, Notification::getLabel, (StreamCodec)ResourceLocation.STREAM_CODEC, Notification::getIcon, (StreamCodec)ByteBufCodecs.INT, Notification::getLifetime, Notification::new);
    private final Severity notificationSeverity;
    private final Component label;
    private int lifetime;
    private ResourceLocation customIcon;

    private Notification(Severity notificationSeverity, Component label, ResourceLocation icon, int lifetime) {
        this.notificationSeverity = Objects.requireNonNull(notificationSeverity);
        this.label = Objects.requireNonNull(label);
        this.customIcon = icon;
        this.lifetime = lifetime;
    }

    public static Notification of(Severity severity, Component label, int lifetime) {
        return new Notification(severity, label, null, lifetime);
    }

    public static Notification info(Component label) {
        return Notification.of(Severity.INFO, label, 100);
    }

    public static Notification warn(Component label) {
        return Notification.of(Severity.WARNING, label, 100);
    }

    public static Notification error(Component label) {
        return Notification.of(Severity.ERROR, label, 100);
    }

    public static Notification success(Component label) {
        return Notification.of(Severity.SUCCESS, label, 100);
    }

    public static Notification system(Component label) {
        return Notification.of(Severity.SYSTEM, label, 100);
    }

    public void send(ServerPlayer target) {
        TarkovCraftCore.LOGGER.debug(MARKER, "Sending {} notification to {} - {}", (Object)this.notificationSeverity, (Object)target.getName().getString(), (Object)this.label.getString());
        PacketDistributor.sendToPlayer((ServerPlayer)target, (CustomPacketPayload)new S2C_SendNotification(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public Severity getSeverity() {
        return this.notificationSeverity;
    }

    public Component getLabel() {
        return this.label;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setIcon(ResourceLocation customIcon) {
        this.customIcon = customIcon;
    }

    public ResourceLocation getIcon() {
        return this.customIcon != null ? this.customIcon : this.notificationSeverity.getIcon();
    }

    public static enum Severity implements UnaryOperator<Style>
    {
        SYSTEM(style -> style.withItalic(Boolean.valueOf(true)).applyFormat(ChatFormatting.AQUA)),
        SUCCESS(style -> style.withColor(ChatFormatting.GREEN)),
        INFO(style -> style.applyFormat(ChatFormatting.WHITE)),
        WARNING(style -> style.applyFormat(ChatFormatting.YELLOW)),
        ERROR(style -> style.applyFormat(ChatFormatting.RED));

        private final UnaryOperator<Style> labelStylization;
        private final ResourceLocation icon;

        private Severity(UnaryOperator<Style> labelStylization) {
            this.labelStylization = labelStylization;
            this.icon = TarkovCraftCore.createResourceLocation("textures/icons/notification/" + this.name().toLowerCase() + ".png");
        }

        public ResourceLocation getIcon() {
            return this.icon;
        }

        @Override
        public Style apply(Style style) {
            return (Style)this.labelStylization.apply(style);
        }
    }
}

