/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.attribute.modifier;

import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.UUID;
import tnt.tarkovcraft.core.common.attribute.AttributeInstance;
import tnt.tarkovcraft.core.common.attribute.modifier.AddValueModifier;
import tnt.tarkovcraft.core.common.attribute.modifier.AttributeModifierType;
import tnt.tarkovcraft.core.common.attribute.modifier.MultiplyValueAttributeModifier;
import tnt.tarkovcraft.core.common.attribute.modifier.SetValueAttributeModifier;
import tnt.tarkovcraft.core.common.init.CoreRegistries;

public abstract class AttributeModifier {
    public static final Codec<AttributeModifier> CODEC = CoreRegistries.ATTRIBUTE_MODIFIER.byNameCodec().dispatch(AttributeModifier::getType, AttributeModifierType::codec);
    public static final int ORDER_MATH_PARENTHESES = 100;
    public static final int ORDER_MATH_EXP = 200;
    public static final int ORDER_MATH_MULTIPLICATION = 300;
    public static final int ORDER_MATH_ADDITION = 400;
    private final UUID identifier;

    protected AttributeModifier(UUID identifier) {
        this.identifier = identifier;
    }

    public static SetValueAttributeModifier set(UUID id, double value) {
        return new SetValueAttributeModifier(id, value);
    }

    public static SetValueAttributeModifier set(String uuid, double value) {
        return AttributeModifier.set(UUID.fromString(uuid), value);
    }

    public static AddValueModifier add(UUID id, double value) {
        return new AddValueModifier(id, value);
    }

    public static AddValueModifier add(String uuid, double value) {
        return AttributeModifier.add(UUID.fromString(uuid), value);
    }

    public static AddValueModifier subtract(UUID id, double value) {
        return new AddValueModifier(id, -value);
    }

    public static AddValueModifier subtract(String uuid, double value) {
        return AttributeModifier.subtract(UUID.fromString(uuid), value);
    }

    public static MultiplyValueAttributeModifier multiplier(UUID id, double multiplier) {
        return new MultiplyValueAttributeModifier(id, multiplier);
    }

    public static MultiplyValueAttributeModifier multiplier(String uuid, double multiplier) {
        return AttributeModifier.multiplier(UUID.fromString(uuid), multiplier);
    }

    public static MultiplyValueAttributeModifier multiplyBase(UUID id, double multiplier) {
        return new MultiplyValueAttributeModifier(id, 1.0 + multiplier);
    }

    public static MultiplyValueAttributeModifier multiplyBase(String uuid, double multiplier) {
        return AttributeModifier.multiplyBase(UUID.fromString(uuid), multiplier);
    }

    public abstract double calculateValue(AttributeInstance var1, double var2);

    public abstract int ordering();

    public abstract AttributeModifierType<?> getType();

    public final UUID identifier() {
        return this.identifier;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof AttributeModifier)) {
            return false;
        }
        AttributeModifier modifier = (AttributeModifier)o;
        return Objects.equals(this.identifier, modifier.identifier);
    }

    public final int hashCode() {
        return Objects.hashCode(this.identifier);
    }
}

