/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.compatibility;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.util.Lazy;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import tnt.tarkovcraft.core.TarkovCraftCore;

public final class Component<T> {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Compatibility");
    private final String name;
    private Set<ComponentHolder<T>> holders;
    private final T defaultComponent;
    private final Lazy<T> component;
    private boolean isVanilla = true;

    public Component(String name, T defaultComponent) {
        this.name = name;
        this.holders = new LinkedHashSet<ComponentHolder<T>>();
        this.defaultComponent = defaultComponent;
        this.component = Lazy.of(() -> {
            ArrayList<ComponentHolder<T>> components = new ArrayList<ComponentHolder<T>>(this.holders);
            components.sort(Comparator.comparingInt(ComponentHolder::order));
            for (ComponentHolder<T> holder : this.holders) {
                if (!holder.loadPredicate.getAsBoolean()) continue;
                Object value = holder.componentProvider.get();
                this.holders = null;
                this.isVanilla = false;
                TarkovCraftCore.LOGGER.warn(MARKER, "Detected component {} override, will use component {}", (Object)name, value);
                return value;
            }
            this.holders = null;
            TarkovCraftCore.LOGGER.info(MARKER, "No override found for component {} will use default component {}", (Object)name, defaultComponent);
            return defaultComponent;
        });
    }

    public boolean isVanilla() {
        return this.isVanilla;
    }

    public synchronized void register(BooleanSupplier predicate, Supplier<T> provider, int order) {
        if (this.holders == null) {
            throw new IllegalStateException("Component registration is not possible at this stage");
        }
        this.holders.add(new ComponentHolder<T>(predicate, order, provider));
    }

    public synchronized void register(BooleanSupplier predicate, Supplier<T> provider) {
        this.register(predicate, provider, 0);
    }

    public synchronized void register(String modId, Supplier<T> provider, int order) {
        this.register(() -> ModList.get().isLoaded(modId), provider, order);
    }

    public synchronized void register(String modId, Supplier<T> provider) {
        this.register(modId, provider, 0);
    }

    public T getComponent() {
        return (T)this.component.get();
    }

    public T getDefaultComponent() {
        return this.defaultComponent;
    }

    public void invalidate() {
        this.component.invalidate();
        TarkovCraftCore.LOGGER.debug(MARKER, "Component '{}' invalidated", (Object)this.name);
    }

    public String toString() {
        return "Component{name='" + this.name + "',component=" + this.component.get().getClass().getSimpleName() + ",vanilla=" + this.isVanilla + "}";
    }

    public record ComponentHolder<T>(BooleanSupplier loadPredicate, int order, Supplier<T> componentProvider) {
    }
}

