/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.util;

import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.util.Mth;

public enum Easing implements UnaryOperator<Float>
{
    LINEAR(FloatUnaryOperator.identity()),
    EASE_IN_SINE(f -> 1.0f - Mth.cos((float)((float)((double)f * Math.PI) / 2.0f))),
    EASE_OUT_SINE(f -> Mth.sin((float)((float)((double)f * Math.PI) / 2.0f))),
    EASE_IN_OUT_SINE(f -> -(Mth.cos((float)((float)(Math.PI * (double)f) - 1.0f)) / 2.0f));

    private final FloatUnaryOperator easing;

    private Easing(FloatUnaryOperator easing) {
        this.easing = easing;
    }

    @Override
    public Float apply(Float aFloat) {
        return Float.valueOf(this.ease(aFloat.floatValue()));
    }

    public float ease(float in) {
        return this.easing.apply(in);
    }

    public static float ease(float in, Function<Float, Float> easingFunction) {
        return easingFunction.apply(Float.valueOf(in)).floatValue();
    }
}

