/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.client.screen;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import tnt.tarkovcraft.core.client.screen.navigation.CoreNavigators;
import tnt.tarkovcraft.core.client.screen.navigation.NavigationEntry;
import tnt.tarkovcraft.core.client.screen.renderable.LabelRenderable;
import tnt.tarkovcraft.core.client.screen.renderable.NotificationScreen;
import tnt.tarkovcraft.core.client.screen.renderable.VerticalLineRenderable;
import tnt.tarkovcraft.core.client.screen.widget.HorizontalNavigationMenu;
import tnt.tarkovcraft.core.client.screen.widget.LabelButton;

public abstract class CharacterSubScreen
extends NotificationScreen {
    protected final UUID characterProfileId;
    protected final NavigationEntry selectedPage;
    protected boolean isMyProfile;

    public CharacterSubScreen(UUID characterProfileId, NavigationEntry selectedPage) {
        super(selectedPage.label());
        this.characterProfileId = characterProfileId;
        this.selectedPage = selectedPage;
    }

    protected Optional<Player> getPlayer() {
        return Optional.ofNullable(this.minecraft.level.getPlayerByUUID(this.characterProfileId));
    }

    protected void init() {
        this.isMyProfile = this.minecraft.player.getUUID().equals(this.characterProfileId);
        this.addHeader();
    }

    protected void addHeader() {
        PlayerInfo info = this.minecraft.getConnection().getPlayerInfo(this.characterProfileId);
        String name = info != null ? info.getProfile().getName() : "???";
        MutableComponent title = Component.translatable((String)"label.tarkovcraft_core.profile", (Object[])new Object[]{name});
        int titleWidth = this.font.width((FormattedText)title);
        LabelRenderable titleLabel = (LabelRenderable)this.addRenderableOnly(LabelRenderable.fromComponent(5, 8, titleWidth, 10, this.font, (Component)title));
        titleLabel.setScrolling(false);
        this.addRenderableOnly(new VerticalLineRenderable(10 + titleWidth, 5, 19, -2039584));
        this.addRenderableWidget((GuiEventListener)new HorizontalNavigationMenu<AbstractWidget>(15 + titleWidth, 0, this.width - 30 - titleWidth, 25, (Screen)this, this.characterProfileId, CoreNavigators.CHARACTER_NAVIGATION_PROVIDER, (entry, parent, userId) -> this.buildNavItem(entry)));
    }

    protected AbstractWidget buildNavItem(NavigationEntry entry) {
        Component title = entry.label();
        int itemWidth = this.font.width((FormattedText)title);
        LabelButton button = new LabelButton(Button.builder((Component)title, b -> this.minecraft.setScreen(entry.getScreen(this, this.characterProfileId))).size(itemWidth + 4, 15).pos(0, 5));
        button.active = entry != this.selectedPage;
        button.setBackgroundHoverColor(0);
        button.setColorSelected(-1);
        button.setColorDisabled(-256);
        button.setColor(-2039584);
        return button;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBlurredBackground(partialTick);
        guiGraphics.fill(0, 0, this.width, this.height, 0x66000000);
        guiGraphics.fill(0, 0, this.width, 25, 0x44000000);
    }
}

