/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.client.screen.renderable;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import tnt.tarkovcraft.core.client.IconWithLabel;
import tnt.tarkovcraft.core.client.screen.renderable.AbstractRenderable;
import tnt.tarkovcraft.core.util.HorizontalAlignment;
import tnt.tarkovcraft.core.util.helper.RenderUtils;

public class IconWithLabelRenderable
extends AbstractRenderable {
    private final Font font;
    private final IconWithLabel iconWithLabel;
    private final HorizontalAlignment alignment;
    private int iconSize;
    private int horizontalTextOffset = 2;
    private int verticalTextOffset = 1;
    private boolean textShadow = true;

    public IconWithLabelRenderable(Font font, int x, int y, int width, int height, HorizontalAlignment alignment, IconWithLabel iconWithLabel) {
        super(x, y, width, height);
        this.font = font;
        this.alignment = alignment;
        this.iconWithLabel = iconWithLabel;
        this.iconSize = this.iconWithLabel.icon() != null ? this.height : 0;
    }

    public void setIconSize(int iconSize) {
        this.iconSize = iconSize;
    }

    public void setHorizontalTextOffset(int offset) {
        this.horizontalTextOffset = offset;
    }

    public void setVerticalTextOffset(int verticalTextOffset) {
        this.verticalTextOffset = verticalTextOffset;
    }

    public void setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation icon = this.iconWithLabel.icon();
        Component label = this.iconWithLabel.getLabel();
        int itemWidth = this.font.width((FormattedText)label);
        if (icon != null) {
            itemWidth += this.horizontalTextOffset + this.iconSize;
        }
        int left = (int)this.alignment.getPosition(this.getX(), this.getRight(), itemWidth);
        if (icon != null) {
            RenderUtils.blitFull(guiGraphics, icon, left, this.y, left + this.iconSize, this.y + this.iconSize, this.iconWithLabel.iconColor());
            left += this.iconSize + this.horizontalTextOffset;
        }
        Component component = this.iconWithLabel.getLabel();
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, component, left, this.y - (this.height - 9) / 2 + this.verticalTextOffset, this.iconWithLabel.labelColor(), this.textShadow);
    }
}

