/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common;

import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import tnt.tarkovcraft.core.api.MovementStaminaComponent;
import tnt.tarkovcraft.core.common.TarkovCraftCommand;
import tnt.tarkovcraft.core.common.attribute.AttributeInstance;
import tnt.tarkovcraft.core.common.attribute.AttributeSystem;
import tnt.tarkovcraft.core.common.attribute.EntityAttributeData;
import tnt.tarkovcraft.core.common.attribute.WeightChangeAttributeListener;
import tnt.tarkovcraft.core.common.energy.EnergySystem;
import tnt.tarkovcraft.core.common.init.CoreAttributes;
import tnt.tarkovcraft.core.common.init.CoreDataAttachments;
import tnt.tarkovcraft.core.common.init.CoreSkillTriggerEvents;
import tnt.tarkovcraft.core.common.init.CoreStatistics;
import tnt.tarkovcraft.core.common.skill.SkillSystem;
import tnt.tarkovcraft.core.common.statistic.CustomStatTrackerProvider;
import tnt.tarkovcraft.core.common.statistic.Statistic;
import tnt.tarkovcraft.core.common.statistic.StatisticTracker;
import tnt.tarkovcraft.core.common.weight.EntityWeightContainerListener;
import tnt.tarkovcraft.core.common.weight.WeightSystem;

public final class TarkovCraftCoreEventHandler {
    @SubscribeEvent
    private void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        CommandBuildContext context = event.getBuildContext();
        TarkovCraftCommand.create((CommandDispatcher<CommandSourceStack>)dispatcher, context);
    }

    @SubscribeEvent
    private void onEntityAdded(EntityJoinLevelEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity.getType() == EntityType.PLAYER) {
            Player player = (Player)entity;
            WeightSystem.applyWeightEffects((LivingEntity)player);
            player.containerMenu.addSlotListener((ContainerListener)new EntityWeightContainerListener((LivingEntity)player));
            EntityAttributeData attributeData = AttributeSystem.getAttributes((Entity)player);
            AttributeInstance instance = attributeData.getAttribute(CoreAttributes.WEIGHT_LIMIT);
            instance.addListener(new WeightChangeAttributeListener((LivingEntity)player));
        }
    }

    @SubscribeEvent
    private void onPlayerTickPost(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide() && SkillSystem.trigger(CoreSkillTriggerEvents.PLAYER_TICK, (Entity)player)) {
            SkillSystem.synchronize((Entity)player);
        }
        if (player.isSprinting()) {
            MovementStaminaComponent component = EnergySystem.MOVEMENT_STAMINA.getComponent();
            component.onSprint((LivingEntity)player);
        }
    }

    @SubscribeEvent
    private void onEntityHurt(LivingDamageEvent.Post event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        Entity sourceEntity = source.getEntity();
        if (sourceEntity != null) {
            long distance = (long)(entity.distanceTo(sourceEntity) * 100.0f);
            StatisticTracker.replace((IAttachmentHolder)sourceEntity, CoreStatistics.LONGEST_HIT, distance, Math::max);
        }
    }

    @SubscribeEvent
    private void onEntityDeath(LivingDeathEvent event) {
        DamageSource source;
        Entity killer;
        LivingEntity entity = event.getEntity();
        if (entity == (killer = (source = event.getSource()).getEntity())) {
            return;
        }
        if (killer != null && killer.hasData(CoreDataAttachments.STATISTICS)) {
            CustomStatTrackerProvider tracker;
            Holder<Statistic> counter;
            StatisticTracker.increment((IAttachmentHolder)killer, CoreStatistics.KILLS);
            long distance = (long)(entity.distanceTo(killer) * 100.0f);
            StatisticTracker.replace((IAttachmentHolder)killer, CoreStatistics.LONGEST_KILL, distance, Math::max);
            if (entity instanceof CustomStatTrackerProvider && (counter = (tracker = (CustomStatTrackerProvider)entity).getKillCounter(killer)) != null) {
                StatisticTracker.increment((IAttachmentHolder)killer, counter);
            }
        }
        if (entity.hasData(CoreDataAttachments.STATISTICS)) {
            CustomStatTrackerProvider tracker;
            Holder<Statistic> counter;
            StatisticTracker.increment((IAttachmentHolder)entity, CoreStatistics.DEATHS);
            if (killer instanceof CustomStatTrackerProvider && (counter = (tracker = (CustomStatTrackerProvider)killer).getDeathCounter((Entity)entity)) != null) {
                StatisticTracker.increment((IAttachmentHolder)entity, counter);
            }
        }
    }

    @SubscribeEvent
    private void onExperiencePickup(PlayerXpEvent.PickupXp event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        ExperienceOrb orb = event.getOrb();
        int value = orb.getValue();
        SkillSystem.triggerAndSynchronize(CoreSkillTriggerEvents.XP_PICKUP, (Entity)player, (float)value);
    }

    @SubscribeEvent
    private void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        List tooltip = event.getToolTip();
        int weight = WeightSystem.getItemWeight(stack);
        if (weight > 0) {
            Component component = WeightSystem.getWeightDisplay(weight);
            tooltip.add(component);
        }
    }

    @SubscribeEvent
    private void onPlayerContainerClosed(PlayerContainerEvent.Close event) {
        WeightSystem.applyWeightEffects((LivingEntity)event.getEntity());
    }
}

