/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.attribute.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import tnt.tarkovcraft.core.common.attribute.AttributeInstance;
import tnt.tarkovcraft.core.common.attribute.modifier.AttributeModifier;
import tnt.tarkovcraft.core.common.attribute.modifier.AttributeModifierType;
import tnt.tarkovcraft.core.common.init.CoreAttributeModifiers;

public class MultiplyValueAttributeModifier
extends AttributeModifier {
    public static final MapCodec<MultiplyValueAttributeModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UUIDUtil.STRING_CODEC.fieldOf("id").forGetter(AttributeModifier::identifier), (App)Codec.DOUBLE.fieldOf("value").forGetter(t -> t.value), (App)Codec.INT.optionalFieldOf("order", (Object)300).forGetter(t -> t.ordering)).apply((Applicative)instance, MultiplyValueAttributeModifier::new));
    private final double value;
    private final int ordering;

    public MultiplyValueAttributeModifier(UUID identifier, double value) {
        this(identifier, value, 300);
    }

    public MultiplyValueAttributeModifier(UUID identifier, double value, int ordering) {
        super(identifier);
        this.value = value;
        this.ordering = ordering;
    }

    @Override
    public double calculateValue(AttributeInstance source, double value) {
        return value * this.value;
    }

    @Override
    public int ordering() {
        return this.ordering;
    }

    @Override
    public AttributeModifierType<?> getType() {
        return CoreAttributeModifiers.MUL_VALUE.get();
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s: MultiplyValue=[value=%f]", this.identifier(), this.value);
    }
}

