/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import org.jetbrains.annotations.Nullable;
import tnt.tarkovcraft.core.TarkovCraftCore;

public class CallbackAttachmentSerializer<V>
implements IAttachmentSerializer<Tag, V> {
    private final Codec<V> codec;
    private final BiConsumer<V, IAttachmentHolder> holderConsumer;

    private CallbackAttachmentSerializer(Codec<V> codec, BiConsumer<V, IAttachmentHolder> holderConsumer) {
        this.codec = codec;
        this.holderConsumer = holderConsumer;
    }

    public static <V> CallbackAttachmentSerializer<V> create(Codec<V> codec, BiConsumer<V, IAttachmentHolder> holderConsumer) {
        Objects.requireNonNull(codec);
        Objects.requireNonNull(holderConsumer);
        return new CallbackAttachmentSerializer<V>(codec, holderConsumer);
    }

    @Nullable
    public Tag write(V attachment, HolderLookup.Provider provider) {
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        DataResult result = this.codec.encodeStart((DynamicOps)ops, attachment);
        Optional optional = result.resultOrPartial(error -> TarkovCraftCore.LOGGER.warn("Failed to fully serialize data attachment due to error: {}", error));
        return optional.orElseGet(() -> (Tag)result.getOrThrow(message -> new IllegalStateException("Failed to serialize data attachment due to error: " + message)));
    }

    public V read(IAttachmentHolder holder, Tag tag, HolderLookup.Provider provider) {
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        DataResult result = this.codec.parse((DynamicOps)ops, (Object)tag);
        Optional optional = result.resultOrPartial(error -> TarkovCraftCore.LOGGER.warn("Failed to fully deserialize data attachment due to error: {}", error));
        Object attachment = optional.orElseGet(() -> result.getOrThrow(message -> new IllegalStateException("Failed to deserialize data attachment due to error: " + message)));
        this.holderConsumer.accept(attachment, holder);
        return (V)attachment;
    }
}

