/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.skill;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.ExtraCodecs;
import tnt.tarkovcraft.core.common.data.duration.Duration;
import tnt.tarkovcraft.core.common.data.number.ConstantNumberProvider;
import tnt.tarkovcraft.core.common.data.number.NumberProvider;
import tnt.tarkovcraft.core.common.data.number.NumberProviderType;

public final class SkillMemoryConfiguration {
    public static final Codec<SkillMemoryConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("enabled", (Object)true).forGetter(SkillMemoryConfiguration::isEnabled), (App)Codec.BOOL.optionalFieldOf("canLoseLevel", (Object)false).forGetter(SkillMemoryConfiguration::canLoseLevel), (App)NumberProviderType.complexCodec(ExtraCodecs.POSITIVE_INT).fieldOf("forgetAfter").forGetter(t -> Either.left((Object)t.forgetAfter)), (App)NumberProviderType.complexCodecNoDuration(ExtraCodecs.POSITIVE_FLOAT).fieldOf("forgetAmount").forGetter(t -> Either.left((Object)t.forgetAmount))).apply((Applicative)instance, SkillMemoryConfiguration::new));
    public static final SkillMemoryConfiguration NO_LOSS = new SkillMemoryConfiguration(false, false, (Either<NumberProvider, Either<Duration, Integer>>)Either.left((Object)ConstantNumberProvider.MAX_INT), (Either<NumberProvider, Float>)Either.left((Object)ConstantNumberProvider.ZERO));
    private final boolean canForget;
    private final boolean canLoseLevel;
    private final NumberProvider forgetAfter;
    private final NumberProvider forgetAmount;

    public SkillMemoryConfiguration(boolean canForget, boolean canLoseLevel, Either<NumberProvider, Either<Duration, Integer>> forgetAfter, Either<NumberProvider, Float> forgetAmount) {
        this.canForget = canForget;
        this.canLoseLevel = canLoseLevel;
        this.forgetAfter = NumberProviderType.resolve(forgetAfter);
        this.forgetAmount = NumberProviderType.resolveNoDuration(forgetAmount);
    }

    public boolean isEnabled() {
        return this.canForget;
    }

    public boolean canLoseLevel() {
        return this.canLoseLevel;
    }

    public long getForgetAfter() {
        return Math.max(1L, this.forgetAfter.map(Double::longValue));
    }

    public float getForgetAmount() {
        return Math.max(0.0f, this.forgetAmount.floatValue());
    }
}

