/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.skill.tracker;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import tnt.tarkovcraft.core.common.init.CoreSkillTrackers;
import tnt.tarkovcraft.core.common.skill.SkillContext;
import tnt.tarkovcraft.core.common.skill.tracker.SkillTracker;
import tnt.tarkovcraft.core.common.skill.tracker.SkillTrackerType;
import tnt.tarkovcraft.core.common.weight.WeightSystem;

public class OverweightFactorSkillTracker
implements SkillTracker {
    public static final MapCodec<OverweightFactorSkillTracker> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("value").forGetter(t -> Float.valueOf(t.value)), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("limit", (Object)Float.valueOf(2.5f)).forGetter(t -> Float.valueOf(t.limit)), (App)Codec.BOOL.optionalFieldOf("countOverLimit", (Object)false).forGetter(t -> t.countOverLimit)).apply((Applicative)instance, OverweightFactorSkillTracker::new));
    private final float value;
    private final float limit;
    private final boolean countOverLimit;

    public OverweightFactorSkillTracker(float value, float limit, boolean countOverLimit) {
        this.value = value;
        this.limit = limit;
        this.countOverLimit = countOverLimit;
    }

    @Override
    public boolean isTriggerable(SkillContext context) {
        LivingEntity livingEntity;
        Entity entity = context.entity();
        return entity instanceof LivingEntity && WeightSystem.isOverweight(livingEntity = (LivingEntity)entity);
    }

    @Override
    public float trigger(SkillContext context) {
        LivingEntity entity = context.asLivingEntity();
        if (entity == null) {
            return 0.0f;
        }
        float factor = WeightSystem.getOverweightEffectFactor(entity);
        if ((double)factor <= 0.0) {
            return 0.0f;
        }
        if (factor >= this.limit) {
            return this.countOverLimit ? this.value : 0.0f;
        }
        return this.value * (1.0f - factor / this.limit);
    }

    @Override
    public SkillTrackerType<?> getType() {
        return CoreSkillTrackers.OVERWEIGHT_FACTOR.get();
    }
}

