/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.statistic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import tnt.tarkovcraft.core.common.init.CoreRegistries;
import tnt.tarkovcraft.core.common.statistic.Statistic;
import tnt.tarkovcraft.core.common.statistic.StatisticReader;
import tnt.tarkovcraft.core.util.Codecs;
import tnt.tarkovcraft.core.util.NumberOperator;
import tnt.tarkovcraft.core.util.UnitFormat;

public final class DisplayStatistic {
    public static final Codec<DisplayStatistic> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.fieldOf("label").forGetter(t -> t.label), (App)UnitFormat.CODEC.optionalFieldOf("format", (Object)UnitFormat.IDENTITY).forGetter(t -> t.format), (App)CoreRegistries.STATISTICS.holderByNameCodec().fieldOf("source").forGetter(t -> t.source), (App)Codecs.NON_NEGATIVE_INT.optionalFieldOf("order", (Object)0).forGetter(t -> t.order), (App)Codecs.list(ExtraCalculation.CODEC).optionalFieldOf("extra", Collections.emptyList()).forGetter(t -> t.extra)).apply((Applicative)instance, DisplayStatistic::new));
    private final Component label;
    private final UnitFormat format;
    private final Holder<Statistic> source;
    private final int order;
    private final List<ExtraCalculation> extra;

    public DisplayStatistic(Component label, UnitFormat format, Holder<Statistic> source, int order, List<ExtraCalculation> extra) {
        this.label = label;
        this.format = format;
        this.source = source;
        this.order = order;
        this.extra = extra;
    }

    public Component getLabel() {
        return this.label;
    }

    public int getOrder() {
        return this.order;
    }

    public String get(StatisticReader reader) {
        double value = reader.get(this.source);
        for (ExtraCalculation calculation : this.extra) {
            double stat = reader.getMinimum(calculation.source, calculation.min);
            value = calculation.operator.applyAsDouble(value, stat);
        }
        return this.format.format(value);
    }

    public record ExtraCalculation(Holder<Statistic> source, long min, NumberOperator operator) {
        public static final Codec<ExtraCalculation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CoreRegistries.STATISTICS.holderByNameCodec().fieldOf("source").forGetter(ExtraCalculation::source), (App)Codec.LONG.optionalFieldOf("min", (Object)0L).forGetter(ExtraCalculation::min), (App)NumberOperator.CODEC.fieldOf("operator").forGetter(ExtraCalculation::operator)).apply((Applicative)instance, ExtraCalculation::new));
    }
}

