/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.weight;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import tnt.tarkovcraft.core.TarkovCraftCore;
import tnt.tarkovcraft.core.common.weight.WeightSystem;

public final class EntityWeightContainerListener
implements ContainerListener {
    public static final ResourceLocation IDENTIFIER = TarkovCraftCore.createResourceLocation("inventory_listener/weight");
    private final LivingEntity entity;

    public EntityWeightContainerListener(LivingEntity entity) {
        this.entity = entity;
    }

    public void slotChanged(AbstractContainerMenu containerToSend, int dataSlotIndex, ItemStack stack) {
        WeightSystem.applyWeightEffects(this.entity);
    }

    public void dataChanged(AbstractContainerMenu containerMenu, int dataSlotIndex, int value) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof EntityWeightContainerListener)) return false;
        EntityWeightContainerListener listener = (EntityWeightContainerListener)o;
        if (listener.entity.getId() != this.entity.getId()) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(IDENTIFIER);
    }
}

