/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.util;

import java.util.function.Consumer;
import java.util.function.Supplier;

public final class Lazy<T>
implements Supplier<T> {
    private Supplier<T> provider;
    private T value;

    private Lazy(Supplier<T> provider) {
        this.provider = provider;
    }

    public static <T> Lazy<T> of(Supplier<T> provider) {
        return new Lazy<T>(provider);
    }

    public static <T> Lazy<T> of(T value) {
        return new Lazy<Object>(() -> value);
    }

    public static <T> Lazy<T> empty() {
        return new Lazy<T>(null);
    }

    @Override
    public T get() {
        if (this.value != null) {
            return this.value;
        }
        if (this.provider == null) {
            return null;
        }
        this.value = this.provider.get();
        this.provider = null;
        return this.value;
    }

    public void ifPresent(Consumer<T> consumer) {
        if (this.value != null) {
            consumer.accept(this.value);
        }
    }
}

