/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.util;

import io.netty.buffer.ByteBuf;
import java.util.function.DoubleBinaryOperator;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public enum NumberOperator implements DoubleBinaryOperator,
StringRepresentable
{
    ADD("add", Double::sum),
    SUBTRACT("subtract", (l, r) -> l - r),
    MULTIPLY("multiply", (l, r) -> l * r),
    DIVIDE("divide", (l, r) -> l / r),
    MIN("min", Math::min),
    MAX("max", Math::max);

    public static final StringRepresentable.EnumCodec<NumberOperator> CODEC;
    public static final IntFunction<NumberOperator> BY_ID;
    public static final StreamCodec<ByteBuf, NumberOperator> STREAM_CODEC;
    private final String name;
    private final DoubleBinaryOperator operator;

    private NumberOperator(String name, DoubleBinaryOperator operator) {
        this.name = name;
        this.operator = operator;
    }

    @Override
    public double applyAsDouble(double left, double right) {
        return this.operator.applyAsDouble(left, right);
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(NumberOperator::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])NumberOperator.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

