/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.util.helper;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public final class ARGB {
    public static int alpha(int color) {
        return color >>> 24;
    }

    public static int red(int color) {
        return color >> 16 & 0xFF;
    }

    public static int green(int color) {
        return color >> 8 & 0xFF;
    }

    public static int blue(int color) {
        return color & 0xFF;
    }

    public static int color(int alpha, int red, int green, int blue) {
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static int color(int red, int green, int blue) {
        return ARGB.color(255, red, green, blue);
    }

    public static int color(Vec3 p_color) {
        return ARGB.color(ARGB.as8BitChannel((float)p_color.x()), ARGB.as8BitChannel((float)p_color.y()), ARGB.as8BitChannel((float)p_color.z()));
    }

    public static int multiply(int color1, int color2) {
        if (color1 == -1) {
            return color2;
        }
        return color2 == -1 ? color1 : ARGB.color(ARGB.alpha(color1) * ARGB.alpha(color2) / 255, ARGB.red(color1) * ARGB.red(color2) / 255, ARGB.green(color1) * ARGB.green(color2) / 255, ARGB.blue(color1) * ARGB.blue(color2) / 255);
    }

    public static int scaleRGB(int color, float scale) {
        return ARGB.scaleRGB(color, scale, scale, scale);
    }

    public static int scaleRGB(int p_color, float redScale, float greenScale, float blueScale) {
        return ARGB.color(ARGB.alpha(p_color), Math.clamp((long)((int)((float)ARGB.red(p_color) * redScale)), 0, 255), Math.clamp((long)((int)((float)ARGB.green(p_color) * greenScale)), 0, 255), Math.clamp((long)((int)((float)ARGB.blue(p_color) * blueScale)), 0, 255));
    }

    public static int scaleRGB(int p_color, int scale) {
        return ARGB.color(ARGB.alpha(p_color), Math.clamp((long)ARGB.red(p_color) * (long)scale / 255L, 0, 255), Math.clamp((long)ARGB.green(p_color) * (long)scale / 255L, 0, 255), Math.clamp((long)ARGB.blue(p_color) * (long)scale / 255L, 0, 255));
    }

    public static int greyscale(int p_color) {
        int i = (int)((float)ARGB.red(p_color) * 0.3f + (float)ARGB.green(p_color) * 0.59f + (float)ARGB.blue(p_color) * 0.11f);
        return ARGB.color(i, i, i);
    }

    public static int lerp(float delta, int color1, int color2) {
        int i = Mth.lerpInt((float)delta, (int)ARGB.alpha(color1), (int)ARGB.alpha(color2));
        int j = Mth.lerpInt((float)delta, (int)ARGB.red(color1), (int)ARGB.red(color2));
        int k = Mth.lerpInt((float)delta, (int)ARGB.green(color1), (int)ARGB.green(color2));
        int l = Mth.lerpInt((float)delta, (int)ARGB.blue(color1), (int)ARGB.blue(color2));
        return ARGB.color(i, j, k, l);
    }

    public static int opaque(int color) {
        return color | 0xFF000000;
    }

    public static int transparent(int color) {
        return color & 0xFFFFFF;
    }

    public static int color(int alpha, int color) {
        return alpha << 24 | color & 0xFFFFFF;
    }

    public static int color(float alpha, int color) {
        return ARGB.as8BitChannel(alpha) << 24 | color & 0xFFFFFF;
    }

    public static int white(float alpha) {
        return ARGB.as8BitChannel(alpha) << 24 | 0xFFFFFF;
    }

    public static int colorFromFloat(float alpha, float red, float green, float blue) {
        return ARGB.color(ARGB.as8BitChannel(alpha), ARGB.as8BitChannel(red), ARGB.as8BitChannel(green), ARGB.as8BitChannel(blue));
    }

    public static Vector3f vector3fFromRGB24(int color) {
        float f = (float)ARGB.red(color) / 255.0f;
        float f1 = (float)ARGB.green(color) / 255.0f;
        float f2 = (float)ARGB.blue(color) / 255.0f;
        return new Vector3f(f, f1, f2);
    }

    public static int average(int color1, int color2) {
        return ARGB.color((ARGB.alpha(color1) + ARGB.alpha(color2)) / 2, (ARGB.red(color1) + ARGB.red(color2)) / 2, (ARGB.green(color1) + ARGB.green(color2)) / 2, (ARGB.blue(color1) + ARGB.blue(color2)) / 2);
    }

    public static int as8BitChannel(float value) {
        return Mth.floor((float)(value * 255.0f));
    }

    public static float alphaFloat(int color) {
        return ARGB.from8BitChannel(ARGB.alpha(color));
    }

    public static float redFloat(int color) {
        return ARGB.from8BitChannel(ARGB.red(color));
    }

    public static float greenFloat(int color) {
        return ARGB.from8BitChannel(ARGB.green(color));
    }

    public static float blueFloat(int color) {
        return ARGB.from8BitChannel(ARGB.blue(color));
    }

    private static float from8BitChannel(int value) {
        return (float)value / 255.0f;
    }

    public static int toABGR(int color) {
        return color & 0xFF00FF00 | (color & 0xFF0000) >> 16 | (color & 0xFF) << 16;
    }

    public static int fromABGR(int color) {
        return ARGB.toABGR(color);
    }

    public static int setBrightness(int p_color, float brightness) {
        float f2;
        int i = ARGB.red(p_color);
        int j = ARGB.green(p_color);
        int k = ARGB.blue(p_color);
        int l = ARGB.alpha(p_color);
        int i1 = Math.max(Math.max(i, j), k);
        int j1 = Math.min(Math.min(i, j), k);
        float f = i1 - j1;
        float f1 = i1 != 0 ? f / (float)i1 : 0.0f;
        if (f1 == 0.0f) {
            f2 = 0.0f;
        } else {
            float f3 = (float)(i1 - i) / f;
            float f4 = (float)(i1 - j) / f;
            float f5 = (float)(i1 - k) / f;
            f2 = i == i1 ? f5 - f4 : (j == i1 ? 2.0f + f3 - f5 : 4.0f + f4 - f3);
            if ((f2 /= 6.0f) < 0.0f) {
                f2 += 1.0f;
            }
        }
        if (f1 == 0.0f) {
            j = k = Math.round(brightness * 255.0f);
            i = k;
            return ARGB.color(l, i, j, k);
        }
        float f8 = (f2 - (float)Math.floor(f2)) * 6.0f;
        float f9 = f8 - (float)Math.floor(f8);
        float f10 = brightness * (1.0f - f1);
        float f6 = brightness * (1.0f - f1 * f9);
        float f7 = brightness * (1.0f - f1 * (1.0f - f9));
        switch ((int)f8) {
            case 0: {
                i = Math.round(brightness * 255.0f);
                j = Math.round(f7 * 255.0f);
                k = Math.round(f10 * 255.0f);
                break;
            }
            case 1: {
                i = Math.round(f6 * 255.0f);
                j = Math.round(brightness * 255.0f);
                k = Math.round(f10 * 255.0f);
                break;
            }
            case 2: {
                i = Math.round(f10 * 255.0f);
                j = Math.round(brightness * 255.0f);
                k = Math.round(f7 * 255.0f);
                break;
            }
            case 3: {
                i = Math.round(f10 * 255.0f);
                j = Math.round(f6 * 255.0f);
                k = Math.round(brightness * 255.0f);
                break;
            }
            case 4: {
                i = Math.round(f7 * 255.0f);
                j = Math.round(f10 * 255.0f);
                k = Math.round(brightness * 255.0f);
                break;
            }
            case 5: {
                i = Math.round(brightness * 255.0f);
                j = Math.round(f10 * 255.0f);
                k = Math.round(f6 * 255.0f);
            }
        }
        return ARGB.color(l, i, j, k);
    }
}

