/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.command.EnumArgument;
import tnt.tarkovcraft.core.common.Notification;
import tnt.tarkovcraft.core.common.attribute.Attribute;
import tnt.tarkovcraft.core.common.attribute.AttributeInstance;
import tnt.tarkovcraft.core.common.attribute.AttributeSystem;
import tnt.tarkovcraft.core.common.attribute.EntityAttributeData;
import tnt.tarkovcraft.core.common.attribute.modifier.AttributeModifier;
import tnt.tarkovcraft.core.common.attribute.modifier.SetValueAttributeModifier;
import tnt.tarkovcraft.core.common.init.CoreDataAttachments;
import tnt.tarkovcraft.core.common.init.CoreRegistries;
import tnt.tarkovcraft.core.common.mail.MailMessage;
import tnt.tarkovcraft.core.common.mail.MailSource;
import tnt.tarkovcraft.core.common.mail.MailSystem;
import tnt.tarkovcraft.core.common.skill.Skill;
import tnt.tarkovcraft.core.common.skill.SkillData;
import tnt.tarkovcraft.core.common.skill.SkillDefinition;
import tnt.tarkovcraft.core.common.skill.SkillMemoryConfiguration;
import tnt.tarkovcraft.core.common.statistic.Statistic;
import tnt.tarkovcraft.core.common.statistic.StatisticTracker;
import tnt.tarkovcraft.core.network.message.S2C_SendDataAttachments;

public final class TarkovCraftCommand {
    private static final SimpleCommandExceptionType INVALID_ENTITY = new SimpleCommandExceptionType((Message)Component.translatable((String)"command.tarkovcraft_core.exception.invalid_entity"));

    public static void create(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tarkovcraft").then(((LiteralArgumentBuilder)Commands.literal((String)"message").requires(MailSystem::isCommandAllowed)).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"content", (ArgumentType)StringArgumentType.string()).executes(TarkovCraftCommand::sendMessage))))).then(((LiteralArgumentBuilder)Commands.literal((String)"notification").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"severity", (ArgumentType)EnumArgument.enumArgument(Notification.Severity.class)).then(((RequiredArgumentBuilder)Commands.argument((String)"content", (ArgumentType)StringArgumentType.string()).executes(TarkovCraftCommand::sendNotification)).then(Commands.argument((String)"lifetime", (ArgumentType)TimeArgument.time((int)20)).executes(TarkovCraftCommand::sendNotificationWithLifetime))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"attribute").requires(src -> src.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"attributeId", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, CoreRegistries.Keys.ATTRIBUTE)).executes(ctx -> TarkovCraftCommand.getAttributeInfo((CommandContext<CommandSourceStack>)ctx, null, false))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).executes(ctx -> TarkovCraftCommand.getAttributeInfo((CommandContext<CommandSourceStack>)ctx, EntityArgument.getEntity((CommandContext)ctx, (String)"target"), false))).then(Commands.literal((String)"force").executes(ctx -> TarkovCraftCommand.getAttributeInfo((CommandContext<CommandSourceStack>)ctx, EntityArgument.getEntity((CommandContext)ctx, (String)"target"), true)))).then(Commands.literal((String)"addModifier").then(Commands.argument((String)"setValue", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ctx -> TarkovCraftCommand.updateAttributeModifier((CommandContext<CommandSourceStack>)ctx, false))))).then(Commands.literal((String)"removeModifier").executes(ctx -> TarkovCraftCommand.updateAttributeModifier((CommandContext<CommandSourceStack>)ctx, true))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"skill").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"skillId", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, CoreRegistries.DatapackKeys.SKILL_DEFINITION)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.literal((String)"level").then(Commands.argument((String)"levelValue", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(TarkovCraftCommand::setSkillLevel)))).then(Commands.literal((String)"experience").then(Commands.argument((String)"experienceValue", (ArgumentType)FloatArgumentType.floatArg((float)0.001f)).executes(TarkovCraftCommand::addSkillExperience)))).then(Commands.literal((String)"forget").then(Commands.argument((String)"experienceValue", (ArgumentType)FloatArgumentType.floatArg((float)0.001f)).executes(TarkovCraftCommand::forgetSkillExperience))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"stat").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"statId", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, CoreRegistries.Keys.STATISTICS)).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"value", (ArgumentType)LongArgumentType.longArg((long)0L)).executes(TarkovCraftCommand::setStatValue))))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.entity()).then(Commands.literal((String)"reset").executes(TarkovCraftCommand::resetStats)))));
    }

    private static int updateAttributeModifier(CommandContext<CommandSourceStack> ctx, boolean remove) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(ctx, (String)"target");
        Holder.Reference reference = ResourceArgument.getResource(ctx, (String)"attributeId", CoreRegistries.Keys.ATTRIBUTE);
        Attribute attribute = (Attribute)reference.value();
        UUID systemModifierId = Util.NIL_UUID;
        EntityAttributeData attributeData = (EntityAttributeData)entity.getData(CoreDataAttachments.ENTITY_ATTRIBUTES);
        AttributeInstance instance = attributeData.getAttribute(attribute);
        instance.removeModifier(systemModifierId);
        if (!remove) {
            double value = DoubleArgumentType.getDouble(ctx, (String)"setValue");
            SetValueAttributeModifier modifier = new SetValueAttributeModifier(systemModifierId, value, Integer.MAX_VALUE);
            instance.addModifier(modifier);
        }
        AttributeSystem.sync(entity);
        return 0;
    }

    private static int getAttributeInfo(CommandContext<CommandSourceStack> ctx, @Nullable Entity entity, boolean forceInit) throws CommandSyntaxException {
        if (entity == null) {
            entity = ((CommandSourceStack)ctx.getSource()).getEntity();
        }
        Entity attachmentHolder = null;
        if (entity instanceof IAttachmentHolder) {
            Entity holder;
            attachmentHolder = holder = entity;
        }
        if (attachmentHolder == null) {
            throw INVALID_ENTITY.create();
        }
        Holder.Reference reference = ResourceArgument.getResource(ctx, (String)"attributeId", CoreRegistries.Keys.ATTRIBUTE);
        Attribute attribute = (Attribute)reference.value();
        if (!forceInit && !attachmentHolder.hasData(CoreDataAttachments.ENTITY_ATTRIBUTES)) {
            return TarkovCraftCommand.printAttributeInfo(entity.getDisplayName(), (CommandSourceStack)ctx.getSource(), attribute.createInstance(attachmentHolder));
        }
        EntityAttributeData entityAttributeData = (EntityAttributeData)attachmentHolder.getData(CoreDataAttachments.ENTITY_ATTRIBUTES);
        if (!forceInit && !entityAttributeData.hasAttribute(attribute)) {
            return TarkovCraftCommand.printAttributeInfo(entity.getDisplayName(), (CommandSourceStack)ctx.getSource(), attribute.createInstance(attachmentHolder));
        }
        return TarkovCraftCommand.printAttributeInfo(entity.getDisplayName(), (CommandSourceStack)ctx.getSource(), entityAttributeData.getAttribute(attribute));
    }

    private static int sendNotification(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection targets = EntityArgument.getPlayers(ctx, (String)"target");
        Notification.Severity severity = (Notification.Severity)ctx.getArgument("severity", Notification.Severity.class);
        String content = StringArgumentType.getString(ctx, (String)"content");
        TarkovCraftCommand.createNotificationAndSend(targets, severity, content, 100);
        return 0;
    }

    private static int sendNotificationWithLifetime(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection targets = EntityArgument.getPlayers(ctx, (String)"target");
        Notification.Severity severity = (Notification.Severity)ctx.getArgument("severity", Notification.Severity.class);
        String content = StringArgumentType.getString(ctx, (String)"content");
        int lifetime = (Integer)ctx.getArgument("lifetime", Integer.class);
        TarkovCraftCommand.createNotificationAndSend(targets, severity, content, lifetime);
        return 0;
    }

    private static int sendMessage(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack stack = (CommandSourceStack)context.getSource();
        ServerPlayer sender = stack.getPlayer();
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"target");
        MailSource source = sender != null ? MailSource.player((Player)sender) : MailSource.SYSTEM;
        String message = StringArgumentType.getString(context, (String)"content");
        MailSystem.sendMessage((Player)target, source, MailMessage.simpleChatMessage(source, message));
        return 0;
    }

    private static void createNotificationAndSend(Collection<ServerPlayer> players, Notification.Severity severity, String content, int lifetime) {
        Notification notification = Notification.of(severity, (Component)Component.literal((String)content), lifetime);
        players.forEach(notification::send);
    }

    private static int printAttributeInfo(Component owner, CommandSourceStack stack, AttributeInstance instance) {
        MutableComponent separator = Component.literal((String)"========================================").withStyle(ChatFormatting.GREEN);
        Attribute attribute = instance.getAttribute();
        stack.sendSystemMessage((Component)separator);
        stack.sendSystemMessage((Component)Component.literal((String)"Owner: ").withStyle(ChatFormatting.AQUA).append((Component)owner.copy().withStyle(ChatFormatting.YELLOW)));
        stack.sendSystemMessage((Component)Component.literal((String)"Attribute: ").withStyle(ChatFormatting.AQUA).append((Component)attribute.getDisplayName().copy().withStyle(ChatFormatting.YELLOW)));
        stack.sendSystemMessage((Component)Component.literal((String)"Initial value: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)String.valueOf(attribute.getBaseValue())).withStyle(ChatFormatting.YELLOW)));
        stack.sendSystemMessage((Component)Component.literal((String)"Value: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)String.valueOf(instance.value())).withStyle(ChatFormatting.YELLOW)));
        stack.sendSystemMessage((Component)Component.literal((String)"Active Listeners: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)String.valueOf(instance.getActiveListenerCount())).withStyle(ChatFormatting.YELLOW)));
        Collection<AttributeModifier> modifiers = instance.listModifiers().values();
        stack.sendSystemMessage((Component)Component.literal((String)"Modifiers: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)String.valueOf(modifiers.size())).withStyle(ChatFormatting.YELLOW)));
        for (AttributeModifier modifier : modifiers) {
            stack.sendSystemMessage((Component)Component.literal((String)" - ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)modifier.toString()).withStyle(ChatFormatting.YELLOW)));
        }
        stack.sendSystemMessage((Component)separator);
        return 0;
    }

    private static int setSkillLevel(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Entity target = EntityArgument.getEntity(ctx, (String)"target");
        SkillDefinition skillDefinition = (SkillDefinition)ResourceArgument.getResource(ctx, (String)"skillId", CoreRegistries.DatapackKeys.SKILL_DEFINITION).value();
        int level = IntegerArgumentType.getInteger(ctx, (String)"levelValue");
        int maxLevel = skillDefinition.getLevelDefinition().getMaxLevel();
        int setLevel = Math.min(maxLevel, level);
        SkillData skillData = (SkillData)target.getData(CoreDataAttachments.SKILL);
        Skill instance = skillData.getSkill(skillDefinition);
        instance.forceSetLevel(setLevel);
        skillData.reloadStats();
        if (target instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)target;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new S2C_SendDataAttachments((Entity)player, CoreDataAttachments.SKILL.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return 0;
    }

    private static int addSkillExperience(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Entity target = EntityArgument.getEntity(ctx, (String)"target");
        SkillDefinition skillDefinition = (SkillDefinition)ResourceArgument.getResource(ctx, (String)"skillId", CoreRegistries.DatapackKeys.SKILL_DEFINITION).value();
        float exp = FloatArgumentType.getFloat(ctx, (String)"experienceValue");
        SkillData skillData = (SkillData)target.getData(CoreDataAttachments.SKILL);
        Skill instance = skillData.getSkill(skillDefinition);
        skillData.addExperience(instance, exp);
        instance.setLastExperienceUpdate(target.level().getGameTime());
        if (target instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)target;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new S2C_SendDataAttachments((Entity)player, CoreDataAttachments.SKILL.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return 0;
    }

    private static int forgetSkillExperience(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Entity target = EntityArgument.getEntity(ctx, (String)"target");
        SkillDefinition skillDefinition = (SkillDefinition)ResourceArgument.getResource(ctx, (String)"skillId", CoreRegistries.DatapackKeys.SKILL_DEFINITION).value();
        float exp = FloatArgumentType.getFloat(ctx, (String)"experienceValue");
        SkillData skillData = (SkillData)target.getData(CoreDataAttachments.SKILL);
        Skill instance = skillData.getSkill(skillDefinition);
        SkillMemoryConfiguration memoryCfg = skillDefinition.getMemory();
        instance.loseExperience(exp, memoryCfg, lvl -> skillData.onLevelChange(lvl, instance));
        instance.setLastExperienceUpdate(target.level().getGameTime());
        if (target instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)target;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new S2C_SendDataAttachments((Entity)player, CoreDataAttachments.SKILL.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return 0;
    }

    private static int setStatValue(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Entity target = EntityArgument.getEntity(ctx, (String)"target");
        Statistic statistic = (Statistic)ResourceArgument.getResource(ctx, (String)"statId", CoreRegistries.Keys.STATISTICS).value();
        long value = LongArgumentType.getLong(ctx, (String)"value");
        StatisticTracker tracker = (StatisticTracker)target.getData(CoreDataAttachments.STATISTICS);
        tracker.set(statistic, value);
        target.syncData(CoreDataAttachments.STATISTICS);
        return 0;
    }

    private static int resetStats(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Entity target = EntityArgument.getEntity(ctx, (String)"target");
        StatisticTracker tracker = (StatisticTracker)target.getData(CoreDataAttachments.STATISTICS);
        tracker.resetStatistics();
        target.syncData(CoreDataAttachments.STATISTICS);
        return 0;
    }
}

