/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import tnt.tarkovcraft.core.common.init.CoreItemDataComponents;
import tnt.tarkovcraft.core.common.init.CoreRegistries;
import tnt.tarkovcraft.core.common.item.CurrencyType;

public record Currency(Holder<CurrencyType> type, int amount) {
    public static final Codec<Currency> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CoreRegistries.CURRENCY.holderByNameCodec().fieldOf("type").forGetter(t -> t.type), (App)ExtraCodecs.POSITIVE_INT.fieldOf("amount").forGetter(Currency::amount)).apply((Applicative)instance, Currency::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Currency> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry(CoreRegistries.Keys.CURRENCY), Currency::type, (StreamCodec)ByteBufCodecs.INT, Currency::amount, Currency::new);

    public Currency(Holder<CurrencyType> type) {
        this(type, 1);
    }

    public boolean canMerge(Currency currency) {
        if (!this.type.equals(currency.type)) {
            return false;
        }
        return this.amount < ((CurrencyType)this.type.value()).stackLimit();
    }

    public Pair<Currency, Currency> merge(Currency other) {
        if (!this.canMerge(other)) {
            return new Pair((Object)this, (Object)other);
        }
        int insertedAmount = Math.min(((CurrencyType)this.type.value()).stackLimit() - this.amount, other.amount);
        int remainder = other.amount - insertedAmount;
        if (remainder == 0) {
            return new Pair((Object)new Currency(this.type, this.amount + insertedAmount), null);
        }
        return new Pair((Object)new Currency(this.type, this.amount + insertedAmount), (Object)new Currency(other.type, other.amount - insertedAmount));
    }

    public Pair<Currency, Currency> split() {
        int half = this.amount / 2;
        int diff = this.amount - half;
        return new Pair((Object)new Currency(this.type, diff), (Object)new Currency(this.type, half));
    }

    public void setToItemStack(ItemStack itemStack) {
        itemStack.set(CoreItemDataComponents.CURRENCY, (Object)this);
    }

    public static Currency getFromItemStack(ItemStack stack) {
        return !stack.isEmpty() ? (Currency)stack.get(CoreItemDataComponents.CURRENCY) : null;
    }
}

