/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.mail;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import tnt.tarkovcraft.core.common.init.CoreMailMessageAttachments;
import tnt.tarkovcraft.core.common.mail.MailMessage;
import tnt.tarkovcraft.core.common.mail.MailMessageAttachment;
import tnt.tarkovcraft.core.common.mail.MailMessageAttachmentType;
import tnt.tarkovcraft.core.util.helper.PlayerHelper;

public class MailMessageItemAttachment
implements MailMessageAttachment {
    public static final MapCodec<MailMessageItemAttachment> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("item").forGetter(t -> t.itemStack), (App)Codec.BOOL.optionalFieldOf("claimed", (Object)false).forGetter(t -> t.claimed)).apply((Applicative)instance, MailMessageItemAttachment::new));
    private final ItemStack itemStack;
    private boolean claimed;

    private MailMessageItemAttachment(ItemStack itemStack, boolean claimed) {
        this.itemStack = itemStack;
        this.claimed = claimed;
    }

    public static MailMessageItemAttachment item(ItemStack itemStack) {
        return new MailMessageItemAttachment(itemStack, false);
    }

    @Override
    public boolean isClaimable(MailMessage message, UUID attachmentId, Player player) {
        return !this.claimed && !this.itemStack.isEmpty();
    }

    @Override
    public boolean claim(MailMessage message, UUID attachmentId, Player player) {
        if (this.claimed) {
            return false;
        }
        PlayerHelper.giveItem(this.itemStack.copy(), player);
        this.claimed = true;
        return true;
    }

    public String toString() {
        return String.valueOf(this.getType().identifier()) + "[item=" + String.valueOf(this.itemStack) + ", claimed=" + this.claimed + "]";
    }

    @Override
    public MailMessageAttachmentType<?> getType() {
        return CoreMailMessageAttachments.ITEM.get();
    }
}

