/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.common.mail;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import tnt.tarkovcraft.core.TarkovCraftCore;
import tnt.tarkovcraft.core.common.mail.MailMessage;
import tnt.tarkovcraft.core.util.CommonLabels;

public class MailSource {
    public static final Codec<MailSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.STRING_CODEC.fieldOf("sourceId").forGetter(t -> t.sourceId), (App)ResourceLocation.CODEC.optionalFieldOf("icon").forGetter(t -> Optional.ofNullable(t.icon)), (App)ComponentSerialization.CODEC.fieldOf("name").forGetter(t -> t.name), (App)Codec.BOOL.fieldOf("systemChat").forGetter(t -> t.systemChat)).apply((Applicative)instance, MailSource::new));
    public static final MailSource SYSTEM = MailSource.createSystem(MailMessage.SYSTEM_ID, TarkovCraftCore.createResourceLocation("textures/icons/mail/system.png"));
    private final UUID sourceId;
    private final Component name;
    private final ResourceLocation icon;
    private final boolean systemChat;

    private MailSource(UUID sourceId, Optional<ResourceLocation> icon, Component name, boolean systemChat) {
        this.sourceId = sourceId;
        this.icon = icon.orElse(null);
        this.name = name;
        this.systemChat = systemChat;
    }

    public static MailSource createSystem(UUID sourceId, @Nullable ResourceLocation icon) {
        return new MailSource(sourceId, Optional.ofNullable(icon), CommonLabels.SYSTEM, true);
    }

    public static MailSource player(Player player) {
        return new MailSource(player.getUUID(), Optional.empty(), (Component)Component.literal((String)player.getName().getString()), false);
    }

    public boolean is(UUID uuid) {
        return this.sourceId.equals(uuid);
    }

    public boolean is(Entity entity) {
        return entity != null && this.sourceId.equals(entity.getUUID());
    }

    public UUID getSourceId() {
        return this.sourceId;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public Component getName() {
        return this.name;
    }

    public boolean isSystemChat() {
        return this.systemChat;
    }

    public boolean isChatAllowed() {
        return !this.systemChat && TarkovCraftCore.getConfig().allowMailPlayerMessages;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MailSource)) {
            return false;
        }
        MailSource source = (MailSource)o;
        return Objects.equals(this.sourceId, source.sourceId);
    }

    public int hashCode() {
        return Objects.hashCode(this.sourceId);
    }
}

