/*
 * Decompiled with CFR 0.152.
 */
package tnt.tarkovcraft.core.network.message.mail;

import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import tnt.tarkovcraft.core.TarkovCraftCore;
import tnt.tarkovcraft.core.common.init.CoreDataAttachments;
import tnt.tarkovcraft.core.common.mail.MailManager;
import tnt.tarkovcraft.core.common.mail.MailSource;
import tnt.tarkovcraft.core.common.mail.MailSystem;
import tnt.tarkovcraft.core.network.TarkovCraftCoreNetwork;
import tnt.tarkovcraft.core.network.message.S2C_SendDataAttachments;

public record C2S_MailCreateChat(UUID target) implements CustomPacketPayload
{
    public static final ResourceLocation ID = TarkovCraftCoreNetwork.createId(C2S_MailCreateChat.class);
    public static final CustomPacketPayload.Type<C2S_MailCreateChat> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, C2S_MailCreateChat> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, C2S_MailCreateChat::target, C2S_MailCreateChat::new);

    public void handleMessage(IPayloadContext ctx) {
        Player player = ctx.player();
        MailManager mailManager = (MailManager)player.getData(CoreDataAttachments.MAIL_MANAGER);
        MinecraftServer server = player.getServer();
        ServerPlayer targetPlayer = server.getPlayerList().getPlayer(this.target());
        if (targetPlayer == null) {
            TarkovCraftCore.LOGGER.warn(MailSystem.MARKER, "Player {} is not online, cannot open new chat", (Object)this.target());
            return;
        }
        MailSource source = MailSource.player((Player)targetPlayer);
        MailManager targetMailManager = (MailManager)targetPlayer.getData(CoreDataAttachments.MAIL_MANAGER);
        if (!targetMailManager.isBlocked(source) && !mailManager.hasChat(source)) {
            mailManager.getChat(source);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new S2C_SendDataAttachments((Entity)player, CoreDataAttachments.MAIL_MANAGER.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

